/*
 * common.cc
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdio.h>
#include <string.h>
#include "venus.h"

static unsigned char commset[(COMMANDSET_SIZE + 7) / 8];

/*
 * Returns nonzero if the specified command is enabled.
 */

int commandEnabled(int command)
{
	if (command < 0 || command >= COMMANDSET_SIZE) return 1;
	return (commset[command >> 3] & (1 << (command & 0x7))) != 0;
}

/*
 * Enables all commands.
 */

void enableAllCommands()
{
	memset(commset, ~0, sizeof(commset));
}

/*
 * Expands a path into its directory and file components.
 */

void expandPath(char *path, char *dir, char *file)
{
	char *tag = strrchr(path, '/');

	/* the path is in the form /dir1/dir2/file ? */

	if (tag != NULL)
	{
		strcpy(file, tag + 1);
		strncpy2(dir, path, tag - path + 1);
	}
	else
	{
		/* there is only the file name */

		strcpy(file, path);
		dir[0] = '\0';
	}
}

/*
 * Returns the length in bytes of the given file.
 */

int fileLength(char *filename)
{
	FILE *fs;
	int length = -1;

	if ((fs = fopen(filename, "r")) != NULL)
	{
		fseek(fs, 0, SEEK_END);
		length = ftell(fs);
		fclose(fs);
	}
	return length;
}

/*
 * Gets the hotkey from the specified string.
 */

int hotKey(char *name)
{
	if (name != NULL)
	{
		char *addr = strchr(name, '~');

		if (addr != NULL) return toupper2((unsigned char) addr[1]);
	}
	return KC_NONE;
}

/*
 * Appends a string to the log file.
 */

void logstr(char *format, void *data)
{
	FILE *log_fs;

	if ((log_fs = fopen(DEBUG_FILE, "a")) != NULL)
	{
		fprintf(log_fs, format, data);
		fclose(log_fs);
	}
}

/*
 * Enables or disables the specified command.
 */

void setCommandState(int command, int enable)
{
	if (command >= 0 && command < COMMANDSET_SIZE)
	{
		int bit = 1 << (command & 0x7);

		if (enable) commset[command >> 3] |= bit;
		else commset[command >> 3] &= ~bit;
	}
}

/*
 * Standard strncpy() is braindead.
 */

void strncpy2(char *to, char *from, int size)
{
	while (size-- > 0 && *from != '\0')
	{
		*to++ = *from++;
	}
	*to = '\0';
}

/*
 * toupper() works only with values in the range 0-255.
 */

int toupper2(int code)
{
	return code >= 'a' && code <= 'z' ? code - 'a' + 'A' : code;
}
