/*
 * desktop.cc
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <stddef.h>
#include "desktop.h"
#include "window.h"

/*
 * Background constructor.
 */

Background::Background(Rect bounds): View(bounds)
{
	DEBUG("new Background at %p\n", this);
}

/*
 * Fills the background view rectangle with an uniform pattern.
 */

void Background::draw()
{
	DrawBuf buf;

	moveChar(buf, 176, getColor(C_BACKGROUND), size.x * size.y);
	writeBuf(0, 0, size.x, size.y, buf);
}

/*
 * Desktop constructor.
 */

Desktop::Desktop(Rect bounds, View *(*pbackground)(Rect)): Group(bounds, 0)
{
	DEBUG("new Desktop at %p\n", this);
	if (pbackground != NULL)
	{
		getExtent(bounds);
		insert(background = pbackground(bounds));
	}
	else background = NULL;
}

/*
 * Handles the Desktop's events.
 */

void Desktop::handleEvent(Event &event)
{
	Group::handleEvent(event);
	switch (event.what)
	{
	case EV_COMMAND:
		switch (event.command)
		{
		case CM_NEXT:
			focusNext(1);
			clearEvent(event);
			break;
		case CM_PREV:
			movePast(current, background);
			clearEvent(event);
			break;
		case CM_SHOWCLIPBOARD:
			if (clipwindow != NULL)
			{
				clipwindow->setState(SF_VISIBLE, 1);
				clipwindow->getFocus();
			}
		}
	}
}

/*
 * Creates a standard Background object.
 */

View *Desktop::initBackground(Rect bounds)
{
	return new Background(bounds);
}
