/*
 * editor.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __EDITOR_H__
#define __EDITOR_H__

#include "cluster.h"
#include "inpline.h"

struct FindDialogData
{
	InputLineData find;
	ClusterData options;
};

struct OptionsDialogData
{
	InputLineData tabwidth;
	ClusterData flags;
};

struct ReplaceDialogData
{
	InputLineData find;
	InputLineData replace;
	ClusterData options;
};

struct drawinfo_s
{
	DrawBuf buf;
	int col_codenormal;
	int col_codeselect;
	int col_textnormal;
	int col_textselect;
	int width;
	unsigned char code_nl;
	unsigned char code_tab;
};

struct translatekey_s
{
	int command;
	int keycode;
};

class Editor;

class Indicator: public View
{
protected:
	Editor *link;
public:
	Indicator(Rect bounds);
	void draw();
	virtual void setLink(Editor *alink);
};

#define EDITOR_BLOCKSIZE	4096

enum
{
	ED_FIND,
	ED_READERROR,
	ED_REPLACE,
	ED_REPLACEPROMPT,
	ED_SAVEAS,
	ED_SAVEMODIFY,
	ED_SAVEUNTITLED,
	ED_SEARCHFAILED,
	ED_SETOPTIONS,
	ED_WRITEERROR
};

#define EF_CASESENSITIVE	0x00000001
#define EF_WHOLEWORDSONLY	0x00000002
#define EF_PROMPTONREPLACE	0x00000004
#define EF_REPLACEALL		0x00000008
#define EF_AUTOIDENT		0x00000010
#define EF_MODIFIED		0x00000020
#define EF_READONLY		0x00000040
#define EF_REPLACE		0x00000080
#define EF_SHOWCODES		0x00000100

class Dialog;
class ScrollBar;

class Editor: public View
{
	friend Indicator;
protected:
	static char findstr[MAX_WIDTH];
	static char replacestr[MAX_WIDTH];
	Indicator *ind;
	Point curpos;
	Point delta;
	Point limit;
	ScrollBar *hs;
	ScrollBar *vs;
	char *buffer;
	int buflen;
	int bufsize;
	int curptr;
	int drawline;
	int drawptr;
	int flags;
	int locked;
	int tabwidth;
	int selstart;
	int selend;
public:
	Editor(Rect bounds, ScrollBar *ahs, ScrollBar *avs, Indicator *aind);
	~Editor();
	virtual int bufChar(int ptr);
	virtual int bufPtr(int ptr);
	void changeBounds(Rect bounds);
	virtual int charPos(int ptr, int target);
	virtual int charPtr(int ptr, int target);
	virtual int clipCopy();
	virtual void clipCut();
	virtual void clipPaste();
	virtual void convertEvent(Event &event);
	virtual int countBufLines(int from, int to);
	virtual int countLines(char *buf, int count);
	virtual void deleteSelect();
	virtual void deleteText(int start, int end);
	virtual void doSearchReplace();
	void draw();
	virtual void drawLines(int y, int count, int ptr);
	virtual void enableCommands(int enable);
	virtual void findString();
	virtual void formatLine(drawinfo_s *info, int ptr);
	virtual int getMousePtr(Point mouse);
	virtual int getNextTab(int x);
	void handleEvent(Event &event);
	virtual int hasSelection();
	virtual void insertText(char *buf, int length, int select);
	virtual void insertTo(Editor *target, int select);
	virtual int isClipboard();
	virtual int isCursorVisible();
	virtual int isWholeWord(int ptr, int len);
	virtual int isWordChar(int code);
	virtual int lineEnd(int ptr);
	virtual int lineMove(int ptr, int count);
	virtual int lineStart(int ptr);
	virtual void lockDraw();
	virtual int makeDialog(int type, void *buf);
	virtual void newLine();
	virtual int nextChar(int ptr);
	virtual int nextLine(int ptr);
	virtual int nextWord(int ptr);
	virtual int prevChar(int ptr);
	virtual int prevLine(int ptr);
	virtual int prevWord(int ptr);
	virtual void replaceString();
	virtual int sameChar(char a, char b, int sensitive);
	virtual void scrollTo(int x, int y);
	virtual int searchString(char *find, int opts);
	virtual void setCurAddr(int ptr);
	virtual void setOptions();
	virtual void setSelect(int start, int end);
	virtual void setState(int flag, int enable);
	virtual int strScan(char *buf, int size, char *str, int sense);
	virtual void trackCursor(int center);
	virtual translatekey_s *translateTable();
	virtual void unlockDraw();
	virtual void updateScreen();
};

#endif
