/*
 * label.cc
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <stddef.h>
#include "label.h"

/*
 * Label constructor.
 */

Label::Label(Rect bounds, char *aname, View *alink): View(bounds)
{
	DEBUG("new Label at %p\n", this);
	options |= OF_POSTPROCESS;
	bright = 0;
	link = alink;
	name = aname;
}

/*
 * Draws the Label on the screen.
 */

void Label::draw()
{
	DrawBuf buf;
	int col;

	if (link != NULL && !(link->getState() & SF_ACTIVE))
	{
		col = getColor(C_LABEL);
	}
	else col = bright ? getColor(C_LABEL + 1) : getColor(C_LABEL + 2);
	moveChar(buf, ' ', col, size.x);
	moveCStr(buf, name, col);
	writeBuf(0, 0, size.x, size.y, buf);
}

/*
 * Handles the Label's events.
 */

void Label::handleEvent(Event &event)
{
	View::handleEvent(event);
	switch (event.what)
	{
	case EV_BROADCAST:
		switch (event.command)
		{
		case CM_GOTFOCUS:
		case CM_LOSTFOCUS:
			if (link != NULL)
			{
				bright = (link->getState() & SF_FOCUSED) != 0;
				drawView();
			}
		}
		break;
	case EV_KEYDOWN:
		if (event.keycode == MK_META(hotKey(name)))
		{
			if (link != NULL) link->getFocus();
			clearEvent(event);
		}
		break;
	case EV_MOUSEDOWN:
		if (link != NULL) link->getFocus();
		clearEvent(event);
	}
}
