/*
 * listbox.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __LISTBOX_H__
#define __LISTBOX_H__

#include "listview.h"

struct string_s
{
	char name[MAX_WIDTH];
	string_s *next;
};

class StrList
{
protected:
	int length;
	string_s *first;
public:
	StrList();
	virtual ~StrList();
	virtual void addAlphabetical(char *name);
	virtual void addUnsorted(char *name);
	virtual void clearList();
	virtual void deleteAt(int index);
	virtual char *getAt(int index);
	virtual int getLength();
	virtual int getMaxStrLength();
};

class ListBox: public ListViewer
{
protected:
	StrList *list;
public:
	ListBox(Rect bounds, ScrollBar *hs, ScrollBar *vs, StrList *alist);
	~ListBox();
	virtual void clearList();
	virtual int getLength();
	virtual int getMaxStrLength();
	virtual StrList *getList();
	virtual char *getString();
	virtual char *getText(int item);
};

#endif
