/*
 * listview.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __LISTVIEW_H__
#define __LISTVIEW_H__

#include "venus.h"

struct ListViewerData
{
	int current;
};

class ScrollBar;

class ListViewer: public View
{
protected:
	ListViewerData data;
	ScrollBar *hs;
	ScrollBar *vs;
	int home;
	int left;
public:
	ListViewer(Rect bounds, ScrollBar *ahs, ScrollBar *avs);
	int dataSize();
	void draw();
	virtual int getLength() = 0;
	virtual int getMaxStrLength() = 0;
	virtual char *getText(int item) = 0;
	void getData(void *buf);
	virtual int getValue();
	void handleEvent(Event &event);
	virtual void moveTo(int offset, int current);
	void setData(void *buf);
	void setState(int flag, int enable);
	virtual void updateScreen();
};

#endif
