/*
 * program.cc
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdlib.h>
#include <unistd.h>
#include "config.h"
#include "desktop.h"
#include "menubar.h"
#include "statline.h"
#include "window.h"

/*
 * Program constructor.
 */

Program::Program(Desktop *(*pdesktop)(Rect), MenuBar *(*pmenubar)(Rect),
	StatusLine *(*pstatusline)(Rect)): System(), Group(Rect(0, 0,
	screen_width, screen_height), 1)
{
	DEBUG("new Program at %p\n", this);
	Rect bounds;

	options |= OF_SCREENLINK;
	program = this;
	screen = buffer;

	/* disable standard commands */

	enableAllCommands();
	setCommandState(CM_CLOSE, 0);
	setCommandState(CM_COPY, 0);
	setCommandState(CM_CUT, 0);
	setCommandState(CM_FIND, 0);
	setCommandState(CM_MOVE, 0);
	setCommandState(CM_NEXT, 0);
	setCommandState(CM_PASTE, 0);
	setCommandState(CM_PREV, 0);
	setCommandState(CM_REPLACE, 0);
	setCommandState(CM_RESIZE, 0);
	setCommandState(CM_SAVE, 0);
	setCommandState(CM_SAVEAS, 0);
	setCommandState(CM_SEARCHAGAIN, 0);
	setCommandState(CM_SETOPTIONS, 0);
	setCommandState(CM_ZOOM, 0);
	getExtent(bounds);
	if (pdesktop != NULL) insert(desktop = pdesktop(bounds));
	else desktop = NULL;
	if (pmenubar != NULL) insert(menubar = pmenubar(bounds));
	else menubar = NULL;
	if (pstatusline != NULL) insert(statusline = pstatusline(bounds));
	else statusline = NULL;
}

/*
 * Executes the Dialog in modal state.
 */

int Program::execDialog(Group *obj, void *buf)
{
	int ret = CM_CANCEL;

	if (obj != NULL) 
	{
		if (buf != NULL) obj->setData(buf);
		insert(obj);
		if ((ret = obj->execModal()) != CM_CANCEL && buf != NULL)
		{
			obj->getData(buf);
		}
		delete obj;
	}
	return ret;
}

/*
 * Gets an event from the queue.
 */

void Program::getEvent(Event &event)
{
	System::getEvent(event);
	switch (event.what)
	{
	case EV_BROADCAST:
		handleEvent(event);
		clearEvent(event);
		break;
	case EV_COMMAND:
		switch (event.command)
		{
		case CM_QUIT:
			endModal(event.command);
			clearEvent(event);
			break;
		case CM_REPAINT:
			redrawAll();
			clearEvent(event);
		}
	}
}

/*
 * Returns the Program's palette address.
 */

int *Program::getPalette()
{
	static int console[] =
	{
		0x71,					/* Background */
		0x7470, 0x7878, 0x2420, 0x2828,		/* MenuBar */
		0x7470, 0x7878, 0x2420, 0x2828,		/* StatusLine */
		0x7470, 0x7878, 0x2420, 0x2828,		/* SubMenu */
		0x00, 0x00, 0x00,

		/* blue window palette */

		0x1a, 0x1b, 0x7b, 0x1c, 0x7c,		/* BinEditor */
		0x2f,					/* BinIndicator */
		0x10, 0x2e2b, 0x2828, 0x2e2f, 0x2e20,	/* Button */
		0x1f,					/* CalendarView */
		0x1f,					/* ClockView */
		0x3838, 0x3e30, 0x3e3f,			/* Cluster */
		0x78, 0x1f, 0x5f, 0x17, 0x57,		/* Editor */
		0x1f, 0x1a, 0x1a, 0x10, 0x17,		/* Frame */
		0x78, 0x2f,				/* Indicator */
		0x2e, 0x28, 0x2f,			/* InputLine */
		0x7070, 0x1e1f, 0x7e70,			/* Label */
		0x2f, 0x3e, 0x78, 0x30,			/* ListViewer */
		0x78, 0x7f, 0x2f, 0x4f,			/* ProgressBar */
		0x38, 0x31,				/* ScrollBar */
		0x78, 0x1f,				/* StaticText */
		0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

		/* gray window palette */

		0x1a, 0x1b, 0x7b, 0x1c, 0x7c,		/* BinEditor */
		0x2f,					/* BinIndicator */
		0x70, 0x2e2b, 0x2828, 0x2e2f, 0x2e20,	/* Button */
		0x1f,					/* CalendarView */
		0x1f,					/* ClockView */
		0x3838, 0x3e30, 0x3e3f,			/* Cluster */
		0x78, 0x1f, 0x5f, 0x17, 0x57,		/* Editor */
		0x7f, 0x7a, 0x7a, 0x70, 0x70,		/* Frame */
		0x78, 0x2f,				/* Indicator */
		0x2e, 0x28, 0x2f,			/* InputLine */
		0x7070, 0x7e7f, 0x7e70,			/* Label */
		0x2f, 0x3e, 0x78, 0x30,			/* ListViewer */
		0x78, 0x7f, 0x2f, 0x4f,			/* ProgressBar */
		0x18, 0x13,				/* ScrollBar */
		0x78, 0x70,				/* StaticText */
		0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	};
	static int remote[] =
	{
		0x1,					/* Background */
		0x0102, 0x0203, 0x0304, 0x0405,		/* MenuBar */
		0x0102, 0x0203, 0x0304, 0x0405,		/* StatusLine */
		0x0102, 0x0203, 0x0304, 0x0405,		/* SubMenu */
		0x00, 0x00, 0x00,

		/* blue window palette */

		0x01, 0x02, 0x03, 0x04, 0x05,		/* BinEditor */
		0x01,					/* BinIndicator */
		0x01, 0x0102, 0x0203, 0x0304, 0x0405,	/* Button */
		0x01,					/* CalendarView */
		0x01,					/* ClockView */
		0x0102, 0x0203, 0x0304,			/* Cluster */
		0x01, 0x02, 0x03, 0x04, 0x05,		/* Editor */
		0x01, 0x02, 0x03, 0x04, 0x05,		/* Frame */
		0x01, 0x02,				/* Indicator */
		0x01, 0x02, 0x03,			/* InputLine */
		0x0102, 0x0203, 0x0304,			/* Label */
		0x01, 0x02, 0x03, 0x04,			/* ListViewer */
		0x01, 0x02, 0x03, 0x04,			/* ProgressBar */
		0x01, 0x02,				/* ScrollBar */
		0x01, 0x02,				/* StaticText */
		0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

		/* gray window palette */

		0x01, 0x02, 0x03, 0x04, 0x05,		/* BinEditor */
		0x01,					/* BinIndicator */
		0x01, 0x0102, 0x0203, 0x0304, 0x0405,	/* Button */
		0x01,					/* CalendarView */
		0x01,					/* ClockView */
		0x0102, 0x0203, 0x0304,			/* Cluster */
		0x01, 0x02, 0x03, 0x04, 0x05,		/* Editor */
		0x01, 0x02, 0x03, 0x04, 0x05,		/* Frame */
		0x01, 0x02,				/* Indicator */
		0x01, 0x02, 0x03,			/* InputLine */
		0x0102, 0x0203, 0x0304,			/* Label */
		0x01, 0x02, 0x03, 0x04,			/* ListViewer */
		0x01, 0x02, 0x03, 0x04,			/* ProgressBar */
		0x01, 0x02,				/* ScrollBar */
		0x01, 0x02,				/* StaticText */
		0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	};
	return venusopt & VO_REMOTEMODE ? remote : console;
}

/*
 * Creates a Desktop object for the application and returns a pointer to it.
 */

Desktop *Program::initDesktop(Rect bounds)
{
	bounds.a.y++;
	bounds.b.y--;
	return new Desktop(bounds, &Desktop::initBackground);
}

/*
 * Creates a MenuBar object for the application and returns a pointer to it.
 */

MenuBar *Program::initMenuBar(Rect bounds)
{
	bounds.b.y = bounds.a.y + 1;
	return new MenuBar(bounds,
		newSubMenu("~F~ile",
			newItem("E~x~it", "Alt-X", KC_METAX, CM_QUIT,
			NULL),
		NULL)
	);
}

/*
 * Creates a StatusLine object for the application and returns a pointer to
 * it.
 */

StatusLine *Program::initStatusLine(Rect bounds)
{
	bounds.a.y = bounds.b.y - 1;
	return new StatusLine(bounds,
		new StatusDef(0, ~0,
			new StatusKey("~Alt-X~ Exit", KC_METAX, CM_QUIT,
			NULL),
		NULL)
	);
}

/*
 * Puts an event in the queue.
 */

void Program::putEvent(Event &event)
{
	System::putEvent(event);
}

/*
 * Runs the program.
 */

int Program::run()
{
	return execModal();
}
