/*
 * statline.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __STATLINE_H__
#define __STATLINE_H__

#include "venus.h"

class StatusDef;
class StatusLine;

class StatusKey
{
	friend StatusDef;
	friend StatusLine;
protected:
	StatusKey *next;
	char *text;
	int command;
	int keycode;
public:
	StatusKey(char *atext, int akeycode, int acommand, StatusKey *anext);
};

class StatusDef
{
	friend StatusLine;
protected:
	StatusDef *next;
	StatusKey *items;
	unsigned min;
	unsigned max;
public:
	StatusDef(unsigned amin, unsigned amax, StatusKey *aitems,
		StatusDef *anext);
	~StatusDef();
};

class StatusLine: public View
{
protected:
	StatusDef *defs;
	StatusKey *items;
public:
	StatusLine(Rect bounds, StatusDef *adefs);
	~StatusLine();
	void draw();
	virtual void drawSelect(StatusKey *selected);
	virtual void findItems();
	virtual StatusKey *findMouse(Point mouse);
	virtual char *getHint(unsigned helpctx);
	void handleEvent(Event &event);
};

#endif
