/*
 * window.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __WINDOW_H__
#define __WINDOW_H__

#include "venus.h"

class Window;

class Frame: public View
{
protected:
	Window *wnd;
public:
	Frame(Rect bounds, Window *awnd);
	void draw();
	void handleEvent(Event &event);
};

#define WF_CLOSE	0x00000001
#define WF_MOVE		0x00000002
#define WF_RESIZE	0x00000004
#define WF_ZOOM		0x00000008

enum
{
	WP_BLUEWINDOW,
	WP_GRAYWINDOW
};

class Window: public Group
{
	friend Frame;
protected:
	Rect zoomrect;
	View *frame;
	char title[MAX_WIDTH];
	int flags;
	int palette;
public:
	Window(Rect bounds, char *atitle, View *(*pframe)(Rect, Window *));
	~Window();
	virtual void doClose();
	virtual void doZoom();
	virtual void enableCommands(int enable);
	int *getPalette();
	virtual char *getTitle();
	void handleEvent(Event &event);
	static View *initFrame(Rect bounds, Window *wnd);
	virtual void moveOrResize(Event &offset);
	void setState(int flag, int enable);
	void sizeLimits(Point &min, Point &max);
};

class Dialog: public Window
{
public:
	Dialog(Rect bounds, char *atitle);
	void handleEvent(Event &event);
};

#endif
