/** ********************************************************************
 * C/C++ Source: serialecho.h
 *
 * Class definitions for the SerialEcho and related classes.
 * This package requires the Serial, TTYSession and Thread classes
 * from the FSF Common C++ library (v 1.2.4 cplusplus.sourceforge.net)
 * 
 * SerialEcho is a monitor on the serial port which runs in its own
 * thread and is responsible for detecting and echoing any serial
 * input.  The class is based on the ttysession class so it can be
 * used as any fstream-like class
 *
 * Created: Sat Oct 14 12:35:46 EDT 2000
 * $Log: serialecho.h,v $
 * Revision 1.1  2000/10/15 17:54:54  dyfet
 * serial demo
 *
 * Revision 1.3  2000/10/14 21:08:57  garym
 * First working version of the modem echo
 *
 *
 * @author:  Gary Lawrence Murphy <garym@canada.com>
 * Copyright:  2000 TeleDynamics Communications Inc (www.teledyn.com)
 * @version: $Id: serialecho.h,v 1.1 2000/10/15 17:54:54 dyfet Exp $
 ********************************************************************
*/

#ifndef SERIALECHO_H
#define SERIALECHO_H

#include <cc++/serial.h> // FSF Common C++ Serial Port Library

class SerialEcho : public TTYSession {
 public:

  SerialEcho(const char *device, cc_Semaphore *start = NULL,  
             int priority = 0, int priority = 0);

  // Exception classes
  class xError{}; // nebulous inexplicable error
  class xLocked{}; // port is there but we are locked out
  class xOverrun{}; // too much data, too little time

 protected:

  // Thread methods

  void SerialEcho::OnSignal(int signo);
  void SerialEcho::OnPolling(void);


  void Run();
};

#endif
