/******************************************************************************
 JStdError.h

	Defines the most common errors.

	Copyright  1997 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JStdError
#define _H_JStdError

#include <JError.h>

// Types

extern const JCharacter* kJGeneralIO;

extern const JCharacter* kJSegFault;
extern const JCharacter* kJNoProcessMemory;
extern const JCharacter* kJNoKernelMemory;
extern const JCharacter* kJMemoryNotReadable;
extern const JCharacter* kJMemoryNotWriteable;

extern const JCharacter* kJProgramNotAvailable;
extern const JCharacter* kJFileAlreadyExists;
extern const JCharacter* kJFileDoesNotExist;
extern const JCharacter* kJNameTooLong;
extern const JCharacter* kJFileBusy;
extern const JCharacter* kJInvalidOpenMode;

extern const JCharacter* kJAccessDenied;
extern const JCharacter* kJFileSystemReadOnly;
extern const JCharacter* kJFileSystemFull;
extern const JCharacter* kJDeviceFull;

extern const JCharacter* kJComponentNotDirectory;
extern const JCharacter* kJPathContainsLoop;
extern const JCharacter* kJDirectoryAlreadyExists;
extern const JCharacter* kJBadPath;
extern const JCharacter* kJDirectoryNotEmpty;
extern const JCharacter* kJDirectoryBusy;

extern const JCharacter* kJCantRenameFileToDirectory;
extern const JCharacter* kJCantRenameAcrossFilesystems;
extern const JCharacter* kJCantRenameToNonemptyDirectory;
extern const JCharacter* kJDirectoryCantBeOwnChild;
extern const JCharacter* kJTooManyLinks;

extern const JCharacter* kJTriedToRemoveDirectory;
extern const JCharacter* kJIsADirectory;

extern const JCharacter* kJDescriptorNotOpen;
extern const JCharacter* kJTooManyDescriptorsOpen;
extern const JCharacter* kJNegativeDescriptor;
extern const JCharacter* kJInvalidDescriptor;

extern const JCharacter* kJWouldHaveBlocked;
extern const JCharacter* kJNonBlockedSignal;

extern const JCharacter* kJNotCompressed;

// Messages

extern const JCharacter* kJGeneralIOMsg;

extern const JCharacter* kJSegFaultMsg;
extern const JCharacter* kJNoProcessMemoryMsg;
extern const JCharacter* kJNoKernelMemoryMsg;
extern const JCharacter* kJMemoryNotReadableMsg;
extern const JCharacter* kJMemoryNotWriteableMsg;

extern const JCharacter* kJFileAlreadyExistsMsg;
extern const JCharacter* kJFileDoesNotExistMsg;
extern const JCharacter* kJNameTooLongMsg;
extern const JCharacter* kJFileBusyMsg;
extern const JCharacter* kJInvalidOpenModeMsg;

extern const JCharacter* kJAccessDeniedMsg;
extern const JCharacter* kJFileSystemReadOnlyMsg;
extern const JCharacter* kJFileSystemFullMsg;
extern const JCharacter* kJDeviceFullMsg;

extern const JCharacter* kJComponentNotDirectoryMsg;
extern const JCharacter* kJPathContainsLoopMsg;
extern const JCharacter* kJDirectoryAlreadyExistsMsg;
extern const JCharacter* kJBadPathMsg;
extern const JCharacter* kJDirectoryNotEmptyMsg;
extern const JCharacter* kJDirectoryBusyMsg;

extern const JCharacter* kJCantRenameFileToDirectoryMsg;
extern const JCharacter* kJCantRenameAcrossFilesystemsMsg;
extern const JCharacter* kJCantRenameToNonemptyDirectoryMsg;
extern const JCharacter* kJDirectoryCantBeOwnChildMsg;
extern const JCharacter* kJTooManyLinksMsg;

extern const JCharacter* kJTriedToRemoveDirectoryMsg;
extern const JCharacter* kJIsADirectoryMsg;

extern const JCharacter* kJDescriptorNotOpenMsg;
extern const JCharacter* kJTooManyDescriptorsOpenMsg;
extern const JCharacter* kJNegativeDescriptorMsg;
extern const JCharacter* kJInvalidDescriptorMsg;

extern const JCharacter* kJWouldHaveBlockedMsg;
extern const JCharacter* kJNonBlockedSignalMsg;

extern const JCharacter* kJNotCompressedMsg;

// Classes

class JGeneralIO : public JError
{
public:

	JGeneralIO()
		:
		JError(kJGeneralIO, kJGeneralIOMsg)
		{ };
};


class JSegFault : public JError
{
public:

	JSegFault()
		:
		JError(kJSegFault, kJSegFaultMsg)
		{ };
};

class JNoProcessMemory : public JError
{
public:

	JNoProcessMemory()
		:
		JError(kJNoProcessMemory, kJNoProcessMemoryMsg)
		{ };
};

class JNoKernelMemory : public JError
{
public:

	JNoKernelMemory()
		:
		JError(kJNoKernelMemory, kJNoKernelMemoryMsg)
		{ };
};

class JMemoryNotReadable : public JError
{
public:

	JMemoryNotReadable()
		:
		JError(kJMemoryNotReadable, kJMemoryNotReadableMsg)
		{ };
};

class JMemoryNotWriteable : public JError
{
public:

	JMemoryNotWriteable()
		:
		JError(kJMemoryNotWriteable, kJMemoryNotWriteableMsg)
		{ };
};


class JProgramNotAvailable : public JError
{
public:

	JProgramNotAvailable(const JCharacter* programName);
};

class JFileAlreadyExists : public JError
{
public:

	JFileAlreadyExists()
		:
		JError(kJFileAlreadyExists, kJFileAlreadyExistsMsg)
		{ };
};

class JFileDoesNotExist : public JError
{
public:

	JFileDoesNotExist()
		:
		JError(kJFileDoesNotExist, kJFileDoesNotExistMsg)
		{ };
};

class JNameTooLong : public JError
{
public:

	JNameTooLong()
		:
		JError(kJNameTooLong, kJNameTooLongMsg)
		{ };
};

class JFileBusy : public JError
{
public:

	JFileBusy()
		:
		JError(kJFileBusy, kJFileBusyMsg)
		{ };
};

class JInvalidOpenMode : public JError
{
public:

	JInvalidOpenMode()
		:
		JError(kJInvalidOpenMode, kJInvalidOpenModeMsg)
		{ };
};


class JAccessDenied : public JError
{
public:

	JAccessDenied()
		:
		JError(kJAccessDenied, kJAccessDeniedMsg)
		{ };
};

class JFileSystemReadOnly : public JError
{
public:

	JFileSystemReadOnly()
		:
		JError(kJFileSystemReadOnly, kJFileSystemReadOnlyMsg)
		{ };
};

class JFileSystemFull : public JError
{
public:

	JFileSystemFull()
		:
		JError(kJFileSystemFull, kJFileSystemFullMsg)
		{ };
};

class JDeviceFull : public JError
{
public:

	JDeviceFull()
		:
		JError(kJDeviceFull, kJDeviceFullMsg)
		{ };
};


class JComponentNotDirectory : public JError
{
public:

	JComponentNotDirectory()
		:
		JError(kJComponentNotDirectory, kJComponentNotDirectoryMsg)
		{ };
};

class JPathContainsLoop : public JError
{
public:

	JPathContainsLoop()
		:
		JError(kJPathContainsLoop, kJPathContainsLoopMsg)
		{ };
};

class JDirectoryAlreadyExists : public JError
{
public:

	JDirectoryAlreadyExists()
		:
		JError(kJDirectoryAlreadyExists, kJDirectoryAlreadyExistsMsg)
		{ };
};

class JBadPath : public JError
{
public:

	JBadPath()
		:
		JError(kJBadPath, kJBadPathMsg)
		{ };
};

class JDirectoryNotEmpty : public JError
{
public:

	JDirectoryNotEmpty()
		:
		JError(kJDirectoryNotEmpty, kJDirectoryNotEmptyMsg)
		{ };
};

class JDirectoryBusy : public JError
{
public:

	JDirectoryBusy()
		:
		JError(kJDirectoryBusy, kJDirectoryBusyMsg)
		{ };
};


class JCantRenameFileToDirectory : public JError
{
public:

	JCantRenameFileToDirectory()
		:
		JError(kJCantRenameFileToDirectory, kJCantRenameFileToDirectoryMsg)
		{ };
};

class JCantRenameAcrossFilesystems : public JError
{
public:

	JCantRenameAcrossFilesystems()
		:
		JError(kJCantRenameAcrossFilesystems, kJCantRenameAcrossFilesystemsMsg)
		{ };
};

class JCantRenameToNonemptyDirectory : public JError
{
public:

	JCantRenameToNonemptyDirectory()
		:
		JError(kJCantRenameToNonemptyDirectory, kJCantRenameToNonemptyDirectoryMsg)
		{ };
};

class JDirectoryCantBeOwnChild : public JError
{
public:

	JDirectoryCantBeOwnChild()
		:
		JError(kJDirectoryCantBeOwnChild, kJDirectoryCantBeOwnChildMsg)
		{ };
};

class JTooManyLinks : public JError
{
public:

	JTooManyLinks()
		:
		JError(kJTooManyLinks, kJTooManyLinksMsg)
		{ };
};


class JTriedToRemoveDirectory : public JError
{
public:

	JTriedToRemoveDirectory()
		:
		JError(kJTriedToRemoveDirectory, kJTriedToRemoveDirectoryMsg)
		{ };
};

class JIsADirectory : public JError
{
public:

	JIsADirectory()
		:
		JError(kJIsADirectory, kJIsADirectoryMsg)
		{ };
};


class JDescriptorNotOpen : public JError
{
public:

	JDescriptorNotOpen()
		:
		JError(kJDescriptorNotOpen, kJDescriptorNotOpenMsg)
		{ };
};

class JTooManyDescriptorsOpen : public JError
{
public:

	JTooManyDescriptorsOpen()
		:
		JError(kJTooManyDescriptorsOpen, kJTooManyDescriptorsOpenMsg)
		{ };
};

class JNegativeDescriptor : public JError
{
public:

	JNegativeDescriptor()
		:
		JError(kJNegativeDescriptor, kJNegativeDescriptorMsg)
		{ };
};

class JInvalidDescriptor : public JError
{
public:

	JInvalidDescriptor()
		:
		JError(kJInvalidDescriptor, kJInvalidDescriptorMsg)
		{ };
};


class JWouldHaveBlocked : public JError
{
public:

	JWouldHaveBlocked()
		:
		JError(kJWouldHaveBlocked, kJWouldHaveBlockedMsg)
		{ };
};

class JNonBlockedSignal : public JError
{
public:

	JNonBlockedSignal()
		:
		JError(kJNonBlockedSignal, kJNonBlockedSignalMsg)
		{ };
};


class JNotCompressed : public JError
{
public:

	JNotCompressed()
		:
		JError(kJNotCompressed, kJNotCompressedMsg)
		{ };
};

#endif
