/******************************************************************************
 JXDSSFinishSaveTask.cc

	BASE CLASS = JXUrgentTask

	Copyright  1999 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXDSSFinishSaveTask.h>
#include <JXSaveFileDialog.h>
#include <JString.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXDSSFinishSaveTask::JXDSSFinishSaveTask
	(
	JXSaveFileDialog*	dialog,
	const JCharacter*	dirName
	)
	:
	JXUrgentTask()
{
	itsDialog = dialog;

	itsDirName = new JString(dirName);
	assert( itsDirName != NULL );
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXDSSFinishSaveTask::~JXDSSFinishSaveTask()
{
	delete itsDirName;
}

/******************************************************************************
 Perform

 ******************************************************************************/

void
JXDSSFinishSaveTask::Perform()
{
	itsDialog->Save(*itsDirName);
}
