/******************************************************************************
 JMMRecord.cc

	JMMRecord objects record statistics on a block allocated through
	JMemoryManager.

	For maximum space efficiency JMMRecord does NOT have a virtual destructor.
	It isn't intended to be a base class, so if you do subclass it be careful.

	BASE CLASS = <NONE>

	Copyright  1997 by Dustin Laurence.  All rights reserved.
	
	Base code generated by Codemill v0.1.0

 *****************************************************************************/

//Class Header
#include <JMMRecord.h>

#include <JMemoryManager.h>
#include <JString.h>

#include <stddef.h> // For offsetof
#include <iostream.h>

#include <jAssert.h>

/******************************************************************************
 Constructor

 *****************************************************************************/

JMMRecord::JMMRecord()
	:
	itsAddress(NULL),
	itsNewFile(NULL),
	itsDeleteFile(NULL),
	itsSize(0),

	itsID(0),
	itsNewLine(0),
	itsDeleteLine(0),

	itsMark(0),
	itsArrayNewFlag(kFalse),
	itsArrayDeleteFlag(0),
	itsManagerMemoryFlag(kFalse)
{
}

JMMRecord::JMMRecord
	(
	const JUInt32     id,
	const void*       address,
	const size_t      size,
	const JCharacter* file,
	const JUInt32     lineNumber,
	const JBoolean    array,
	const JBoolean    managerMemory
	)
	:
	itsAddress(address),
	itsNewFile(file),
	itsDeleteFile(NULL),
	itsSize(size),

	itsID(id),
	itsNewLine(lineNumber),
	itsDeleteLine(0),

	itsMark(0),
	itsArrayNewFlag(array),
	itsArrayDeleteFlag(0),
	itsManagerMemoryFlag(managerMemory)
{
	// These values are only allowed in a default constructor, and may only
	// be changed in a copy constructor!
	assert(itsAddress != NULL);
	assert(itsSize != 0);
	assert(itsNewFile != NULL);
}

/******************************************************************************
 Destructor

 *****************************************************************************/

JMMRecord::~JMMRecord()
{
}

/******************************************************************************
 SetDeleteLocation

 *****************************************************************************/

void
JMMRecord::SetDeleteLocation
	(
	const JCharacter* deleteFile,
	const JSize       deleteLine,
	const JBoolean    arrayDelete
	)
{
	assert(itsDeleteFile == NULL);
	assert(itsDeleteLine == 0);
	assert(deleteFile != NULL);
	itsDeleteFile = deleteFile;
	itsDeleteLine = deleteLine;
	itsArrayDeleteFlag = arrayDelete;
}

/******************************************************************************
 NewTypeName

 *****************************************************************************/

const JCharacter*
JMMRecord::NewTypeName() const
{
	return TypeName(itsArrayNewFlag);
}

/******************************************************************************
 DeleteTypeName

 *****************************************************************************/

const JCharacter*
JMMRecord::DeleteTypeName() const
{
	return TypeName(itsArrayDeleteFlag);
}

/******************************************************************************
 TypeName (static)

 *****************************************************************************/

const JCharacter*
JMMRecord::TypeName
	(
	const unsigned isArray
	)
{
	return (isArray) ? "array" : "object";
}

#if 0
/******************************************************************************
 Print

 *****************************************************************************/

JString
JMMRecord::Print() const
{
	JString string;

	string += "ID: ";
	string += itsID;
	string += "\nAddress: ";
	string += static_cast(unsigned long, itsAddress);
	string += "\nSize: ";
	string += itsSize;
	string += "\nNew  File: ";
	string += itsNewFile;
	string += "\n     Line: ";
	string += itsNewLine;
	string += "\nDelete  File: ";
	string += itsDeleteFile;
	string += "\n        Line: ";
	string += itsDeleteLine;
	string += "\n";

	return string;
}
#endif

/******************************************************************************
 PrintLayout

	Prints the layout of a JMMRecord in memory.  Useful for optimizing the
	memory manager's memory usage on a particular architecture, which can be
	important considering how many records can potentially be stored.

	This method ought to be static but isn't to accomodate certain compilers
	implement sizeof() and/or offsetof().  It isn't very hard to use the default
	constructor to create a throwaway object anyway.

 *****************************************************************************/

void
JMMRecord::PrintLayout()
{
	cout << "Memory layout of JMMRecord:" << endl;

	cout << "\n      itsAddress = " << offsetof(JMMRecord, itsAddress) << "-"
	     << offsetof(JMMRecord, itsAddress)+sizeof(JMMRecord::itsAddress)-1 << endl;
	cout << "      itsNewFile = " << offsetof(JMMRecord, itsNewFile) << "-"
	     << offsetof(JMMRecord, itsNewFile)+sizeof(JMMRecord::itsNewFile)-1 << endl;
	cout << "   itsDeleteFile = " << offsetof(JMMRecord, itsDeleteFile) << "-"
	     << offsetof(JMMRecord, itsDeleteFile)+sizeof(JMMRecord::itsDeleteFile)-1 << endl;
	cout << "         itsSize = " << offsetof(JMMRecord, itsSize) << "-"
	     << offsetof(JMMRecord, itsSize)+sizeof(JMMRecord::itsSize)-1 << endl;

	cout << "\n           itsID = " << offsetof(JMMRecord, itsID) << "-"
	     << offsetof(JMMRecord, itsID)+sizeof(JMMRecord::itsID)-1 << endl;
	cout << "      itsNewLine = " << offsetof(JMMRecord, itsNewLine) << "-"
	     << offsetof(JMMRecord, itsNewLine)+sizeof(JMMRecord::itsNewLine)-1 << endl;
	cout << "   itsDeleteLine = " << offsetof(JMMRecord, itsDeleteLine) << "-"
	     << offsetof(JMMRecord, itsDeleteLine)+sizeof(JMMRecord::itsDeleteLine)-1 << endl;

	cout << "\n       bitfields = "
	     << offsetof(JMMRecord, itsDeleteLine)+sizeof(JMMRecord::itsDeleteLine) << "-"
	     << sizeof(JMMRecord)-1 << "\n" << endl;
}
