/* $Id: MainW.C,v 1.1.1.1 2001/04/09 13:34:45 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <assert.h>
#include <Xarm/MainW.h>
/* MainWindowClass members */

/* convenience routines */
Widget
MainWindowClass::separator1() const
{
  return XmMainWindowSep1(widget());
}

Widget
MainWindowClass::separator2() const
{
  return XmMainWindowSep1(widget());
}

Widget
MainWindowClass::separator3() const
{
  return XmMainWindowSep1(widget());
}
      
void
MainWindowClass::setArea(Widget menu,
	Widget command,
	Widget hscroll,
	Widget vscroll,
	Widget work)
{
   XmMainWindowSetAreas(widget(),menu,command,hscroll,vscroll,work);
}

/* class constructor */
MainWindow::MainWindow(Widget w_parent, 
                       unsigned char policy,
                       Boolean show_separator, 
                       _XtString name)
{
   Arg args[2];
   Cardinal cnt = 0;

   XtSetArg(args[cnt], XmNscrollingPolicy, policy); cnt++;
   XtSetArg(args[cnt], XmNshowSeparator, show_separator); cnt++;

   assert(cnt <= (XtNumber(args)));

   Widget w = createWidget(name, w_parent, args, cnt);
   widget(w);

/*
   Widget w = XtVaCreateWidget("XmMainWindow",
                               xmMainWindowWidgetClass,
                               w_parent,
                               XmNscrollingPolicy, policy,
                               XmNshowSeparator, show_separator,
                               NULL);
*/
}

MainWindow::MainWindow(Widget w_parent,
                       Dimension w, 
                       Dimension h, 
                       unsigned char policy,
                       Boolean show_separator,
                       _XtString name)
{
   Arg args[4];
   Cardinal cnt = 0;

   XtSetArg(args[cnt], XmNwidth, w); cnt++;
   XtSetArg(args[cnt], XmNheight, h); cnt++;
   XtSetArg(args[cnt], XmNscrollingPolicy, policy); cnt++;
   XtSetArg(args[cnt], XmNshowSeparator, show_separator); cnt++;

   assert(cnt <= (XtNumber(args)));

   Widget wid = createWidget(name, w_parent, args, cnt);
                                
   widget(wid);
}

MainWindow::MainWindow(Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt,
                       _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
}

MainWindow::MainWindow(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

MainWindow::MainWindow(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
}

