/* $Id: CallbackP.h,v 1.1.1.1 2001/04/09 13:32:08 glgay Exp $ */
/*
 Copyright (C) 1996, 1999 Gerald L. Gay
 Copyright (C) 1996       Peter Williams

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#if !defined(xarm_callbackp_h)
#define xarm_callbackp_h

/* ======================================================================= */
/* Include(s): */
#include <X11/X.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>

template <class T>
struct CallbackInfo {
   typedef void (T::*p_msg)(Widget, XtPointer, XtPointer);

   p_msg _callback;
   XtPointer _closure;
   T *_target;
   _XtString _type; 
   Widget _widget;
};

template <class T>
struct ProtocolInfo {
    typedef void (T::*p_msg)(Widget, XtPointer, XtPointer);

    p_msg _callback;
    XtPointer _closure;
    T *_target;
    Atom _property;
    Atom _protocol;
    Widget _widget;
};

template <class T>
struct WorkInfo {
    typedef Boolean (T::*p_msg)(XtPointer);

    p_msg _callback;
    XtPointer _closure;
    T *_target;
    XtWorkProcId _id;
};

template <class T>
struct TimerInfo {
    typedef void (T::*p_msg)(XtPointer, XtIntervalId *);

    p_msg _callback;
    XtPointer _closure;
    T *_target;
    XtIntervalId _id;
};

template <class T>
struct InputInfo {
    typedef void (T::*p_msg)(XtPointer, int *, XtInputId *);

    p_msg _callback;
    XtPointer _closure;
    T *_target;
    XtInputId _id;
};

template <class T>
struct EventInfo {
    typedef void (T::*p_msg)(Widget, XtPointer, XEvent *, Boolean *);

    p_msg _callback;
    XtPointer _closure;
    T *_target;
    Widget _widget;
    EventMask _em;
    Boolean _nonmaskable;
};

void         registerCallback(void *);
void         unregisterCallback(void *);

void         registerProtoCallback(void *);
void         unregisterProtoCallback(void *);

XtWorkProcId registerWorkProc(void *, XtAppContext);
void         removeWorkProc(XtWorkProcId);

XtIntervalId registerTimeOut(void *, XtAppContext, unsigned long);
void         removeTimeOut(XtIntervalId);

XtInputId    registerInput(void *, XtAppContext, int, XtPointer);
void         removeInput(XtInputId);

void         registerEventHandler(void *);
void         unregisterEventHandler(void *);

#endif
