/* $Id: Shell.h,v 1.1.1.1 2001/04/09 13:33:19 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_shell_h)
#define xarm_shell_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Composite.h>

class ShellClass : public CompositeClass {
 protected:
   ShellClass() {}
   
   virtual WidgetClass classPointer()  { return shellWidgetClass; }
   virtual _XtString className()       { return (_XtString) "Shell"; }
 public:
   /* callbacks */
   void popdownCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNpopdownCallback); }
   void popupCallback(XtCallbackProc fp, XtPointer data = NULL)   { XARM_SET_CALLBACK(XmNpopupCallback); }

   /* convenience routines */
   void activateProtocol(Atom prop, Atom proto)  { XmActivateProtocol(widget(), prop, proto); }
   void activateWMProtocol(Atom protocol)        { XmActivateWMProtocol(widget(), protocol); }

   /* resources */
   Boolean allowShellResize() const                      { XARM_GET_VALUE(Boolean, XmNallowShellResize); }
   void createPopupChildProc(XtCreatePopupChildProc val) { XARM_SET_VALUE(XmNcreatePopupChildProc); }
   XtCreatePopupChildProc createPopupChildProc()
                                 { XARM_GET_VALUE(XtCreatePopupChildProc, XmNcreatePopupChildProc); }
   void geometry(const _XtString val)                    { XARM_SET_VALUE(XmNgeometry); }
   _XtString geometry() const                            { XARM_GET_VALUE(_XtString, XmNgeometry); }
   void overrideRedirect(Boolean val)                    { XARM_SET_VALUE(XmNoverrideRedirect); }
   Boolean overrideRedirect() const                      { XARM_GET_VALUE(Boolean, XmNoverrideRedirect); }
   void saveUnder(Boolean val)                           { XARM_SET_VALUE(XmNsaveUnder); }
   Boolean saveUnder() const                             { XARM_GET_VALUE(Boolean, XmNsaveUnder); }
   void visual(const Visual *val)                        { XARM_SET_VALUE(XmNvisual); }
   Visual *visual() const                                { XARM_GET_VALUE(Visual *, XmNvisual); }
};


class WMShellClass : public ShellClass {
 protected:
   WMShellClass() {}

   virtual WidgetClass classPointer() { return wmShellWidgetClass; }
   virtual _XtString className()      { return (_XtString) "WMShell"; }
 public:
   /* resources */
   void baseHeight(int val)          { XARM_SET_VALUE(XmNbaseHeight); }
   int baseHeight() const            { XARM_GET_VALUE(int, XmNbaseHeight); }
   void baseWidth(int val)           { XARM_SET_VALUE(XmNbaseWidth); }
   int baseWidth() const             { XARM_GET_VALUE(int, XmNbaseWidth); }
   void heightInc(int val)           { XARM_SET_VALUE(XmNheightInc); }
   int heightInc() const             { XARM_GET_VALUE(int, XmNheightInc); }
   void iconMask(Pixmap val)         { XARM_SET_VALUE(XmNiconMask); }
   Pixmap iconMask() const           { XARM_GET_VALUE(Pixmap, XmNiconMask); }
   void iconPixmap(Pixmap val)       { XARM_SET_VALUE(XmNiconPixmap); }
   Pixmap iconPixmap() const         { XARM_GET_VALUE(Pixmap, XmNiconPixmap); }
   void iconWindow(Window val)       { XARM_SET_VALUE(XmNiconWindow); }
   Window iconWindow() const         { XARM_GET_VALUE(Window, XmNiconWindow); }
   void iconX(int val)               { XARM_SET_VALUE(XmNiconX); }
   int iconX() const                 { XARM_GET_VALUE(int, XmNiconX); }
   void iconY(int val)               { XARM_SET_VALUE(XmNiconY); }
   int iconY() const                 { XARM_GET_VALUE(int, XmNiconY); }
   void initialState(int val)        { XARM_SET_VALUE(XmNinitialState); }
   int initialState() const          { XARM_GET_VALUE(int, XmNinitialState); }
   void input(Boolean val)           { XARM_SET_VALUE(XmNinput); }
   Boolean input() const             { XARM_GET_VALUE(Boolean, XmNinput); }
   void maxAspectX(int val)          { XARM_SET_VALUE(XmNmaxAspectX); }
   int maxAspectX() const            { XARM_GET_VALUE(int, XmNmaxAspectX); }
   void maxAspectY(int val)          { XARM_SET_VALUE(XmNmaxAspectY); }
   int maxAspectY() const            { XARM_GET_VALUE(int, XmNmaxAspectY); }
   void maxHeight(int val)           { XARM_SET_VALUE(XmNmaxHeight); }
   int maxHeight() const             { XARM_GET_VALUE(int, XmNmaxHeight); }
   void maxWidth(int val)            { XARM_SET_VALUE(XmNmaxWidth); }
   int maxWidth() const              { XARM_GET_VALUE(int, XmNmaxWidth); }
   void minAspectX(int val)          { XARM_SET_VALUE(XmNminAspectX); }
   int minAspectX() const            { XARM_GET_VALUE(int, XmNminAspectX); }
   void minAspectY(int val)          { XARM_SET_VALUE(XmNminAspectY); }
   int minAspectY() const            { XARM_GET_VALUE(int, XmNminAspectY); }
   void minHeight(int val)           { XARM_SET_VALUE(XmNminHeight); }
   int minHeight() const             { XARM_GET_VALUE(int, XmNminHeight); }
   void minWidth(int val)            { XARM_SET_VALUE(XmNminWidth); }
   int minWidth() const              { XARM_GET_VALUE(int, XmNminWidth); }
   void title(const _XtString val)   { XARM_SET_VALUE(XmNtitle); }
   _XtString title() const           { XARM_GET_VALUE(_XtString, XmNtitle); }
   void titleEncoding(Atom val)      { XARM_SET_VALUE(XmNtitleEncoding); }
   Atom titleEncoding() const        { XARM_GET_VALUE(Atom, XmNtitleEncoding); }
   void transient(Boolean val)       { XARM_SET_VALUE(XmNtransient); }
   Boolean transient() const         { XARM_GET_VALUE(Boolean, XmNtransient); }
   void waitForWm(Boolean val)       { XARM_SET_VALUE(XmNwaitForWm); }
   Boolean waitForWm() const         { XARM_GET_VALUE(Boolean, XmNwaitForWm); }
   void widthInc(int val)            { XARM_SET_VALUE(XmNwidthInc); }
   int widthInc() const              { XARM_GET_VALUE(int, XmNwidthInc); }
   void windowGroup(Window val)      { XARM_SET_VALUE(XmNwindowGroup); }
   Window windowGroup() const        { XARM_GET_VALUE(Window, XmNwindowGroup); }
   void winGravity(int val)          { XARM_SET_VALUE(XmNwinGravity); }
   int winGravity() const            { XARM_GET_VALUE(int, XmNwinGravity); }
   void wmTimeout(int val)           { XARM_SET_VALUE(XmNwmTimeout); }
   int wmTimeout() const             { XARM_GET_VALUE(int, XmNwmTimeout); }
};

#include <Xarm/VendorS.h>

class TransientShellClass : public VendorShellClass {
 protected:
   TransientShellClass() {}

   virtual WidgetClass classPointer()  { return transientShellWidgetClass; }
   virtual _XtString className()       { return (_XtString) "TransientShell"; }
 public:
   /* resources */
   void transientFor(Widget val)       { XARM_SET_VALUE(XmNtransientFor); }
   Widget transientFor() const         { XARM_GET_VALUE(Widget, XmNtransientFor); }
};

class TopLevelShellClass : public VendorShellClass {
 protected:
   TopLevelShellClass() {}

   virtual WidgetClass classPointer()   { return topLevelShellWidgetClass; }
   virtual _XtString className()        { return (_XtString) "TopLevelShell"; }
 public:
   /* resources */
   void iconic(Boolean val)             { XARM_SET_VALUE(XmNiconic); }
   Boolean iconic() const               { XARM_GET_VALUE(Boolean, XmNiconic); }
   void iconName(const _XtString val)   { XARM_SET_VALUE(XmNiconName); }
   _XtString iconName() const           { XARM_GET_VALUE(_XtString, XmNiconName); }
   void iconNameEncoding(Atom val)      { XARM_SET_VALUE(XmNiconNameEncoding); }
   Atom iconNameEncoding() const        { XARM_GET_VALUE(Atom, XmNiconNameEncoding); }

   /* extra */
   void realize()                       { XtRealizeWidget(widget()); }
   void unrealize()                     { XtUnrealizeWidget(widget()); }
};

typedef XarmRawWidget<TopLevelShellClass, false> TopLevelShell;

class PopupShellClass : public TopLevelShellClass {

 protected:
   PopupShellClass() {}

 public:
   void popup(XtGrabKind grabKind = XtGrabNone)  { XtPopup(widget(), grabKind); }
   void popdown()                                { XtPopdown(widget()); }
};

////////////////////////////////////////////
//                                        //
// PopupShell isn't a template because it //
// has a non-standard Create function!    //
//                                        //
////////////////////////////////////////////

class PopupShell : public PopupShellClass {
  protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   PopupShell(Widget w_parent,
              ArgList arglist = NULL,
              Cardinal cnt = 0,
              _XtString name = NULL);
   PopupShell(_XtString name, Widget w_parent);
   PopupShell(Widget w_parent, XarmArg &args, _XtString name);
};


class OverrideShellClass : public ShellClass {
 protected:
   OverrideShellClass() {}

   virtual WidgetClass classPointer() { return overrideShellWidgetClass; }
   virtual _XtString className() { return (_XtString) "OverrideShell"; }
};

#endif
