/****************************************************************************/
/*  xmCi2.h - CommonInteract II header file - (09/23/1992) 02/18/1993       */
/****************************************************************************/
/*                                                                          */
/*   Copyright (c) 1991 - 1994  Bernhard Strassl                            */
/*       Vienna User Interface Group                                        */
/*       Institute for Applied Computer Science and Information Systems     */
/*       University of Vienna, Austria                                      */
/*                                                                          */
/*   See file COPYRIGHT in this directory for details. If this file is      */
/*   missing please mail to xmpp@ani.univie.ac.at                           */
/****************************************************************************/

#ifndef XmCi2_included
#define XmCi2_included 1

#include "xmDrawing.h"

#ifndef CI_OVERRIDE_DEFAULTS
#define CI_MAX_CHILDREN 50
#define CI_MAX_WORLD_CHILDREN 1000
#define CI_MAX_TREE_SIZE 500
#define CI_MAX_ASSIGNINFO_NAMES 30
#define CI_MAX_CALLBACKS 10
#define CI_MAX_METHODS 10
#endif

#define CI_DEFAULT_NAME "unnamedObject"

#define CI_NUM_INTERACTION_PRIMITIVES 8

typedef enum ciPrim { Mark, Move, Assign, Resize, Select, Activate, ChangeContents, ChangeData };

typedef unsigned int ciAttrib;

#define MARKABLE		SELECT
#define MOVEABLE		MOVE
#define RESIZEABLE		RESIZE_ANY
#define SELECTABLE		0x0400
#define ACTIVATEABLE	0x0800
#define CHANGEABLE		0x0A00

#define CI_DEFAULT_ATTRIBUTES MARKABLE | MOVEABLE | RESIZEABLE

// Note: ASSIGN is controlled by the application through the allowAssign...() members!

typedef short ciState;

#define NORMAL			0x00
#define MARKED			SELECTED
#define PRIMARY_MARKED	PRIMARY_SELECTION
#define DISABLED		0x04

struct ciCallbackInfo
{
	bool isXmCallback;
	XmRootClass* receiver;
	cbProc callback;
	void* clientData;
	int when;

	ciCallbackInfo(XmRootClass* ob, cbProc cbk, void* cd, int wh)	{ isXmCallback = FALSE; receiver = ob; callback = cbk; clientData = cd; when = wh; }
	bool eq(ciCallbackInfo* inf)	{ return((receiver == inf->receiver && callback == inf->callback && clientData == inf->clientData && when == inf->when) ? TRUE : FALSE); } 
};

#define USER	0x01
#define APP		0x02
#define PARENT	0x04

struct ciCallbackList
{
	ciCallbackInfo* list[CI_MAX_CALLBACKS];
	int count;

	ciCallbackList()				{ count = 0; }
	bool add(ciCallbackInfo* inf)	{ return(count < CI_MAX_CALLBACKS ? ((list[count++] = inf) ? TRUE : FALSE) : FALSE); }
	bool remove(ciCallbackInfo*);
	ciCallbackInfo* next(int& ndx)	{ return(ndx < count ? list[ndx++] : NULL); }
};

struct ciMethod
{
	char* msgName;
	char* paramType;
	cbProc callback;

	ciMethod(char* n, char* pt, cbProc p)	{ msgName = strcpy(new char[strlen(n) + 1], n); paramType = pt ? strcpy(new char[strlen(pt) + 1], pt) : pt; callback = p; }
	~ciMethod()								{ if(msgName) delete msgName; if(paramType) delete paramType; }

	bool match(char* n, char* pt)			{ return(n ? ((!strcmp(n, msgName) && (pt ? !strcmp(pt, paramType) : pt == paramType)) ? TRUE : FALSE) : FALSE); }
};

#define CB_CI_DATA CB_XM_DATA
#define CB_CLASS_NAME ((void* )10L)

struct ciClientData
{
	ciPrim prim;
	bool* answer;
	void* clientData;
	int x, y, x1, y1;
	CiObject* obj;
	int operation;

	ciClientData(ciPrim pr, bool& a, void* cd, int nx, int ny, CiObject* ob, int op, int nx1, int ny1)	{ prim = pr; answer = &a; clientData = cd; x =nx; y = ny; obj = ob; operation = op; x1 = nx1; y1 = ny1; }

	CiObject* clientObject()	{ return((CiObject* )clientData); }
};

#define OP_ADD 1
#define OP_REMOVE 2
#define OP_MOVE_DURING_RESIZE 3
#define OP_ON OP_ADD
#define OP_OFF OP_REMOVE

#define PARENT_CLASSES	0
#define PARENT_OBJECTS	1
#define CHILD_CLASSES	2
#define CHILD_OBJECTS	3

// getChildren search codes
#define CH_THIS 0		// only direct children of the receiver
#define CH_SHALLOW 1	// the root of each subhierarchy matching a given status
#define CH_ALL 2		// all children in any depth

struct assignInfo
{
	char* names[CI_MAX_ASSIGNINFO_NAMES][4];
	int nums[4];

	assignInfo()	{ nums[0] = nums[1] = nums[2] = nums[3] = 0; }
};

class CiObject : public DrawPrim
{
friend class CiLayout;
friend class XmCiWorld;
	int maxPrimPts;
	XmRootClass* basePtr;
	XmCiWorld* world;
	CiObject* parent;
	CiObject* children[CI_MAX_CHILDREN];
	XmControl* control;
	int numChildren;
	gprPoint relCoord;
	ciAttrib attributes;
	ciState state;
	ciCallbackList* preOpCallbacks[CI_NUM_INTERACTION_PRIMITIVES];
	ciCallbackList* postOpCallbacks[CI_NUM_INTERACTION_PRIMITIVES];
	assignInfo assigninf;
	CiObject* reAssigned;
	bool moved, resized;
	void* objData;
	char* instName;
	ciMethod* protocol[CI_MAX_METHODS];
	int methodCount;
public:
	virtual char* className()	{ return("ObjectClass"); }
private:
	int maxpoints()			{ return(maxPrimPts); }
	void initObject(char*, ciAttrib);
	bool callCallback(ciPrim, bool, int = 0, int = 0, CiObject* = NULL, int = 0, int = 0, int = 0, int = USER);
	void changeAssignInfo(bool, int, char*);
	bool matchAssignInfo(int, char*);

	bool objMark(bool, int, int, bool, bool = FALSE, bool = FALSE, bool = TRUE);
	bool objAssign(CiObject*, int, int, bool, bool = FALSE, bool = FALSE, bool = FALSE);
	bool objResize(int, int, bool, int, int, bool, bool = FALSE, bool = FALSE, bool = FALSE);
	void objSelect(int, int, bool);
	void objActivate();
	bool objChangeData(void*, bool, bool = FALSE, bool = FALSE);

	void addTreeTo(XmCiWorld*);
	void removeTreeFrom(XmCiWorld*);
	void markChildren(bool);
	void relocateChildren(int, int);
	void restackChild(CiObject*, bool = TRUE);
	void restackChild(CiObject*, int);
	CiObject* getMarkedRoot();
protected:
	int findMethod(char*, char*);
	bool registerMethod(char*, cbProc, char* = NULL);
	gprData* getData()		{ return(data); }
public:
	CiObject(DrawPrim*, char* = CI_DEFAULT_NAME, ciAttrib = CI_DEFAULT_ATTRIBUTES);
	CiObject(XmControl*, char* = CI_DEFAULT_NAME, ciAttrib = CI_DEFAULT_ATTRIBUTES);
	virtual ~CiObject();

	CiObject* addChild(CiObject*, bool = TRUE, bool = TRUE);
	CiObject* removeChild(CiObject*, bool = FALSE, bool = TRUE);
	CiObject* child(int i)	{ return((i >= 0 && i < numChildren) ? children[i] : NULL); }
	int childrenCount()		{ return(numChildren); }

	CiObject** getChildren(int code = CH_THIS, ciState = -1, char* = NULL, CiObject** = NULL, int* = NULL);

	CiObject* linkTo(CiObject*);
	CiObject* linkTo(XmCiWorld*);
	CiObject* unlink();
	
	void changeName(char* aName)				{ delete instName; instName = strcpy(new char[strlen(aName) + 1], aName); }
	CiObject* setInitialOrigin(int x, int y)	{ relCoord.x = x; relCoord.y = y; return(this); }
	bool setAttributes(ciAttrib, bool);

	bool setCallback(ciPrim, XmRootClass*, cbProc, bool, bool, void*, int);
	bool setCallback(ciPrim i, CiObject* o, cbProc f, bool s = TRUE, bool p = FALSE, void* d = CB_OBJ_PTR, int w = USER | APP)	{ return(setCallback(i, o->basePtr, f, s, p, d, w)); }
	bool setCallback(ciPrim i, XmObject* o, cbProc f, bool s = TRUE, bool p = FALSE, void* d = CB_OBJ_PTR, int w = USER | APP)	{ return(setCallback(i, (XmRootClass* )o->getBase(), f, s, p, d, w)); }

	bool disable();
	bool enable();

	bool mark(bool notify = TRUE, bool repaint = TRUE)				{ return(objMark(TRUE, 0, 0, notify, FALSE, FALSE, repaint)); }
	bool unmark(bool notify = TRUE, bool repaint = TRUE)				{ return(objMark(FALSE, 0, 0, notify, FALSE, FALSE, repaint)); }
	bool move(int nx, int ny, bool notify = TRUE, bool repaint = FALSE)			{ return(objAssign(parent, nx, ny, notify, FALSE, FALSE, repaint)); }
	bool assign(CiObject* rec, int x, int y, bool notify = TRUE, bool repaint = FALSE)	{ return(objAssign(rec, x, y, notify, FALSE, FALSE, repaint)); }
	bool resize(int nw, int nh, bool notify = TRUE, bool repaint = FALSE)		{ return(objResize(nw, nh, FALSE, 0, 0, notify, FALSE, FALSE, repaint)); }
	bool changeData(void* d, bool notify = TRUE)					{ return(objChangeData(d, notify)); }
	void notifyChanges(ciPrim);	// has to be called i.e. after setPoints!!

	char* getName()						{ return(instName); }
	char* getClassName()				{ return(className()); }
	bool isA(char* n)					{ return(strcmp(className(), n) ? FALSE : TRUE); }
	CiObject* getParent()				{ return(parent); }
	XmCiWorld* getWorld();
	bool wasAssigned()					{ return(reAssigned ? TRUE : FALSE); }
	bool wasMoved()						{ return(moved); }

	gprPoint calcRel(gprPoint);
	gprPoint relOrigin()				{ return(calcRel(origin())); }
	gprPoint relCorner()				{ return(calcRel(corner())); }
	gprPoint relCenter()				{ return(calcRel(center())); }

	bool getState(ciState);
	void makeRelative(int&, int&);
	void makeAbsolute(int&, int&);

	void toForeground(bool = TRUE);
	void toBackground(bool = TRUE);

	void allowAssignmentOf(char*, ...);
	void denyAssignmentOf(char*, ...);
	void allowAssigningTo(char*, ...);
	void denyAssigningTo(char*, ...);

	bool validateParent(CiObject* anObj)	{ return((bool )(anObj ? (matchAssignInfo(PARENT_CLASSES, anObj->className()) || matchAssignInfo(PARENT_OBJECTS, anObj->instName)) : matchAssignInfo(PARENT_OBJECTS, "WORLD"))); }
	bool validateChild(CiObject* anObj)		{ return((bool )(matchAssignInfo(CHILD_CLASSES, anObj->className()) || matchAssignInfo(CHILD_OBJECTS, anObj->instName))); }

	bool msg(char*, char* = NULL, void* = NULL);
};

class XmCiWorld : public XmDrawing
{
	CiObject* children[CI_MAX_WORLD_CHILDREN];
	int numChildren;
	bool unmarkNotify;
friend void CiObject::toForeground(bool);
friend void CiObject::toBackground(bool);
	void restackChild(CiObject*, bool = TRUE);
public:
	XmCiWorld(char*, int = 0, int = 0, int = 0, int = 0);
	~XmCiWorld();

	CiObject* addChild(CiObject*);
	CiObject* removeChild(CiObject*);
	CiObject* child(int i);			// { return((i >= 0 && i < numChildren) ? children[i] : NULL); }
	CiObject* childAt(gprPoint p);	// { return((CiObject* )primAt(p)); }
	int childrenCount();			// { return(numChildren); }

	CiObject** getChildren(int code = CH_THIS, ciState = -1, char* = NULL, CiObject** = NULL, int* = NULL);
	CiObject* commonParentFor(CiObject*, CiObject*);

	bool userClick(DrawPrim*, int, int, bool);
	bool userSelect(DrawPrim*, bool, int, int);
	bool userMove(DrawPrim*, int, int, int, int);
	bool userResize(DrawPrim*, int, int, bool, int, int);
	void userActivate(DrawPrim*, int, int);
	bool userDragEnter(DrawPrim*, DrawPrim**, bool*);
	
	void notifyOnUnmark(bool n = FALSE)	{ unmarkNotify = n; }
};

// Ci2 Tool Classes //////////////////////////////////////////////////////////

class CiLayout : public CiObject
{
	int spacing;
	bool orientation, autoSize;
	int maxRepeat;

	char* className()	{ return("CiLayout"); }

	void reOrder(CiObject*);
	void handleAdd(CiObject*);
	void handleRemove(CiObject*);
	void reLayout(void* = NULL);

	void contentsChanged(ciClientData*);
public:
	CiLayout(char*, int, int, int, int, ciAttrib, bool ort,
			 int spc = 10, bool ats = TRUE, int rep = 1);
	~CiLayout()	{}
};


typedef enum connObj	{ CO_LINE, CO_ARROW };
typedef unsigned int connRule;

#define	CR_CENTER	0x01
#define CR_LEFT		0x02
#define CR_RIGHT	0x04
#define CR_TOP		0x08
#define CR_BOTTOM	0x10
#define CR_NEXT		0x20

#define allowFrom allowAssignmentOf		// the parent/child assignment control
#define denyFrom denyAssignmentOf		// is abused here, this should no matter
#define allowTo allowAssigningTo		// because Connectors can never be moved
#define denyTo denyAssigningTo			// or assigned (must not be moveable)

class Connector : public CiObject
{
static DrawPrim* connObject(connObj);
	CiObject* from, * to;
	connRule rFrom, rTo;

	bool changeObj(CiObject**, CiObject*, connRule, bool);
	void placeConn(int, CiObject*, connRule);
	gprPoint placeEnd(int, CiObject*, connRule);
	void reAdjust(void* = NULL);

	void resized(ciClientData*);
	void changed(CiObject*);
public:
	Connector(char*, connObj);
	~Connector();

	bool connect(CiObject*, CiObject*, connRule = CR_CENTER, connRule = CR_CENTER)	;

	bool changeFrom(CiObject* o, connRule r = CR_CENTER, bool a = TRUE)	{ return(changeObj(&from, o, r, a)); }
	bool changeTo(CiObject* o, connRule r = CR_CENTER, bool a = TRUE)	{ return(changeObj(&to, o, r, a)); }

	CiObject* getFrom()	{ return(from); }
	CiObject* getTo()	{ return(to); }
};

/*

class OwObject : public CiObject
{
	OwObject** presentations;
	int numPres;
};

*/

#endif
