//  map : headerfile for the free standard C++ library
//  
//  Copyright (C) 1999 by the free standard C++ Library Team
//                        see AUTHORS for more details
//
//  Homepage : http://www.inf.fu-berlin.de/~mkrueger/fscl/
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either	
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//  version : 0.1 last modified : 17.09.99


#ifndef __CPP_MAP
#define __CPP_MAP

#include<utility>
#include<vector>

namespace std {
	
	// 23.3.1 Template class map
	template <class Key, class T, class Compare = less<Key>, class Allocator = allocator<T> >
	class map
	{
		private:
			vector<pair<Key, T> > c;
		public:
			typedef Key                                       key_type;
			typedef T                                         mapped_type;
			typedef pair<const Key, T>                        value_type;
			typedef Compare                                   key_compare;
			typedef Allocator                                 allocator_type;
			typedef typename Allocator::reference             reference;
			typedef typename Allocator::const_reference       const_reference;
			typedef typename Allocator::size_type             size_type;
			typedef typename Allocator::difference_type       difference_type;
			typedef Allocator::pointer                        pointer;
			typedef Allocator::const_pointer                  const_pointer;
			
			typedef implementation defined                    iterator;
			typedef implementation defined                    const_iterator;
		
			typedef std::reverse_iterator<iterator>           reverse_iterator;
			typedef std::reverse_iterator<const_iterator>     const_reverse_iterator;
			
			class value_compare : public binary_function<value_type, value_type, bool> {				
				friend class map;
				protected:
					Compare comp;
					value_compare(Compare c) : comp(c) 
					{
					}
				public:
					bool operator()(const value_type& x, const value_type& y) const 
					{
						return comp(x.first, y.first);
					}
			};
			
			// 23.3.1.1 construct / copy / destroy
			explicit map(const Compare& comp = Compare(), const Allocator& = Allocator())
			{
			}
			
			template <class InputIterator>
			map(InputIterator first, InputIterator last, const Compare& comp = Compare(), const Allocator& alloc= Allocator())
			{
			}
			
			map(const map<Key,T,Compare,Allocator>& x)
			{
			}
			
			~map()
			{
			}
			
			map<Key,T,Compare,Allocator> &operator=(const map<Key,T,Compare,Allocator>& x)
			{
			}
			
			// iterstors:
			iterator               begin()
			{
			}
			const_iterator         begin() const
			{
			}
			iterator               end()
			{
			}
			const_iterator         end() const
			{
			}
			reverse_iterator       rbegin()
			{
			}
			const_reverse_iterator rbegin() const
			{
			}
			reverse_iterator       rend()
			{
			}
			const_reverse_iterator rend() const
			{
			}

			// capacity:
			bool      empty() const
			{
			}
			size_type size() const
			{
			}
			size_type max_size() const
			{
			}
			
			// 23.3.1.2 element access :
			reference operator[](const key_type &x)
			{
			}
			
			// modifiers:
			pair<iterator, bool> insert(const value_type &x)
			{
			}
			
			iterator insert(iterator position, const value_type &x)
			{
			}
			
			template <class InputIterator>
			void insert(InputIterator first, InputIterator last)
			{
			}
			
			void erase(iterator position)
			{
			}
			
			size_type erase(const key_type &x)
			{
			}
			
			void      erase(iterator first, iterator last)
			{
			}
			
			void swap(map<Key,T,Compare,Allocator> &x)
			{
			}
			
			void clear()
			{
			}

			// observers:
			key_compare   key_comp() const
			{
			}
			value_compare value_comp() const
			{
			}

			// 23.3.1.3 map operations:
			iterator       find(const key_type& x)
			{
			}
			const_iterator find(const key_type& x) const
			{
			}
			
			size_type      count(const key_type& x) const
			{
			}
			
			iterator       lower_bound(const key_type& x)
			{
			}
			
			const_iterator lower_bound(const key_type& x) const
			{
			}
			iterator       upper_bound(const key_type& x)
			{
			}
			const_iterator upper_bound(const key_type& x) const
			{
			}
			pair<iterator,iterator>             equal_range(const key_type& x)
			{
			}
			pair<const_iterator,const_iterator> equal_range(const key_type& x) const
			{
			}
	};
	
	template <class Key, class T, class Compare, class Allocator>
	bool operator==(const map<Key,T,Compare,Allocator>& x, const map<Key,T,Compare,Allocator>& y)
	{
		return x.c == y.c;
	}		
	template <class Key, class T, class Compare, class Allocator>
	bool operator< (const map<Key,T,Compare,Allocator>& x, const map<Key,T,Compare,Allocator>& y)
	{
		return x.c < y.c;
	}
	template <class Key, class T, class Compare, class Allocator>
	bool operator!=(const map<Key,T,Compare,Allocator>& x, const map<Key,T,Compare,Allocator>& y)
	{
		return x.c != y.c;
	}
	template <class Key, class T, class Compare, class Allocator>
	bool operator> (const map<Key,T,Compare,Allocator>& x, const map<Key,T,Compare,Allocator>& y)
	{
		return x.c > y.c;
	}
	template <class Key, class T, class Compare, class Allocator>
	bool operator>=(const map<Key,T,Compare,Allocator>& x, const map<Key,T,Compare,Allocator>& y)
	{
		return x.c >= y.c;
	}
	template <class Key, class T, class Compare, class Allocator>
	bool operator<=(const map<Key,T,Compare,Allocator>& x, const map<Key,T,Compare,Allocator>& y)
	{
		return x.c <= y.c;
	}

	//  specialized algorithms:
	template <class Key, class T, class Compare, class Allocator>
	void swap(map<Key,T,Compare,Allocator>& x, map<Key,T,Compare,Allocator>& y)
	{
		x.swap(y);
	}

	// 23.3.2 Template class multimap
	template <class Key, class T, class Compare = less<Key>, class Allocator = allocator<T> >
	class multimap
	{
		private:
			vector<pair<Key, T> > c;
		public:
			typedef Key                                       key_type;
			typedef T                                         mapped_type;
			typedef pair<const Key,T>                         value_type;
			typedef Compare                                   key_compare;
			typedef Allocator                                 allocator_type;
			typedef typename Allocator::reference             reference;
			typedef typename Allocator::const_reference       const_reference;
			typedef typename Allocator::size_type             size_type;
			typedef typename Allocator::difference_type       difference_type;
			typedef typename Allocator::pointer               pointer;
			typedef typename Allocator::const_pointer         const_pointer;
						
			typedef implementation defined                    iterator;
			typedef implementation defined                    const_iterator;
			typedef std::reverse_iterator<iterator>           reverse_iterator;
			typedef std::reverse_iterator<const_iterator>     const_reverse_iterator;
			
			class value_compare : public binary_function<value_type,value_type,bool> 
			{
				friend class multimap;
				protected:
					Compare comp;
					value_compare(Compare c) 
					: comp(c) 
					{
					}
				public:
					bool operator()(const value_type& x, const value_type& y) const 
					{
						return comp(x.first, y.first);
					}
			};
			
			// construct / copy / destroy :
			explicit multimap(const Compare& comp = Compare(), const Allocator& alloc = Allocator())
			{
			}
			
			template <class InputIterator>
			multimap(InputIterator first, InputIterator last, const Compare& comp = Compare(), const Allocator& alloc = Allocator())
			{
			}
			
			multimap(const multimap<Key,T,Compare,Allocator>& x)
			{
			}
			
			~multimap()
			{
			}
			
			multimap<Key,T,Compare,Allocator>& operator=(const multimap<Key,T,Compare,Allocator>& x)
			{
			}
			
			allocator_type get_allocator() const
			{
			}
			
			// iterators
			iterator               begin()
			{			
			}			
			const_iterator         begin() const
			{
			}			
			iterator               end()
			{
			}			
			const_iterator         end() const
			{
			}			
			reverse_iterator       rbegin()
			{
			}			
			const_reverse_iterator rbegin() const
			{
			}			
			reverse_iterator       rend()
			{
			}
			const_reverse_iterator rend() const
			{
			}
			
			// capacity:
			bool           empty() const
			{
			}
			size_type      size() const
			{
			}
			size_type      max_size() const
			{
			}
			
			// modifiers:
			iterator insert(const value_type &x)
			{
			}
			iterator insert(iterator position, const value_type &x)
			{
			}			
			template <class InputIterator>
			void insert(InputIterator first, InputIterator last)
			{
			}
			
			void      erase(iterator position)
			{
			}
			size_type erase(const key_type& x)
			{
			}
			void      erase(iterator first, iterator last)
			{
			}
			
			void swap(multimap<Key,T,Compare,Allocator> &x)
			{
				swap(c, x.c);
			}
			
			void clear()
			{
			}

			// observers:
			key_compare    key_comp() const
			{
			}
			value_compare  value_comp() const
			{
			}

			// map operations:
			iterator       find(const key_type& x)
			{
			}
			const_iterator find(const key_type& x) const
			{
			}
			size_type      count(const key_type& x) const
			{
			}

			
			iterator       lower_bound(const key_type& x)
			{
			}
			const_iterator lower_bound(const key_type& x) const
			{
			}
			
			iterator       upper_bound(const key_type& x)
			{
			}
			const_iterator upper_bound(const key_type& x) const
			{
			}

			pair<iterator,iterator>             equal_range(const key_type& x)
			{
			}
			pair<const_iterator,const_iterator> equal_range(const key_type& x) const
			{
			}
	};
	
	template <class Key, class T, class Compare, class Allocator>
	bool operator==(const multimap<Key,T,Compare,Allocator>& x, const multimap<Key,T,Compare,Allocator>& y)
	{
		return x.c == y.c;
	}
	template <class Key, class T, class Compare, class Allocator>
	bool operator< (const multimap<Key,T,Compare,Allocator>& x, const multimap<Key,T,Compare,Allocator>& y)
	{
		return x.c < y.c;
	}			
	template <class Key, class T, class Compare, class Allocator>
	bool operator!=(const multimap<Key,T,Compare,Allocator>& x, const multimap<Key,T,Compare,Allocator>& y)
	{
		return x.c != y.c;
	}
			
	template <class Key, class T, class Compare, class Allocator>
	bool operator> (const multimap<Key,T,Compare,Allocator>& x, const multimap<Key,T,Compare,Allocator>& y)
	{
		return x.c > y.c;
	}			
	template <class Key, class T, class Compare, class Allocator>
	bool operator>=(const multimap<Key,T,Compare,Allocator>& x, const multimap<Key,T,Compare,Allocator>& y)
	{
		return x.c >= y.c;
	}		
	template <class Key, class T, class Compare, class Allocator>
	bool operator<=(const multimap<Key,T,Compare,Allocator>& x, const multimap<Key,T,Compare,Allocator>& y)
	{
		return x.c <= y.c;
	}
	
	// specialized algorithms:
	template <class Key, class T, class Compare, class Allocator>
	void swap(multimap<Key,T,Compare,Allocator>& x, multimap<Key,T,Compare,Allocator>& y)
	{
		x.swap(y);
	}
}
#endif
