/****************************************************************************
** $Id: qtooltip.h,v 2.15 1997/08/06 15:06:03 hanord Exp $
**
** Tool Tips (or Balloon Help) for any widget or rectangle
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.31.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#ifndef QTOOLTIP_H
#define QTOOLTIP_H

#include "qwidget.h"
#include "qtimer.h"


class QTipManager;
class QLabel;


class QToolTipGroup: public QObject
{
    Q_OBJECT
public:
    QToolTipGroup( QObject *parent, const char *name = 0 );
   ~QToolTipGroup();

signals:
    void showTip( const char * );
    void removeTip();

private:
    friend class QTipManager;
};


class QToolTip
{
public:
    QToolTip( QWidget *, QToolTipGroup * = 0 );

    static QFont    font();
    static void	    setFont( const QFont & );
    static QPalette palette();
    static void	    setPalette( const QPalette & );

    static void add( QWidget *, const char * );
    static void add( QWidget *, const char *,
		     QToolTipGroup *, const char * );
    static void remove( QWidget * );

    static void add( QWidget *, const QRect &, const char * );
    static void add( QWidget *, const QRect &, const char *,
		     QToolTipGroup *, const char * );
    static void remove( QWidget *, const QRect & );

protected:
    virtual void maybeTip( const QPoint & ) = 0;
    void    tip( const QRect &, const char * );
    void    tip( const QRect &, const char *, const char * );
    void    clear();

public:
    QWidget	  *parentWidget() const { return p; }
    QToolTipGroup *group()	  const { return g; }

private:
    QWidget	    *p;
    QToolTipGroup   *g;
    static QFont    *ttFont;
    static QPalette *ttPalette;

    static void initialize();
    static void cleanup();

    friend class QTipManager;
};


#endif // QTOOLTIP_H
