#ifndef StatusBar_included
#define StatusBar_included

#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qsize.h>
#include <qstring.h>

class StatusBar : public QFrame
{
    Q_OBJECT

public:

    StatusBar
    (
	int		wndHeight = 20,
	QWidget*	parent = NULL,
	const char*	name = NULL
    );
    

    virtual ~StatusBar();


    uint InsertTextRegion
    (
	int		stretch,
	const char*	text = NULL
    );
    // insert a text region in the status bar with relative size stretch and
    // optional text.  Return a number cooresponding to the text region

    void InsertSpacing
    (
	uint	width = 5
    );
    // insert some spacing between regions

    void SetText
    (
	uint		region,
	const QString&	text
    );
    // set the text in the given region

private: // attributes

    QList<QLabel>	itsLabelList;
    // list of labels

    QBoxLayout*		itsLayout;
    // layout for labels

    int			itsHeight;
};


inline void StatusBar::InsertSpacing
(
    uint	width
)
{
    itsLayout->addSpacing( width );
}


#endif // StatusBar_included
