#include "WidgetVarMapPage.h"

#include "prop/SignalSelectDialog.h"

#define Inherited WidgetVarMapPageData

WidgetVarMapPage::WidgetVarMapPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    widget->GetSignalList( itsSignals );

    connect( itsMapCB, SIGNAL(clicked()), SLOT(Update()) );

    itsVarName->setText( widget->GetVariableName() );
    itsMapCB->setChecked( widget->IsVariableMapped() );

    QListIterator<SignalConnection> iter( widget->GetConnectedSignalList() );
    SignalConnection* conn;

    while( (conn = iter()) )
    {
	itsSignalList->inSort( conn->ToString() );
    }

    connect( itsSignalList, SIGNAL(highlighted(int)), 
	     SLOT(SignalChanged(int)) );
    connect( itsSignalList, SIGNAL(selected(int)), SLOT(SignalSelected(int)) );

    connect( itsAddSignal, SIGNAL(clicked()), SLOT(AddSignal()) );
    connect( itsModifySignal, SIGNAL(clicked()), SLOT(ModifySignal()) );
    connect( itsDeleteSignal, SIGNAL(clicked()), SLOT(DeleteSignal()) );
    
    Update();
}


WidgetVarMapPage::~WidgetVarMapPage()
{
}


void WidgetVarMapPage::AddSignal()
{
    SignalSelectDialog dlg( itsSignals );
    if( dlg.exec() == QDialog::Accepted )
    {
	SignalConnection sig;
	dlg.GetData( sig );
    
	itsSignalList->inSort( sig.ToString() );
    }
}


void WidgetVarMapPage::ModifySignal()
{
    SignalSelectDialog dlg( itsSignals );
    SignalConnection sig;
    sig.FromString( itsSignalList->text( itsSignalList->currentItem() ) );
    dlg.SetData( sig );
    
    if( dlg.exec() == QDialog::Accepted )
    {
	dlg.GetData( sig );
    
	itsSignalList->removeItem( itsSignalList->currentItem() );
	itsSignalList->inSort( sig.ToString() );
    }
}


void WidgetVarMapPage::DeleteSignal()
{
    itsSignalList->removeItem( itsSignalList->currentItem() );

    Update();
}


void WidgetVarMapPage::Update()
{
    bool enable = itsMapCB->isChecked();

    itsVarName->setEnabled( enable );
    itsVarLabel->setEnabled( enable );

    enable = (itsSignalList->currentItem() != -1);
    
    itsModifySignal->setEnabled( enable );
    itsDeleteSignal->setEnabled( enable );
}


void WidgetVarMapPage::SignalChanged( int )
{
    Update();
}


void WidgetVarMapPage::SignalSelected( int item )
{
    if( item >= 0 )
    {
	ModifySignal();
    }
}


void WidgetVarMapPage::Apply( DlgWidget*	widget )
{
    widget->SetVariableMapping( itsMapCB->isChecked() ?
				itsVarName->text() : "" );

    
    QList<SignalConnection>& list = widget->GetConnectedSignalList();
    SignalConnection* sig;
    unsigned int i;
    
    list.clear();
    
    for( i = 0; i < itsSignalList->count(); i++ )
    {
	sig = new SignalConnection;
	sig->FromString( itsSignalList->text( i ) );
	list.append( sig );
    }
}

    










