#include <qregexp.h>

#include "widget/SignalConnection.h"


SignalConnection::SignalConnection()
    :
    itsScope( Protected )
{
}


SignalConnection::SignalConnection
(
    Scope		scope,
    const QString&	signal,
    const QString&	slot,
    const QString&	args 
)
    :
    itsScope( scope ),
    itsSignal( signal ),
    itsSlot( slot ),
    itsArgs( args )
{
}


const QString SignalConnection::GetSignal( void ) const
{
    QString str = itsSignal + "(" + itsArgs + ")";
    return str;
}


void SignalConnection::SetSignal
(
    const QString&	sig
)
{
    QString str = sig.copy();
    QRegExp args( "(.*)" );
    int len;
    int pos = args.match( str, 0, &len );
    
    if( len >= 0 )
    {
	itsArgs = str.mid( pos+1, len-2 );
	itsSignal = str.replace( args, "" );
    }
    else
    {
	itsArgs = "";
	itsSignal = str;
    }
}
    

const QString SignalConnection::GetSlot( void ) const
{
    QString str = itsSlot + "(" + itsArgs + ")";
    return str;
}


QString SignalConnection::ToString( void ) const
{
    QString str;
    
    str = "[";
    
    switch( itsScope )
    {
	case BaseClass:
	{
	    str += "BaseClass";
	    break;
	}
	case Protected:
	{
	    str += "Protected";
	    break;
	}
	case Public:
	{
	    str += "Public";
	    break;
	}
    }
    
    str += "]  " + itsSignal + " --> " + itsSlot + "  (" + itsArgs + ")";
    
    return str;
}


void SignalConnection::FromString( const QString& from )
{
    itsScope = Protected;
    itsSignal = "";
    itsSlot = "";

    QRegExp scopeReg( "^\\[.*\\]" );
    int len;
    
    int pos = scopeReg.match( from, 0, &len );
    if( pos >= 0 )
    {
	QString scope = from.mid( pos+1, len-2 );
	if( scope == "Protected" )
	{
	    itsScope = Protected;
	}
	else if( scope == "Public" )
	{
	    itsScope = Public;
	}
	else if( scope == "BaseClass" )
	{
	    itsScope = BaseClass;
	}
	
	QRegExp signalReg( ".*-->" );
	pos = signalReg.match( from, pos + len, &len );
	if( pos >= 0 )
	{
	    itsSignal = from.mid( pos, len-3 );
	    itsSignal = itsSignal.stripWhiteSpace();
	    
	    QRegExp slotReg( "-->.*(" );
	    pos = slotReg.match( from, pos + len - 3, &len );
	    
	    if( pos >= 0 )
	    {
		itsSlot = from.mid( pos + 3, len - 4 );
		itsSlot = itsSlot.stripWhiteSpace();

		QRegExp argReg( ".*)" );
		pos = argReg.match( from, pos + len, &len );
		
		if( pos >= 0 )
		{
		    itsArgs = from.mid( pos, len - 1 );
		    itsArgs = itsArgs.stripWhiteSpace();
		}
	    }
	}
    }
}






