#include "figure.hh"
#include "pencil.hh"

static unsigned cx;

void 
TFigText::CalcSize()
{
	w = h = 0;
	unsigned l, r;
	l = 0;
	while(true) {
		h+=TOADBase::DefaultFont().Height();
		r = text.find('\n', l);
		int wl = TOADBase::DefaultFont().TextWidth(text.substr(l,r==string::npos ? r : r-l));
		if (wl>w)
			w=wl;
		if (r==string::npos)
			break;
		l = r+1;
	}
	w++; h++; // for the text cursor...
}

void 
TFigText::paint(TPencil &pen, bool edit)
{
	unsigned l,r;
	double yp = y;
	l = 0;
	while(true) {
		r = text.find('\n', l);
		pen.DrawString(x,yp, text.substr(l,r==string::npos ? r : r-l));
		if (edit && l<=cx && cx<=r) {
			unsigned dx = pen.TextWidth(text.substr(l, cx-l));
			pen.DrawLine(x+dx,yp,x+dx,yp+pen.Height());
		}
		if (r==string::npos)
			break;
		l = r+1;
		yp+=pen.Height();
	}
}

double 
TFigText::distance(double mx, double my)
{
	if (IsInside(mx, my))
		return INSIDE;
	return super::distance(mx,my);
}

int
TFigText::getHandle(double, double)
{
	return -1;
}

bool 
TFigText::startInPlace()
{
	cx = 0;
	return true;
}

void 
TFigText::startCreate()
{
	cx = 0;
}

unsigned 
TFigText::stop()
{
	if (text.empty())
		return STOP|DELETE;
	return STOP;
}

unsigned 
TFigText::keyDown(TFigureEditor *editor, TKey key, char*, unsigned)
{

cout << __PRETTY_FUNCTION__ << endl;

	editor->InvalidateFigure(this);
	switch(key) {
		case TK_LEFT:
			if (cx>0)
				cx--;
			break;
		case TK_RIGHT:
			if (cx<text.size())
				cx++;
			break;
		case TK_UP:
			break;
		case TK_DOWN:
			break;
		case TK_HOME:
			if (cx==0 || text[cx-1]=='\n')
				break;
			cx = text.rfind('\n', cx-1);
			if (cx==string::npos)
				cx=0;
			else
				cx++;
			break;
		case TK_END:
			cx = text.find('\n', cx);
			if (cx==string::npos)
				cx=text.size();
			break;
		case TK_BACKSPACE:
			if (cx>0)
				cx--;
			else
				break;
		case TK_DELETE:
			text.erase(cx,1);
			break;
		case TK_RETURN:
			text.insert(cx, 1, '\n');
			cx++;
			break;
		default:
			if (key>=32 && key<=255) {
				text.insert(cx, 1, key);
				cx++;
			}
	}
	CalcSize();
	editor->InvalidateFigure(this);
	return CONTINUE;
}

unsigned 
TFigText::mouseLDown(TFigureEditor *editor, double x, double y, unsigned)
{
	switch(editor->mode) {
		case TFigureEditor::MODE_CREATE:
			this->x = x;
			this->y = y;
			CalcSize();
			editor->InvalidateFigure(this);
			startInPlace();
			break;
			
		case TFigureEditor::MODE_CREATING:
		case TFigureEditor::MODE_EDIT_IN_PLACE:
			if (distance(x,y)>RANGE) {
				editor->window->Invalidate(this);
				if (text.empty())
					return STOP|DELETE|REPEAT;
				return STOP|REPEAT;
			}
			break;
			
		default:
			break;
	}
	return CONTINUE;
}

unsigned
TFigText::mouseMove(TFigureEditor*, double, double, unsigned)
{
	return CONTINUE;
}

unsigned 
TFigText::mouseLUp(TFigureEditor*, double, double, unsigned)
{
	return CONTINUE;
}

void 
TFigText::store(TOutBinStream &file, ulong version)
{
	super::store(file, version);
	file.WriteWord(text.size());
	file.WriteString(text.c_str(), text.size());
}

void 
TFigText::restore(TInBinStream &file, ulong version)
{
	super::restore(file, version);
	unsigned l = file.ReadWord();
	char buffer[l+1];
	file.ReadString(buffer,l);
	buffer[l]=0;
	text = buffer;
}
