/*
 * robot -- a demonstration of the TOAD TGLWindow
 * Copyright (C) 1997,99 by Mark-Andr Hopf <mhopf@mark13.de>
 *
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * Requirements:
 * - Mesa 2.0 or OpenGL
 * - TOAD
 */

#include <toad/toad.hh>
#include <toad/form.hh>
#include <toad/menubar.hh>
#include <toad/scrollbar.hh>
#include "glwindow.hh"

// redefine 'exception' to avoid trouble between C++ and SGIs <math.h>
#define exception mexception
#include <math.h>
#undef exception

#include <cstdio>
#include <cstdlib>
#include <vector>

#define DEBUG

class TViewer: public TGLWindow
//------------------------------
{
	public:
		GLfloat angle[4];
		TViewer(TWindow *p,const string &t):TGLWindow(p,t)
		{
			for(int i=0;i<4;i++)
				angle[i]=0.0;
		};
	protected:
		void glPaint();
};

class TMainWindow: public TForm
//------------------------------
{
	public:
		TMainWindow(TWindow *p,const string &t)
		:TForm(p,t){};
	protected:
		TViewer *gl;
		void create();
		void menuQuit();
		void menuInfo();
		void menuCopyright();
		void actScrollBar(TScrollBar*,int);
};


int ToadMain()
{
	return TMainWindow(NULL,"Robot").Run();
}

// TMainWindow
//--------------------------------------------------------------------
void TMainWindow::create()
{
	SetSize(640,480);
	SetBackground(TColor::DIALOG);

	// create menubar
	//----------------
	TMenuBar *mb=new TMenuBar(this);
	TMenuItem *mi;

	mb->BgnPulldown("File");
		mi = mb->AddItem("Quit");
		CONNECT(mi->sigActivate, this,menuQuit);
	mb->EndPulldown();

	mb->BgnPulldown("Help");
		mi = mb->AddItem("Info");
		CONNECT(mi->sigActivate, this,menuInfo);
		mi = mb->AddItem("Copyright");
		CONNECT(mi->sigActivate, this,menuCopyright);
	mb->EndPulldown();

	// create viewer
	//---------------
	gl = new TViewer(this,"OpenGL Window");

	// create scrollbars
	//-------------------
	const int maxbar = 4;

	TScrollBar *sb[maxbar];
	int i;
	for(i=0; i<maxbar; i++)
	{
		sb[i] = new TVScrollBar(this,"");
		sb[i]->SetVisible(1);
		sb[i]->SetRange(-180,180);
		sb[i]->SetValue(0);
		CONNECT(sb[i]->sigValueChanged, this, actScrollBar, sb[i], i);
	}

	// set up form definition
	//------------------------
	Attach(mb, SIDE_TOP | SIDE_LEFT | SIDE_RIGHT, ATTACH_FORM);

	for(i=0; i<maxbar; i++)
	{
		Attach(sb[i], SIDE_TOP, ATTACH_WINDOW, mb);
		Attach(sb[i], SIDE_BOTTOM, ATTACH_FORM);
		if (i==0)
			Attach(sb[0], SIDE_RIGHT, ATTACH_FORM);
		else
			Attach(sb[i], SIDE_RIGHT, ATTACH_WINDOW, sb[i-1]);
		Distance(sb[i],10);
	}
	
	Attach(gl, SIDE_TOP, ATTACH_WINDOW, mb);
	Attach(gl, SIDE_LEFT | SIDE_BOTTOM, ATTACH_FORM);
	Attach(gl, SIDE_RIGHT, ATTACH_WINDOW, sb[maxbar-1]);
	Distance(gl, 10);
}

void TMainWindow::actScrollBar(TScrollBar *sb, int id)
{
	// printf("Value of %i set to %i\n",sb->ID(),sb->Value());
	gl->angle[id] = sb->Value();
	gl->UpdateWindow();
}

void TMainWindow::menuQuit()
{
	if(MessageBox(this,Title(),"Do you really want to quit the program?",
		MB_ICONQUESTION | MB_YESNO)==IDYES)
	{
		PostQuitMessage(0);
	}
}

void TMainWindow::menuInfo()
{
  MessageBox(this, Title(),
  	"This program is a demonstration for the TOAD GUI Toolkit "
  	"cooperating with Mesa 2.0 and OpenGL.\n"
  	"For further information write to:\n" 
    "hopf@informatik.uni-rostock.de"
    , MB_ICONINFORMATION | MB_OK);
}

void TMainWindow::menuCopyright()
{
  MessageBox(this, Title(),
    "Copyright  1997,99 by Mark-Andr Hopf\n\n"
    "This program is free software; you can redistribute it and/or modify "
    "it under the terms of the GNU General Public License as published by "
    "the Free Software Foundation; either version 2 of the License, or "
    "(at your option) any later version.\n\n"
    "This program is distributed in the hope that it will be useful, "
    "but WITHOUT ANY WARRANTY; without even the implied warranty of "
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
    "GNU General Public License for more details.\n\n"
    "You should have received a copy of the GNU General Public License "
    "along with this program; if not, write to the Free Software "
    "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA."
    , MB_ICONINFORMATION | MB_OK);
}            

// TViewer
//--------------------------------------------------------------------
static void segment(GLfloat len)
{
	glBegin(GL_POLYGON);
	glNormal3f( 0.0, 1.0, 0.0);
	glVertex3f(-0.5, len,-0.5);
	glVertex3f(-0.5, len, 0.5);
	glVertex3f( 0.5, len, 0.5);
	glVertex3f( 0.5, len,-0.5);
	glEnd();

	glBegin(GL_POLYGON);
	glNormal3f( 0.0,-1.0, 0.0);
	glVertex3f(-0.5, 0.0,-0.5);
	glVertex3f( 0.5, 0.0,-0.5);
	glVertex3f( 0.5, 0.0, 0.5);
	glVertex3f(-0.5, 0.0, 0.5);
	glEnd();

	glBegin(GL_POLYGON);
	glNormal3f( 0.0, 0.0, 1.0);
	glVertex3f(-0.5, 0.0, 0.5);
	glVertex3f( 0.5, 0.0, 0.5);
	glVertex3f( 0.5, len, 0.5);
	glVertex3f(-0.5, len, 0.5);
	glEnd();

	glBegin(GL_POLYGON);
	glNormal3f(-1.0, 0.0,  0.0);
	glVertex3f(-0.5, 0.0, -0.5);
	glVertex3f(-0.5, 0.0,  0.5);
	glVertex3f(-0.5, len,  0.5);
	glVertex3f(-0.5, len, -0.5);
	glEnd();

	glBegin(GL_POLYGON);
	glNormal3f( 0.0, 0.0, -1.0);
	glVertex3f(-0.5, 0.0, -0.5);
	glVertex3f(-0.5, len, -0.5);
	glVertex3f( 0.5, len, -0.5);
	glVertex3f( 0.5, 0.0, -0.5);
	glEnd();

	glBegin(GL_POLYGON);
	glNormal3d(1.0, 0.0,  0.0);
	glVertex3f(0.5, 0.0, -0.5);
	glVertex3f(0.5, len, -0.5);
	glVertex3f(0.5, len,  0.5);
	glVertex3f(0.5, 0.0,  0.5);
	glEnd();
}

void TViewer::glPaint()
{
	glClearColor( 0.0, 0.0, 0.5, 0.0 );
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();
	glFrustum( -1.0,		// left
							1.0,  	// right
							-1.0, 	// bottom
							1.0,  	// top
							1.0, 		// near
							40.0		// far
	);
	
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();

	glEnable(GL_CULL_FACE);
	glEnable(GL_DEPTH_TEST);
	// glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
	
	glEnable(GL_LIGHTING);
	glEnable(GL_COLOR_MATERIAL);
	glEnable(GL_LIGHT0);

	glTranslatef(0.0, -5.0, -10.0);
	glRotatef(angle[0], 0.0, 1.0, 0.0);
	glRotatef(angle[1], 1.0, 0.0, 0.0);

	glColor3f(1.0, 0.0, 0.0);
	segment(5.0);
	
	glTranslatef(0.0, 5.0, 0.0);
	glRotatef(angle[2], 1.0, 0.0, 0.0);
	glColor3f(0.0, 1.0, 0.0);
	segment(3.0);

	glTranslatef(0.0, 3.0, 0.0);
	glRotatef(angle[3], 1.0, 0.0, 0.0);
	glColor3f(0.0, 0.5, 1.0);
	segment(2.0);
}
