#include <toad/toad.hh>
#include <toad/bitmap.hh>

class TMyWindow: public TWindow
{
  public:
    TMyWindow(TWindow *parent, const string &title);
  protected:
  	void paint();
  private:
  	TBitmap bitmap;
};

TMyWindow::TMyWindow(TWindow *parent, const string &title)
	:TWindow(parent,title)
{
	try {
		bitmap.Load("alien.png");
	} catch(exception &e) {
		cout << e.what() << endl;
	}
}

void TMyWindow::paint()
{
	cout << "paint" << endl;
	TPen pen(this);
  for(int i=0; i<320; i+=25)
    pen.DrawLine(i,0, i,200);
  for(int i=0; i<200; i+=25)
    pen.DrawLine(0,i, 320,i);

  pen.SetColor(255,0,0);
  pen.FillRectangle(7,7,100,100);

  pen.SetBitmap(&bitmap);
  pen.FillCircle(220,50,100,100);

	pen.SetColor(0,255,0);
	pen.FillCircle(240,70,60,60);

  pen.SetColor(0,0,0);
  pen.DrawString(30,40, "This is cool...");

  pen.DrawBitmap(128,68, bitmap);
  cout << "painted" << endl;
}

int ToadMain()
{
	cout << "running" << endl;
  return TMyWindow(NULL, "4th program").Run();
}
