/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

// base filter class for import/export of TBitmap data
//-----------------------------------------------------

#ifndef TBitmapFilter
#define TBitmapFilter TBitmapFilter

class TBitmapFilter
{
	public:
		TBitmapFilter();
		virtual ~TBitmapFilter() {};

		virtual const char* GetName()=0;
		virtual const char* GetExt()=0;
		virtual int EditSpecific(){return 0;}

		enum EResult {
			OK, WRONG, ERROR
		};

		virtual bool Save(ostream&)=0;
		virtual EResult Load(istream&)=0;

		void DeleteBuffer();
		void CreateBuffer(int w,int h,EBitmapType);
		void SetBuffer(int w,int h,TRGB*,unsigned char*);
		void GetBuffer(int *w,int *h,TRGB**,unsigned char**);
		bool IsIndex();
		bool ConvertToIndexed(int *palette_size);
		
		// index
		void SetIndexColor(int index, TRGB &c);
		bool GetIndexColor(int index, TRGB *c);
		void SetIndexPixel(int x,int y,int index);
		// void SetIndexLine(int y, byte*);
		// void SetIndexLine(int y, ushort*);
		// void SetIndexLine(int y, ulong*);
		int GetIndexPixel(int x,int y);
		
		// true color
		void SetColorPixel(int x,int y,TRGB&);
		// void SetColorLine(int y, TRGB*);
		bool GetColorPixel(int x,int y,TRGB*);
		
		void SetError(const char *txt);
		const char *errortxt;

	protected:
		int w,h;

	private:
		TRGB *color;
		unsigned char *index;
		bool mycolor:1;
		bool myindex:1;
		
	public:
		TBitmapFilter *next;
};

#endif
