/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toadbase.hh>
#include <toad/pen.hh>
#include <toad/window.hh>
#include <toad/buttonbase.hh>
#include <toad/scrollbar.hh>
#include <toad/listbox.hh>
#include <toad/combobox.hh>

#define DBM(A)

const char* TComboBox::_lb_title="combobox.listbox";

//!TComboBox
//. Under construction again.

//!TComboButton
//. The correct name is TComboBox::TComboButton and you don't need it.

// class TComboButton
//----------------------------------------------------------------------------
class TComboBox::TComboButton: public TButtonBase
{
	public:
		TComboButton(TWindow *parent, const string &title)
		:TButtonBase(parent,title){};

	protected:
		void paint();
		void mouseLDown(int,int,unsigned);
};

// paint
//----------------------------------------------------------------------------
void TComboBox::TComboButton::paint()
{
	TPen g(this);
	DrawShadow(g, bDown);
	TPoint p[4];
	const int d=6;
	int n=bDown?1:0;

	int max = _h>_w ? _h : _w;
	int x = (_w-max)>>1;
	int y = (_h-max)>>1;

	p[0].Set(x+n+(max>>1)	, y+n+_h-d);
	p[1].Set(x+n+max-d	, y+n+d-1);
	p[2].Set(x+n+d			, y+n+d-1);

	g.SetColor(TColor::BTNTEXT);
	g.FillPolygon(p,3);
	g.FillRectangle(n+d-2, n+_h-d+1, _w-d-d+4,2);
}

// mouseLDown
//----------------------------------------------------------------------------
void TComboBox::TComboButton::mouseLDown(int,int,unsigned)
{
	SetDown(!bDown);
}

/*****************************************************************************
 *																																					 *
 * TComboBox                                                                 *
 *																																					 *
 *****************************************************************************/

// Constructor
//----------------------------------------------------------------------------
TComboBox::TComboBox(TWindow *p,const string &t, TLBAdapter *a)
 :super(p,t), lb(this, _lb_title, a)
{
	_Init();
}

void TComboBox::_Init()
{
	_h=20;
	_w=100;

	// set up listbox
	//----------------
	
	// this `SetSize' call is needed to set the height of the listbox so
	// TListBox::Center works correctly during TListBox::Select
	lb.SetSize(Width(), (DefaultFont().Height()+1)*8);

	CONNECT(lb.sigSelect, this, actSelect);
	
	lb.bExplicitCreate = lb.bPopup = lb.bSaveUnder = lb._faked_focus = true;

	SetBorder(true);

	btn = new TComboButton(this,"combobox.combobutton");
		OLD_CONNECT(this,buttonDown, 	 btn,btn->sigArm);
		OLD_CONNECT(this,closeRequest, btn,btn->sigDisarm);
		btn->SetShape(
			_w-TScrollBar::FixedSize()+1,-1,
			TScrollBar::FixedSize(),_h+2
		);
}

void TComboBox::SetAdapter(TLBAdapter *a)
{
	lb.SetAdapter(a);	// this will destroy the old adapter
	Invalidate();
}

unsigned TComboBox::GetFirstSelectedItem()
{
	return lb.GetFirstSelectedItem();
}

void TComboBox::SetSelection(unsigned n)
{
	lb.Select(n);
	Invalidate();
}

// paint
//----------------------------------------------------------------------------
void TComboBox::paint()
{
	if (!lb.GetAdapter())
		return;
	TPen pen(this);
	int y = (_h-lb.GetAdapter()->ItemHeight())>>1;
	unsigned item = lb.GetFirstSelectedItem();
	if (item==TListBox::npos)
		item=0;
	lb.GetAdapter()->PrintItem(8,y,lb.GetFirstSelectedItem(),pen);
	if (IsFocus()) {
		pen.DrawRectangle(0,0,Width()-TScrollBar::FixedSize()+1,Height());
	}
}

void TComboBox::keyDown(TKey k,char* s,unsigned m)
{
	if (lb.Visible()) {
		lb.keyDown(k,s,m);
	} else {
		if (k==TK_DOWN || k==TK_SPACE)
			buttonDown();
	}
}

void TComboBox::resize()
{
	btn->SetShape(
		_w-TScrollBar::FixedSize()+1,-1,
		TScrollBar::FixedSize(),_h+2
	);
}

// select
//---------------------------------------------------------------------------
void TComboBox::actSelect(unsigned n)
{
	UpdateWindow(true);
	btn->SetDown(false);
	lb.SetVisible(false);
	sigSelect(n);
}

// button
//---------------------------------------------------------------------------
void TComboBox::buttonDown()
{
	ENTRYEXIT("void TComboBox::buttonDown()");
	SetFocus();

	lb.SetSize(Width(), (DefaultFont().Height()+1)*8);
	PlaceWindow(&lb, PLACE_PULLDOWN, this);

	if (lb.IsRealized()) {
		lb.SetVisible(true);
		lb.RaiseWindow();
	}	else {
		lb.SetVisible(true);
		lb.Create();
	}
	GrabPopupMouse();	// the normal popup behaviour for the mouse fails here,
										// don't know why
}

// closeRequest
//---------------------------------------------------------------------------
void TComboBox::closeRequest()
{
	ENTRYEXIT("void TComboBox::closeRequest()");
	btn->SetDown(false);
	lb.SetVisible(false);
	UngrabMouse();
}
