/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef GHistory
#define GHistory GHistory

#include <toad/connect.hh>
#include <deque>
#include <stdexcept>

template<class T>
class GHistory
{
		typedef deque<T> TStorage;
		TStorage storage;
		TStorage::iterator p;
		unsigned bs, fs;
		unsigned size;
		
	public:
		GHistory() {
			p=storage.begin();
			bs = fs = 0;
			size = 20;
		}
		void SetSize(unsigned s) {
			s = size;
		}
		void Clear() {
			storage.clear();
			p=storage.begin();
			bs = fs = 0;
			Signal();
		}
		void Add(const T& d) {
			storage.erase(p, storage.end());
			storage.push_back(d);
			p = storage.end();
			fs = 0;
			if (storage.size()>size)
				storage.erase(storage.begin());
			bs=storage.size();
			Signal();
		}
		const T& Current() {
			if (p==storage.begin())
				throw runtime_error("GHistory: no current");
			return *(p-1);
		}
		void Back() {
			if (p==storage.begin())
				throw runtime_error("GHistory: can't go back");
			p--;
			bs--;
			fs++;
			Signal();
		}
		void Forward() {
			if (p==storage.end())
				throw runtime_error("GHistory: can't go forward");
			p++;
			bs++;
			fs--;
			Signal();
		}
		void Signal()
		{
			sigEnableBack(bs!=0);
			sigEnableForward(fs!=0);
		}
		unsigned BackSize() { return bs; }
		unsigned ForwardSize() { return fs; }

		GSignal1P<bool> sigEnableBack, sigEnableForward;
};

#endif
