/*
	
*/

enum EWMType {
	WM_UNKNOWN,
	WM_FVWM,
	WM_KDE
} wmtype = WM_UNKNOWN;

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#define _TOAD_PRIVATE

#include <toad/toad.hh>

class TMainWindow:
	public TWindow
{
	public:
		TMainWindow(TWindow *p, const string &t);
		void mouseLDown(int,int,unsigned);
		void mouseMDown(int,int,unsigned);
		
		void resize();
};

static Window GetTopParent(Window current)
{
	Window root;
	Window parent;
	Window *children;
	unsigned nchildren;
	while(true) {
		XQueryTree(TOADBase::display, current, &root, &parent, &children, &nchildren);
		if (children)
			XFree(children);
		if (parent==root)
			break;
		current = parent;
	}
	return current;
}

int ToadMain()
{
	return TMainWindow(NULL, "WM Check").Run();
}

TMainWindow::TMainWindow(TWindow *p, const string &t):
	TWindow(p, t)
{
	SetSize(100,100);
}

void TMainWindow::mouseLDown(int,int,unsigned)
{
	if (!parent) {
		Window current = GetTopParent(window);
		XWindowAttributes attr;
		XGetWindowAttributes(display, current, &attr);
		cout << "wm shape: x=" << attr.x << " y=" << attr.y <<
										 " w=" << attr.width << " h=" << attr.height <<
										 " b=" << attr.border_width << endl;

		int rx, ry;
		unsigned rw, rh, rb, rd;
		Window rroot;
		XGetGeometry(display, current, &rroot, &rx, &ry, &rw, &rh, &rb, &rd);
		cout<< "wm shape: x=" << rx << " y=" << ry
				<< " w=" << rw << " h=" << rh << endl;

	}
}

void TMainWindow::mouseMDown(int,int,unsigned)
{
	if (!parent) {
		Window current = GetTopParent(window);
		
		int rx, ry;
		unsigned rw, rh, rb, rd;
		Window rroot;
		
		int x,y,w,h;
		x=111; y=222; w=66; h=77;

redo:

switch(wmtype) {
	case WM_UNKNOWN:
		cout << "WM_UNKNOWN" << endl;
		break;
	case WM_FVWM:
		cout << "WM_FVWM" << endl;
		break;
	case WM_KDE:
		cout << "WM_KDE" << endl;
		break;
}

		XWindowAttributes attr;
		XGetWindowAttributes(display, current, &attr);
		switch(wmtype) {
			case WM_UNKNOWN:
				XMoveResizeWindow(display, current, 
				 	x + _x - attr.x,
				 	y + _y - attr.y,
				 	w + _w - attr.width,
				 	h + _h - attr.height);
				XFlush(display);
				XSync(display, False);
				sleep(2);
				XGetGeometry(display, current, &rroot, &rx, &ry, &rw, &rh, &rb, &rd);
				cout << "rw:" << rw << endl;
				if (rw==w) {
					wmtype=WM_FVWM;
				}
				else if (rw==w + _w - attr.width) {
					wmtype=WM_KDE;
					goto redo;
				} else {
					wmtype=WM_KDE;
					goto redo;
				}
			 	break;

			case WM_FVWM:
				XMoveResizeWindow(display, current, 
				 	x + _x - attr.x,
				 	y + _y - attr.y,
				 	w + _w - attr.width,
				 	h + _h - attr.height);
			 	break;

			case WM_KDE:
				XMoveResizeWindow(display, current, 
				 	x,
				 	y,
				 	w,
				 	h);
				break;
		}
	}
}

void TMainWindow::resize()
{
	cout << "resize: " << _w << ", " << _h << endl;
	mouseLDown(0,0,0);
}
