/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/gadget.hh>
#include <toad/gadgeteditor.hh>

void TGRectangle::getShape(TRectangle &r)
{
	r.Set(p1,p2);
}

void 
TGRectangle::paint(TPen &pen, EPaintType)
{
	pen.SetLineColor(line_color);
	if (!filled) {
		pen.DrawRectangle(p1,p2);
	} else {
		pen.SetFillColor(fill_color);
		pen.FillRectangle(p1,p2);
	}
}

double 
TGRectangle::distance(int mx, int my)
{
  if (filled && TRectangle(p1, p2).IsInside(mx, my))
		return INSIDE;

	int x1,y1,x2,y2;
	double min = OUT_OF_RANGE, d;
	
	for(int i=0; i<4; i++) {
		switch(i) {
		case 0:
			x1=p1.x; y1=p1.y; x2=p2.x; y2=p1.y;
			break;
		case 1:
			x1=p2.x; y1=p2.y;
			break;
		case 2:
			x2=p1.x; y2=p2.y;
			break;
		case 3:
			x1=p1.x; y1=p1.y;
			break;
		}
		d = Distance2Line(mx,my, x1,y1, x2,y2);
		if (d<min)
			min = d;
	}
	return min;
}

void 
TGRectangle::translate(int dx, int dy)
{
	p1.x+=dx;
	p1.y+=dy;
	p2.x+=dx;
	p2.y+=dy;
}

bool 
TGRectangle::getHandle(unsigned handle, TPoint &p)
{
	switch(handle) {
		case 0:
			p = p1;
			return true;
		case 1:
			p.x = p2.x;
			p.y = p1.y;
			return true;
		case 2:
			p = p2;
			return true;
		case 3:
			p.x = p1.x;
			p.y = p2.y;
			return true;
	}
	return false;
}

void 
TGRectangle::translateHandle(unsigned handle, int x, int y)
{
	switch(handle) {
		case 0:
			p1.x = x;
			p1.y = y;
			break;
		case 1:
			p2.x = x;
			p1.y = y;
			break;
		case 2:
			p2.x = x;
			p2.y = y;
			break;
		case 3:
			p1.x = x;
			p2.y = y;
			break;
	}
}

unsigned 
TGRectangle::mouseLDown(TGadgetEditor *editor, int mx, int my, unsigned)
{
	switch(editor->state) {
		case TGadgetEditor::STATE_START_CREATE:
			p1.x = p2.x = mx;
			p1.y = p2.y = my;
			editor->InvalidateFigure(this);
			break;
		default:
			break;
	}
	return CONTINUE;
}

unsigned 
TGRectangle::mouseMove(TGadgetEditor *editor, int mx, int my, unsigned)
{
	switch(editor->state) {
		case TGadgetEditor::STATE_CREATE:
			editor->InvalidateFigure(this);
			p2.x = mx;
			p2.y = my;
			editor->InvalidateFigure(this);
			break;
		default:
			break;
	}
	return CONTINUE;
}

unsigned 
TGRectangle::mouseLUp(TGadgetEditor *editor, int mx, int my, unsigned)
{
	switch(editor->state) {
		case TGadgetEditor::STATE_CREATE:
			mouseMove(editor,mx,my,0);
			if (p1.x==p2.x && p1.y==p2.y)
				return STOP|DELETE;
			return STOP;
		default:
			break;
	}
	return CONTINUE;
}

void TGRectangle::store(TOutObjectStream &file, ulong version)
{
	super::store(file, version);
	TRectangle r(p1,p2);
	file.WriteSWord(r.x);
	file.WriteSWord(r.y);
	file.WriteWord(r.w);
	file.WriteWord(r.h);
}

void TGRectangle::restore(TInObjectStream &file, ulong version)
{
	super::restore(file, version);
	TRectangle r(p1, p2);
	r.x = file.ReadSWord();
	r.y = file.ReadSWord();
	r.w = file.ReadWord();
	r.h = file.ReadWord();
	SetShape(r.x, r.y, r.w, r.h);
}
