/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TLBA_StaticCString
#define TLBA_StaticCString TLBA_StaticCString

class TLBA_StaticCString: public TLBAdapter
{
	public:
		TLBA_StaticCString(const char** array,unsigned count);
		TLBA_StaticCString(const char** array);
		unsigned ItemHeight();
		unsigned ItemCount();
		void PrintItem(int x,int y,unsigned item,TPen &);
		string GetItemAsString(unsigned);
	private:
		unsigned count;
		const char **array;
};

inline TLBA_StaticCString::TLBA_StaticCString(const char **a,unsigned n)
{
	array=a;
	count=n;
}

inline TLBA_StaticCString::TLBA_StaticCString(const char **a)
{
	array=a;
	count=0;
	const char **p = a;
	while(*p)
	{
		count++;
		p++;
	}
}

inline unsigned TLBA_StaticCString::ItemHeight()
{
	return TOADBase::DefaultFont().Height();
}

inline unsigned TLBA_StaticCString::ItemCount()
{
	return count;
}

inline void TLBA_StaticCString::PrintItem(int x,int y,unsigned item,TPen &pen)
{
	if (item>=count) return;
	pen.DrawString(x,y,array[item]);
}

inline string TLBA_StaticCString::GetItemAsString(unsigned item)
{
	if (item>=count) return "";
	return array[item];
}

#endif
