/* $XConsortium: TimeChart.c,v 1.20 91/05/24 17:20:42 converse Exp $ */

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

 * Copyright 1994, Roger Smith for Sterling Software and NASA-Ames Research Center
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of NASA and Sterling Software (collectively 
 * or individually) are not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  NASA and Sterling Software makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * NASA & STERLING SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL NASA & STERLING SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * 1994 Revision
 * Author:           Roger Smith, Sterling Software @ NASA-Ames Research Center
 *                   Moffett Field, California, rsmith@proteus.arc.nasa.gov
******************************************************************/

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/XawInit.h>
#include "TimeCharP.h"
#include "system.h"
#ifdef X11R5
#include <X11/Xfuncs.h>
#endif
#define MS_PER_SEC 100

/* Private Data */

#define offset(field) XtOffsetOf(TimeChartRec, field)

static XtResource resources[] = {
    {XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
	offset(core.width), XtRImmediate, (XtPointer) 120},
    {XtNheight, XtCHeight, XtRDimension, sizeof(Dimension),
	offset(core.height), XtRImmediate, (XtPointer) 120},
    {XtNupdate, XtCInterval, XtRInt, sizeof(int),
        offset(time_chart.update), XtRImmediate, (XtPointer) 10},
    {XtNminScale, XtCScale, XtRInt, sizeof(int),
        offset(time_chart.min_scale), XtRImmediate, (XtPointer) 1},
    {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
        offset(time_chart.fgpixel), XtRString, XtDefaultForeground},
    {XtNhighlight, XtCForeground, XtRPixel, sizeof(Pixel),
        offset(time_chart.hipixel), XtRString, XtDefaultForeground},
    { XtNfillRect, XtCFillRect, XtRBoolean, sizeof (Boolean),
	offset(time_chart.fillRect), XtRString, "False" },

    { XtNfont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
        offset(time_chart.font), XtRString, XtDefaultFont },
    {XtNgetValue, XtCCallback, XtRCallback, sizeof(XtPointer),
        offset(time_chart.get_value), XtRImmediate, (XtPointer) NULL},
    {XtNjumpScroll, XtCJumpScroll, XtRInt, sizeof(int),
        offset(time_chart.jump_val), XtRImmediate, (XtPointer) DEFAULT_JUMP},
};

#undef offset
#define LABEL_ROOM 100
#define XTW(s) XTextWidth(w->time_chart.font, s, strlen(s))
#define XDS(s) XDrawString(XtDisplay(w), XtWindow(w), \
			   w->time_chart.hiGC, x, y, s, strlen(s)),\
                           w->time_chart.timestamp_end[w->time_chart.num_timestamps++]=x+XTW(s)
extern AppData appData;
static void Initialize(), Destroy(), Redisplay(), MoveChart(), SetPoints();
extern void handleResize();
static Boolean SetValues();
static int repaint_window();
static int firstTime=TRUE;
Dimension oldHeight, oldWidth;
time_t timeStamp;
char numstring[32];

TimeChartClassRec timeChartClassRec = {
    { /* core fields */
    /* superclass		*/	(WidgetClass) &simpleClassRec,
    /* class_name		*/	"TimeChart",
    /* size			*/	sizeof(TimeChartRec),
    /* class_initialize		*/	XawInitializeWidgetSet,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	XtExposeCompressMultiple |
	                                XtExposeGraphicsExposeMerged,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	SetPoints,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	NULL,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
    },
    { /* Simple class fields */
    /* change_sensitive		*/	XtInheritChangeSensitive
    }
};

WidgetClass timeChartWidgetClass = (WidgetClass) &timeChartClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

void draw_string();

/*	Function Name: CreateGC
 *	Description: Creates the GC's
 *	Arguments: w - the time chart widget.
 *                 which - which GC's to create.
 *	Returns: none
 */

static void CreateGC(w, which)
TimeChartWidget w;
unsigned int which;
{
  XGCValues	myXGCV;

  if (which & FOREGROUND) {
    myXGCV.foreground = w->time_chart.fgpixel;
    myXGCV.font = w->time_chart.font->fid;
    w->time_chart.fgGC = XtGetGC((Widget) w, (GCForeground|GCFont), &myXGCV);
  }

  if (which & HIGHLIGHT) {
    myXGCV.foreground = w->time_chart.hipixel;
    myXGCV.font = w->time_chart.font->fid;
    w->time_chart.hiGC = XtGetGC((Widget) w, (GCForeground|GCFont), &myXGCV);
  }
}

/*	Function Name: DestroyGC
 *	Description: Destroys the GC's
 *	Arguments: w - the time chart widget.
 *                 which - which GC's to destroy.
 *	Returns: none
 */

static void DestroyGC(w, which)
TimeChartWidget w;
unsigned int which;
{
  if (which & FOREGROUND) 
    XtReleaseGC((Widget) w, w->time_chart.fgGC);

  if (which & HIGHLIGHT) 
    XtReleaseGC((Widget) w, w->time_chart.hiGC);
}

/* ARGSUSED */
static void Initialize (greq, gnew)
    Widget greq, gnew;
{
    TimeChartWidget w = (TimeChartWidget)gnew;
    int i;

    if (w->time_chart.font == NULL)
	w->time_chart.font = XQueryFont(XtDisplay(w),
	    XGContextFromGC(DefaultGCOfScreen(XtScreen(w))));

    CreateGC(w, (unsigned int) ALL_GCS);

    w->time_chart.font_height = w->time_chart.font->max_bounds.ascent
	 + w->time_chart.font->max_bounds.descent;

    w->time_chart.next_x = w->time_chart.last_end = 0;
    w->time_chart.num_timestamps = 0;
    for ( i = 0; i<32; i++ )
	w->time_chart.timestamp_end[i] = 0;

    w->time_chart.scale = w->time_chart.min_scale;
    w->time_chart.interval = LABEL_ROOM;
    w->time_chart.max_value = 0.0;
    w->time_chart.points = NULL;
    SetPoints(w);
}

static void Destroy (gw)

     Widget gw;
{
     TimeChartWidget w = (TimeChartWidget)gw;

     if (w->time_chart.update > 0)
         XtRemoveTimeOut (w->time_chart.interval_id);
     if (w->time_chart.points)
	 XtFree((char *) w->time_chart.points);
     DestroyGC(w, (unsigned int) ALL_GCS);
}

/*
 * NOTE: This function really needs to recieve graphics exposure 
 *       events, but since this is not easily supported until R4 I am
 *       going to hold off until then.
 */

/* ARGSUSED */
static void Redisplay(w, event, region)
     Widget w;
     XEvent *event;
     Region region;
{
    TimeChartWidget ww = (TimeChartWidget)w;
    if ( firstTime ) {
	XtInsertEventHandler(appData.toplevel, StructureNotifyMask, FALSE, handleResize, (Opaque)NULL, XtListHead);
	firstTime = FALSE;
	oldHeight = (int)ww->core.parent->core.parent->core.height;
	oldWidth = (int)ww->core.parent->core.parent->core.width;
/*	printf("oldHeight=%d, oldWidth=%d\n", oldHeight, oldWidth);*/
    }
    if (event->type == GraphicsExpose)
	(void) repaint_window ((TimeChartWidget)w, event->xgraphicsexpose.x,
			       event->xgraphicsexpose.width);
    else
	(void) repaint_window ((TimeChartWidget)w, event->xexpose.x,
			       event->xexpose.width);
}

/* ARGSUSED */
void draw_string(client_data, id)
XtPointer client_data;
XtIntervalId *id;		/* unused */
{
   TimeChartWidget w = (TimeChartWidget)client_data;
   time_t value;
   Display *dpy = XtDisplay(w);
   Window win = XtWindow(w);
   int x,y;

/*   if (w->time_chart.update > 0)
       w->time_chart.interval_id =
       XtAppAddTimeOut(XtWidgetToApplicationContext( (Widget) w),
		       w->time_chart.update, draw_string,client_data);
*/
   if (w->time_chart.interval >= (int)w->core.width)
       MoveChart( (TimeChartWidget) w, TRUE);

   /* Get the value, stash the point and draw corresponding line. */

   if (w->time_chart.get_value == NULL)
       return;

   XtCallCallbacks( (Widget)w, XtNgetValue, (XtPointer)&value );

   w->time_chart.valuedata[w->time_chart.interval] = timeStamp;
   if (XtIsRealized((Widget)w)) {
       if ( w->time_chart.next_x ) {
	   if ( w->time_chart.next_x + XTW(numstring) <= w->core.width-1 ) {
	       x = w->time_chart.next_x;
	       y = w->time_chart.font_height - 4;
	       XDS(numstring);				     /* draw max value */
	       w->time_chart.last_end = x + XTW(numstring);
	       w->time_chart.next_x = 0;
	       XFlush(dpy);					     /* Flush output buffers */
	   }
       }
       else {
	   strftime(numstring, sizeof numstring, "%T^", localtime(&timeStamp));
	   x = (w->time_chart.interval) - XTW(numstring) + 5;
	   if ( x > w->time_chart.last_end + 10 &&
	       x + XTW(numstring) <= w->core.width-1 ) {
	       y = w->time_chart.font_height - 4;
	       XDS(numstring);				     /* draw max value */
	       w->time_chart.last_end = x + XTW(numstring);
	       XFlush(dpy);					     /* Flush output buffers */
	   }
	   else if ( x > w->time_chart.last_end + 10 &&
		    x + XTW(numstring) >= w->core.width-1 )
	       w->time_chart.next_x = x;
	   else if ( w->time_chart.last_end == 0 ) {	     /* for first time through */
	       y = w->time_chart.font_height - 4;
	       XDS(numstring);				     /* draw max value */
	       w->time_chart.last_end = x + XTW(numstring);
	       XFlush(dpy);					     /* Flush output buffers */
	   }
       }
   }
   w->time_chart.interval++;		    /* Next point */
} /* draw_string */

/* Blts data according to current size, then redraws the TimeChart window.
 * Next represents the number of valid points in data.  Returns the (possibly)
 * adjusted value of next.  If next is 0, this routine draws an empty window
 * (scale - 1 lines for graph).  If next is less than the current window width,
 * the returned value is identical to the initial value of next and data is
 * unchanged.  Otherwise keeps half a window's worth of data.  If data is
 * changed, then w->time_chart.max_value is updated to reflect the
 * largest data point.
 */

static int repaint_window(w, left, width)
TimeChartWidget w;
int left, width;
{
    register int i, j;
    int oldInterval;
    register int next = w->time_chart.interval;
    int scale = w->time_chart.scale;
    int scalewidth = 0;
    int x, x1, x2, y, y1, y2;
    char numstring[32];
#if 0
    /* Compute the minimum scale required to graph the data, but don't go
       lower than min_scale. */
    if (w->time_chart.interval != 0 || scale <= (int)w->time_chart.max_value)
      scale = ((int) (w->time_chart.max_value)) + 1;
    if (scale < w->time_chart.min_scale)
      scale = w->time_chart.min_scale;
    if (scale != w->time_chart.scale) {
      w->time_chart.scale = scale;
      left = 0;
      width = next;
      scalewidth = w->core.width;

      SetPoints(w);

      if (XtIsRealized ((Widget) w)) 
	XClearWindow (XtDisplay (w), XtWindow (w));

    }
#endif
    if (XtIsRealized ((Widget) w)) 
	XClearWindow (XtDisplay (w), XtWindow (w));

    if ( left == 0 || left < LABEL_ROOM ) left = LABEL_ROOM;
    
    if (XtIsRealized((Widget)w)) {
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);
	
	width += left - 1;
	if (!scalewidth) scalewidth = width;
	
	if (next < ++width) width = next;
	
	w->time_chart.next_x = 0;
	w->time_chart.last_end = 0;
	w->time_chart.num_timestamps = 0;
	if ( left + 1 == width && width != next ) {
	    left = LABEL_ROOM;
	    oldInterval = w->time_chart.interval;
	    w->time_chart.interval = width;
	}
	else
	    oldInterval = 0;
	for (i = left; i < w->time_chart.interval; i++) {
	    if ( w->time_chart.next_x ) {
		if ( w->time_chart.next_x + XTW(numstring) <= w->core.width-1 ) {
		    x = w->time_chart.next_x;
		    y = w->time_chart.font_height - 4;
		    XDS(numstring);				     /* draw max value */
		    w->time_chart.last_end = x + XTW(numstring);
		    w->time_chart.next_x = 0;
		    XFlush(dpy);					     /* Flush output buffers */
		}
	    }
	    else {
		strftime(numstring, sizeof numstring, "%T^", localtime(&w->time_chart.valuedata[i]));
		x = i - XTW(numstring) + 5;
		if ( x > w->time_chart.last_end + 10 &&
		    x + XTW(numstring) <= w->core.width-1 ) {
		    y = w->time_chart.font_height - 4;
		    XDS(numstring);				     /* draw max value */
		    w->time_chart.last_end = x + XTW(numstring);
		    XFlush(dpy);					     /* Flush output buffers */
		}
		else if ( x > w->time_chart.last_end + 10 &&
			 x + XTW(numstring) >= w->core.width-1 )
		    w->time_chart.next_x = x;
		else if ( w->time_chart.last_end == 0 ) {	     /* for first time through */
		    y = w->time_chart.font_height - 4;
		    XDS(numstring);				     /* draw max value */
		    w->time_chart.last_end = x + XTW(numstring);
		    XFlush(dpy);					     /* Flush output buffers */
		}
	    }
	}
	if ( oldInterval ) 
	    w->time_chart.interval = oldInterval;
    }
    return(next);
}

/*	Function Name: MoveChart
 *	Description: moves the chart over when it would run off the end.
 *	Arguments: w - the load widget.
 *                 blit - blit the bits? (TRUE/FALSE).
 *	Returns: none.
 */

static void MoveChart(w, blit)
TimeChartWidget w;
Boolean blit;
{
    double old_max;
    int left, i, j;
    register int next = w->time_chart.interval;

    if (!XtIsRealized((Widget) w)) return;

    if (w->time_chart.jump_val == DEFAULT_JUMP)
        j = w->core.width >> 1; /* Half the window width. */
    else {
        j = w->core.width - w->time_chart.jump_val;
	if (j < 0) j = 0;
    }

    bcopy((char *)(w->time_chart.valuedata + next - j),
	  (char *)(w->time_chart.valuedata), j * sizeof(time_t));

    next = w->time_chart.interval = j;

    XCopyArea(XtDisplay((Widget)w), XtWindow((Widget)w), XtWindow((Widget)w),
	      w->time_chart.hiGC, 
	      (int) (w->core.width - j), 0,		     /* source x, y */
	      (unsigned int) j, (unsigned int) w->core.height, /* width, height */
	      0, 0);					     /* dest x, y */


    XClearArea(XtDisplay((Widget)w), XtWindow((Widget)w), 
	       (int) j, 0, 
	       (unsigned int) w->core.width - j, (unsigned int)w->core.height,
	       FALSE);

    w->time_chart.last_end--;
    if ( w->time_chart.next_x )
	w->time_chart.next_x--;

    for (j=0; w->time_chart.timestamp_end[j]!=0; j++) {
	if ( j > 31 ) break;
	w->time_chart.timestamp_end[j]--;
    }
    
    if (w->time_chart.timestamp_end[0] <= LABEL_ROOM ) {
	XClearArea(XtDisplay((Widget)w), XtWindow((Widget)w), 
		   0, 0, 
		   LABEL_ROOM, (unsigned int)w->core.height,
		   FALSE);
	for ( j=1; j < w->time_chart.num_timestamps; j++ ) {
	    w->time_chart.timestamp_end[j-1] = w->time_chart.timestamp_end[j];
	}
	w->time_chart.num_timestamps--;
    }
    
    return;
}

/* ARGSUSED */
static Boolean SetValues (current, request, new)
    Widget current, request, new;
{
    TimeChartWidget old = (TimeChartWidget)current;
    TimeChartWidget w = (TimeChartWidget)new;
    Boolean ret_val = FALSE;
    unsigned int new_gc = NO_GCS;

/*    if (w->time_chart.update != old->time_chart.update) {
	if (old->time_chart.update > 0)
	    XtRemoveTimeOut (old->time_chart.interval_id);
	if (w->time_chart.update > 0)
	    w->time_chart.interval_id =
		XtAppAddTimeOut(XtWidgetToApplicationContext(new),
				w->time_chart.update,
				draw_string, (XtPointer)w);
    }
*/
    if ( w->time_chart.min_scale > (int) ((w->time_chart.max_value) + 1) )
      ret_val = TRUE;
     
    if ( w->time_chart.fgpixel != old->time_chart.fgpixel ) {
      new_gc |= FOREGROUND;
      ret_val = True;
    }
    
    if ( w->time_chart.hipixel != old->time_chart.hipixel ) {
      new_gc |= HIGHLIGHT;
      ret_val = True;
    }
    
    DestroyGC(old, new_gc);
    CreateGC(w, new_gc);

    return( ret_val );
}

/*	Function Name: SetPoints
 *	Description: Sets up the polypoint that will be used to draw in
 *                   the graph lines.
 *	Arguments: w - the TimeChart widget.
 *	Returns: none.
 */

#define HEIGHT ( (unsigned int) w->core.height)

static void SetPoints(w)
TimeChartWidget w;
{
    XPoint * points;
    Cardinal size;
    int i;

    if (w->time_chart.scale <= 1) { /* no scale lines. */
	XtFree ((char *) w->time_chart.points);
	w->time_chart.points = NULL;
	return;
    }
    
    size = sizeof(XPoint) * (w->time_chart.scale - 1);

    points = (XPoint *) XtRealloc( (XtPointer) w->time_chart.points, size);
    w->time_chart.points = points;

    /* Draw graph reference lines into clip mask */

    for (i = 1; i < w->time_chart.scale; i++) {
	points[i - 1].x = 0;
	points[i - 1].y = HEIGHT / w->time_chart.scale;
    }
}
