/* $XConsortium: StripChart.c,v 1.20 91/05/24 17:20:42 converse Exp $ */

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

 * Copyright 1994, Roger Smith for Sterling Software and NASA-Ames Research Center
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of NASA and Sterling Software (collectively 
 * or individually) are not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  NASA and Sterling Software makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * NASA & STERLING SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL NASA & STERLING SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * 1994 Revision
 * Author:           Roger Smith, Sterling Software @ NASA-Ames Research Center
 *                   Moffett Field, California, rsmith@proteus.arc.nasa.gov

******************************************************************/

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/XawInit.h>
#include "StripCharP.h"
#ifdef X11R5
#include <X11/Xfuncs.h>
#endif
#define MS_PER_SEC 100

/* Private Data */

#define offset(field) XtOffsetOf(PerfChartRec, field)

static XtResource resources[] = {
    {XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
	offset(core.width), XtRImmediate, (XtPointer) 120},
    {XtNheight, XtCHeight, XtRDimension, sizeof(Dimension),
	offset(core.height), XtRImmediate, (XtPointer) 120},
    {XtNupdate, XtCInterval, XtRInt, sizeof(int),
        offset(strip_chart.update), XtRImmediate, (XtPointer) 10},
    {XtNminScale, XtCScale, XtRInt, sizeof(int),
        offset(strip_chart.min_scale), XtRImmediate, (XtPointer) 1},
    {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
        offset(strip_chart.fgpixel), XtRString, XtDefaultForeground},
    {XtNalarmColor, XtCAlarmColor, XtRPixel, sizeof(Pixel),
        offset(strip_chart.alarmColor), XtRString, "red"},
    {XtNokColor, XtCOkColor, XtRPixel, sizeof(Pixel),
        offset(strip_chart.okColor), XtRString, "pale green"},
    {XtNwarnColor, XtCWarnColor, XtRPixel, sizeof(Pixel),
        offset(strip_chart.warnColor), XtRString, "yellow"},
    {XtNlowAlarm, XtCLowAlarm, XtRInt, sizeof(int),
        offset(strip_chart.lowAlarm), XtRImmediate, (XtPointer)NULL},
    {XtNhighAlarm, XtCHighAlarm, XtRInt, sizeof(int),
        offset(strip_chart.highAlarm), XtRImmediate, (XtPointer)99999},
    {XtNlowWarn, XtCLowWarn, XtRInt, sizeof(int),
        offset(strip_chart.lowWarn), XtRImmediate, (XtPointer)NULL},
    {XtNhighWarn, XtCHighWarn, XtRInt, sizeof(int),
        offset(strip_chart.highWarn), XtRImmediate, (XtPointer)99999},

    { XtNimmediate, XtCImmediate, XtRBoolean, sizeof (Boolean),
	offset(strip_chart.immediate), XtRString, "True" },
    { XtNcurrent, XtCCurrent, XtRBoolean, sizeof (Boolean),
	offset(strip_chart.current), XtRString, "True" },
    {XtNhighlight, XtCForeground, XtRPixel, sizeof(Pixel),
        offset(strip_chart.hipixel), XtRString, XtDefaultForeground},
    { XtNfillRect, XtCFillRect, XtRBoolean, sizeof (Boolean),
	offset(strip_chart.fillRect), XtRString, "False" },
    {XtNtopLabel,  XtCTopLabel, XtRString, sizeof(String),
        offset(strip_chart.topLabel), XtRString, NULL},
    {XtNbotLabel,  XtCBotLabel, XtRString, sizeof(String),

        offset(strip_chart.botLabel), XtRString, NULL},

    { XtNfont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
        offset(strip_chart.font), XtRString, XtDefaultFont },
    {XtNgetValue, XtCCallback, XtRCallback, sizeof(XtPointer),
        offset(strip_chart.get_value), XtRImmediate, (XtPointer) NULL},
    {XtNjumpScroll, XtCJumpScroll, XtRInt, sizeof(int),
        offset(strip_chart.jump_val), XtRImmediate, (XtPointer) DEFAULT_JUMP},
};

#undef offset
#define LABEL_ROOM 100
static void Initialize(), Destroy(), Redisplay(), MoveChart(), SetPoints();
static Boolean SetValues();
static int repaint_window();
extern Bool mono_screen;

double value;

PerfChartClassRec perfChartClassRec = {
    { /* core fields */
    /* superclass		*/	(WidgetClass) &simpleClassRec,
    /* class_name		*/	"PerfChart",
    /* size			*/	sizeof(PerfChartRec),
    /* class_initialize		*/	XawInitializeWidgetSet,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	XtExposeCompressMultiple |
	                                XtExposeGraphicsExposeMerged,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	SetPoints,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	NULL,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
    },
    { /* Simple class fields */
    /* change_sensitive		*/	XtInheritChangeSensitive
    }
};

WidgetClass perfChartWidgetClass = (WidgetClass) &perfChartClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

void draw_graph();

/*	Function Name: CreateGC
 *	Description: Creates the GC's
 *	Arguments: w - the strip chart widget.
 *                 which - which GC's to create.
 *	Returns: none
 */

static void
CreateGC(w, which)
PerfChartWidget w;
unsigned int which;
{
  XGCValues	myXGCV;

  if (which & FOREGROUND) {
    myXGCV.foreground = w->strip_chart.fgpixel;
    myXGCV.font = w->strip_chart.font->fid;
    w->strip_chart.fgGC = XtGetGC((Widget) w, (GCForeground|GCFont), &myXGCV);
  }

  if (which & HIGHLIGHT) {
    myXGCV.foreground = w->strip_chart.hipixel;
    myXGCV.font = w->strip_chart.font->fid;
    w->strip_chart.hiGC = XtGetGC((Widget) w, (GCForeground|GCFont), &myXGCV);
  }
}

/*	Function Name: DestroyGC
 *	Description: Destroys the GC's
 *	Arguments: w - the strip chart widget.
 *                 which - which GC's to destroy.
 *	Returns: none
 */

static void
DestroyGC(w, which)
PerfChartWidget w;
unsigned int which;
{
  if (which & FOREGROUND) 
    XtReleaseGC((Widget) w, w->strip_chart.fgGC);

  if (which & HIGHLIGHT) 
    XtReleaseGC((Widget) w, w->strip_chart.hiGC);
}

/* ARGSUSED */
static void Initialize (greq, gnew)
    Widget greq, gnew;
{
    PerfChartWidget w = (PerfChartWidget)gnew;

/* if we are working with a mono screen then turn off all warnings and alarms */

    if ( mono_screen ) {
	w->strip_chart.highWarn = w->strip_chart.highAlarm = 99999;
	w->strip_chart.lowWarn = w->strip_chart.lowAlarm = 0;
	fprintf(stderr, "xperfmon++: INFO: Mono screen detected... all warning & alarm limits disabled.\n");
    }

/* check to make sure user didn't set both a high and a low limit */

    if ( (w->strip_chart.highWarn != 99999 || w->strip_chart.highAlarm != 99999) &&
	(w->strip_chart.lowWarn != 0 || w->strip_chart.lowAlarm != 0) ) {
	fprintf(stderr, "ERROR: Both a high and a low limit was set for the %s %s widget\n",
		w->strip_chart.topLabel, w->strip_chart.botLabel);
	fprintf(stderr, "       Use \"xperfmon++ -help\" for a list of available options\n");
	exit(0);
    }

/* make sure we have a default font */

    if (w->strip_chart.font == NULL)
	w->strip_chart.font = XQueryFont(XtDisplay(w),
	    XGContextFromGC(DefaultGCOfScreen(XtScreen(w))));

    CreateGC(w, (unsigned int) ALL_GCS);

/* set up some default values */

    w->strip_chart.font_height = w->strip_chart.font->max_bounds.ascent
	 + w->strip_chart.font->max_bounds.descent;

    w->strip_chart.scale = w->strip_chart.min_scale;
    w->strip_chart.currentBG = w->core.background_pixel;
    w->strip_chart.interval = LABEL_ROOM;
    w->strip_chart.max_value = w->strip_chart.hi_max = 0.0;
    w->strip_chart.min_value = w->strip_chart.lo_min = 99999.99;
    w->strip_chart.points = NULL;
    SetPoints(w);
}
 
static void Destroy (gw)
     Widget gw;
{
     PerfChartWidget w = (PerfChartWidget)gw;

     if (w->strip_chart.update > 0)
         XtRemoveTimeOut (w->strip_chart.interval_id);
     if (w->strip_chart.points)
	 XtFree((char *) w->strip_chart.points);
     DestroyGC(w, (unsigned int) ALL_GCS);
}

/*
 * NOTE: This function really needs to recieve graphics exposure 
 *       events, but since this is not easily supported until R4 I am
 *       going to hold off until then.
 */

/* ARGSUSED */
static void Redisplay(w, event, region)
     Widget w;
     XEvent *event;
     Region region;
{
/*    printf("Event Vector, type = %d\n", event->type);*/
    if (event->type == GraphicsExpose)
	(void) repaint_window ((PerfChartWidget)w, event->xgraphicsexpose.x,
			       event->xgraphicsexpose.width);
    else
	(void) repaint_window ((PerfChartWidget)w, event->xexpose.x,
			       event->xexpose.width);
}

#define XTW(s) XTextWidth(w->strip_chart.font, s, strlen(s))
#define XDS(s) XDrawString(XtDisplay(w), XtWindow(w), \
                         w->strip_chart.hiGC, x, y, s, strlen(s))

/* ARGSUSED */
void draw_graph(client_data, id)
XtPointer client_data;
XtIntervalId *id;		/* unused */
{
   PerfChartWidget w = (PerfChartWidget)client_data;
   XGCValues	myXGCV;
   double checkValue;
   Display *dpy = XtDisplay(w);
   Window win = XtWindow(w);
   char numstring[24];      /* GF */
   int x,y;                 /* GF */
   
/*   if (w->strip_chart.update > 0)
       w->strip_chart.interval_id =
       XtAppAddTimeOut(XtWidgetToApplicationContext( (Widget) w),
		       w->strip_chart.update,draw_graph,client_data);
*/
   if (w->strip_chart.interval >= (int)w->core.width)
       MoveChart( (PerfChartWidget) w, TRUE);

   /* Get the value, stash the point and draw corresponding line. */

   if (w->strip_chart.get_value == NULL)
       return;

   XtCallCallbacks( (Widget)w, XtNgetValue, (XtPointer)&value );

   w->strip_chart.lastValue = value;

   /* 
    * Keep w->strip_chart.max_value up to date, and if this data 
    * point is off the graph, change the scale to make it fit. 
    */
   
   if ( value > w->strip_chart.hi_max )
       w->strip_chart.hi_max = value;                      /* keep all time max value up to date */
   if (value > w->strip_chart.max_value) {
       w->strip_chart.max_value = value;
       if (w->strip_chart.max_value > w->strip_chart.scale) {
	   XClearWindow( dpy, win);
	   w->strip_chart.interval = repaint_window(w, 0, (int) w->core.width);
       }
   }
   if (value < w->strip_chart.min_value) 
       w->strip_chart.min_value = value;
   if ( value < w->strip_chart.lo_min )
       w->strip_chart.lo_min = value;			   /* keep all time min value up to date */

   /*
    * GF added feature: Show the current value as a number
    */

   if ( w->strip_chart.current ) {			   /* show current only if current is set to true */
       if (XtIsRealized((Widget)w)) {
	   (void) sprintf(numstring, "%d", (int)(value+0.5) );  /* round off */
	   /* erase first */
	   x = LABEL_ROOM - XTW("0000000");
	   y = ((w->strip_chart.font_height - 2) + (w->core.height - 1))/2;
	   XClearArea(XtDisplay(w), XtWindow(w), x, y-w->strip_chart.font_height, 
		      LABEL_ROOM-x-1, w->strip_chart.font_height+1,
		      FALSE);
	   /* draw current value */
	   x = LABEL_ROOM - XTW(numstring) - XTW("0");
	   XDS(numstring);
       }
   }

   w->strip_chart.valuedata[w->strip_chart.interval] = value;
   if (XtIsRealized((Widget)w)) {
       int y1 = (int) (w->core.height -
		       (int)(w->core.height * value) / w->strip_chart.scale);

/* Check for high warnings and alarms */
   
       if ( w->strip_chart.highWarn != 99999 ||
	   w->strip_chart.highAlarm != 99999 ) {

	   if ( w->strip_chart.immediate )
	       checkValue = value;
	   else
	       checkValue = w->strip_chart.max_value;

	   if ( checkValue >= w->strip_chart.highAlarm ) { /* check for high alarm */
	       if ( w->strip_chart.currentBG != w->strip_chart.alarmColor ) {
		   XtVaSetValues((Widget)w, XtNbackground, w->strip_chart.alarmColor, NULL );
		   w->strip_chart.currentBG = w->strip_chart.alarmColor;
	       }
	   }
	   else if ( checkValue >= w->strip_chart.highWarn ) { /* check for high warning */
	       if ( w->strip_chart.currentBG != w->strip_chart.warnColor ) {
		   XtVaSetValues((Widget)w, XtNbackground, w->strip_chart.warnColor, NULL );
		   w->strip_chart.currentBG = w->strip_chart.warnColor;
	       }
	   }
	   else {
	       if ( w->strip_chart.currentBG != w->strip_chart.okColor ) { /* reset to okColor? */
		   XtVaSetValues((Widget)w, XtNbackground, w->strip_chart.okColor, NULL );
		   w->strip_chart.currentBG = w->strip_chart.okColor;
	       }
	   }
       }
	   
/* Check for low warnings and alarms */
   
       else if ( w->strip_chart.lowWarn != 0 ||
	   w->strip_chart.lowAlarm != 0 ) {

	   if ( w->strip_chart.immediate )
	       checkValue = value;
	   else
	       checkValue = w->strip_chart.min_value;

	   if ( checkValue <= w->strip_chart.lowAlarm ) { /* check for low alarm */
	       if ( w->strip_chart.currentBG != w->strip_chart.alarmColor ) {
		   XtVaSetValues((Widget)w, XtNbackground, w->strip_chart.alarmColor, NULL );
		   w->strip_chart.currentBG = w->strip_chart.alarmColor;
	       }
	   }
	   else if ( checkValue <= w->strip_chart.lowWarn ) { /* check for low warning */
	       if ( w->strip_chart.currentBG != w->strip_chart.warnColor ) {
		   XtVaSetValues((Widget)w, XtNbackground, w->strip_chart.warnColor, NULL );
		   w->strip_chart.currentBG = w->strip_chart.warnColor;
	       }
	   }
	   else {
	       if ( w->strip_chart.currentBG != w->strip_chart.okColor ) { /* reset to okColor? */
		   XtVaSetValues((Widget)w, XtNbackground, w->strip_chart.okColor, NULL );
		   w->strip_chart.currentBG = w->strip_chart.okColor;
	       }
	   }
       }

       if ( !w->strip_chart.fillRect ) {			  /* draw line graph */
	   int y = (int) (w->core.height -
			  (int)(w->core.height * 
				w->strip_chart.valuedata[w->strip_chart.interval-1] ) / 
			  w->strip_chart.scale);
	   XDrawLine(dpy, win, w->strip_chart.fgGC,
		     w->strip_chart.interval-1, y, 
		     w->strip_chart.interval, y1);
       }
       else							  /* draw filled graph */
	   XFillRectangle(dpy, win, w->strip_chart.fgGC,
			  w->strip_chart.interval, y1, 
			  (unsigned int) 1, w->core.height - y1);

       /*
	* Fill in the graph lines we just painted over.
	

	if (w->strip_chart.points != NULL) {
	w->strip_chart.points[0].x = w->strip_chart.interval;
	   XDrawPoints(dpy, win, w->strip_chart.hiGC,
		       w->strip_chart.points, w->strip_chart.scale - 1,
		       CoordModePrevious);
       }*/

       XFlush(dpy);		    /* Flush output buffers */
   }
       w->strip_chart.interval++;		    /* Next point */
} /* draw_graph */

/* Blts data according to current size, then redraws the PerfChart window.
 * Next represents the number of valid points in data.  Returns the (possibly)
 * adjusted value of next.  If next is 0, this routine draws an empty window
 * (scale - 1 lines for graph).  If next is less than the current window width,
 * the returned value is identical to the initial value of next and data is
 * unchanged.  Otherwise keeps half a window's worth of data.  If data is
 * changed, then w->strip_chart.max_value is updated to reflect the
 * largest data point.
 */
#define XTW(s) XTextWidth(w->strip_chart.font, s, strlen(s))
#define XDS(s) XDrawString(XtDisplay(w), XtWindow(w), \
			   w->strip_chart.hiGC, x, y, s, strlen(s))

static int 
repaint_window(w, left, width)
PerfChartWidget w;
int left, width;
{
    register int i, j;
    register int next = w->strip_chart.interval;
    int scale = w->strip_chart.scale;
    int scalewidth = 0;
    int x, x1, x2, y, y1, y2;
    char numstring[24];

    /* Compute the minimum scale required to graph the data, but don't go
       lower than min_scale. */
    if (w->strip_chart.interval != 0 || scale <= (int)w->strip_chart.max_value){
      scale = ((int) (w->strip_chart.max_value));
      if (w->strip_chart.max_value!=(double)scale)
         scale++;
    }
    if (scale < w->strip_chart.min_scale)
      scale = w->strip_chart.min_scale;

    if (scale != w->strip_chart.scale) {
      w->strip_chart.scale = scale;
      left = 0;
      width = next;
      scalewidth = w->core.width;

      SetPoints(w);

      if (XtIsRealized ((Widget) w)) 
	XClearWindow (XtDisplay (w), XtWindow (w));

    }
    if ( left == 0 || left < LABEL_ROOM ) left = LABEL_ROOM;

    if (XtIsRealized((Widget)w)) {
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);

	width += left - 1;
	if (!scalewidth) scalewidth = width;

	if (next < ++width) width = next;

/* draw titles */

	if ( w->strip_chart.topLabel ) {
	    y = w->core.height/2;
	    x = 4;
	    XDS(w->strip_chart.topLabel);
	}
	if ( w->strip_chart.botLabel ) {
	    y = (w->core.height/2) + w->strip_chart.font_height;
	    x = 4;
	    XDS(w->strip_chart.botLabel);
	}

/* draw scale labels */

	(void) sprintf(numstring, "%d ", 0);
	x = LABEL_ROOM - XTW(numstring);
	y = w->core.height - 1;
	XDS(numstring);		/* draw min value */

	(void) sprintf(numstring, "%d ", (int)w->strip_chart.scale );
	x = LABEL_ROOM - XTW(numstring);
	y = w->strip_chart.font_height - 4;
	XDS(numstring);		/* draw max value */


	/* Draw data point lines. */
	/*XXX crash at next line with linux/alpha (redhat)  SC  4/98 */
	y = (int) (w->core.height -
		       (int)(w->core.height * w->strip_chart.valuedata[left]) /
		       w->strip_chart.scale);
	for (i = left; i < width; i++) {
	    if ( !w->strip_chart.fillRect ) {			  /* draw line graph */

		if ( i == left && left + 1 == width && width != next ) {
		    y1 = (int) (w->core.height -
				(int)(w->core.height * w->strip_chart.valuedata[i-1]) /
				w->strip_chart.scale);
		    XDrawLine(dpy, win, w->strip_chart.fgGC,
			      i-1, y1, i, y);
		}
		else if ( i == left )	{ /* If this is the leftmost point, then just plot it. */
		    
		    XDrawPoint(dpy, win, w->strip_chart.fgGC, i, y);
		} 
		else	{
		    /* If this is not the left most point, then draw a line
		     * connecting this point with the one to its left.
		     */
		    y1 = (int) (w->core.height -
				(int)(w->core.height * w->strip_chart.valuedata[i]) /
				w->strip_chart.scale);
		    XDrawLine(dpy, win, w->strip_chart.fgGC,
			      i-1, y, i, y1);
		    y = y1;
		}
	    }
	    else {						  /* draw filled graph */
		int y = (int) (w->core.height -
				(int)(w->core.height * w->strip_chart.valuedata[i]) /
				w->strip_chart.scale);
		XFillRectangle(dpy, win, w->strip_chart.fgGC, 
			       i,	                                  /* x */
			       y,					  /* y */
			       (unsigned int) 1,			  /* width */
			   (unsigned int) (w->core.height - y));  /* height */
	    }

	}

   /*
    * GF added feature: Show the current value as a number
    */

	if ( w->strip_chart.current ) {			   /* show current only if current is set to true */
	    if (XtIsRealized((Widget)w)) {
		(void) sprintf(numstring, "%d", (int)(w->strip_chart.lastValue+0.5) );  /* round off */
/* draw current value */
		y = ((w->strip_chart.font_height - 2) + (w->core.height - 1))/2;
		x = LABEL_ROOM - XTW(numstring) - XTW("0");
		XDS(numstring);
	    }
	}
    }
    return(next);
}

/*	Function Name: MoveChart
 *	Description: moves the chart over when it would run off the end.
 *	Arguments: w - the load widget.
 *                 blit - blit the bits? (TRUE/FALSE).
 *	Returns: none.
 */

static void
MoveChart(w, blit)
PerfChartWidget w;
Boolean blit;
{
    double old_max, old_min;
    int left, i, j;
    register int next = w->strip_chart.interval;

    if (!XtIsRealized((Widget) w)) return;

    if (w->strip_chart.jump_val == DEFAULT_JUMP)
        j = w->core.width >> 1; /* Half the window width. */
    else {
        j = w->core.width - w->strip_chart.jump_val;
	if (j < 0) j = 0;
    }

    bcopy((char *)(w->strip_chart.valuedata + next - j),
	  (char *)(w->strip_chart.valuedata), j * sizeof(double));
    next = w->strip_chart.interval = j;
	
    /*
     * Since we just lost some data, recompute the 
     * w->strip_chart.max_value, and min_value. 
     */

    old_max = w->strip_chart.max_value;
    w->strip_chart.max_value = 0.0;
    w->strip_chart.min_value = 99999.99;
    for (i = LABEL_ROOM; i < next; i++) {
      if (w->strip_chart.valuedata[i] > w->strip_chart.max_value) 
	w->strip_chart.max_value = w->strip_chart.valuedata[i];
      if ( w->strip_chart.valuedata[i] < w->strip_chart.min_value )
	  w->strip_chart.min_value = w->strip_chart.valuedata[i];
    }

    if (!blit) return;		/* we are done... */

    if ( ((int) old_max) != ( (int) w->strip_chart.max_value) ) {
      XClearWindow(XtDisplay(w), XtWindow(w));
      repaint_window(w, 0, (int) w->core.width);
      return;
    }

    XCopyArea(XtDisplay((Widget)w), XtWindow((Widget)w), XtWindow((Widget)w),
	      w->strip_chart.hiGC, (int) (w->core.width - j)+LABEL_ROOM, 0,
	      (unsigned int) j-LABEL_ROOM, (unsigned int) w->core.height,
	      LABEL_ROOM, 0);

    XClearArea(XtDisplay((Widget)w), XtWindow((Widget)w), 
	       (int) j, 0, 
	       (unsigned int) w->core.width - j, (unsigned int)w->core.height,
	       FALSE);

    /* Draw graph reference lines 
    left = j;
    for (i = 1; i < w->strip_chart.scale; i++) {
      j = i * ((int)w->core.height / w->strip_chart.scale);
      XDrawLine(XtDisplay((Widget) w), XtWindow( (Widget) w),
		w->strip_chart.hiGC, left + LABEL_ROOM, j, (int)w->core.width, j);
    }*/
    return;
}

/* ARGSUSED */
static Boolean SetValues (current, request, new)
    Widget current, request, new;
{
    PerfChartWidget old = (PerfChartWidget)current;
    PerfChartWidget w = (PerfChartWidget)new;
    Boolean ret_val = FALSE;
    unsigned int new_gc = NO_GCS;

    if ( w->strip_chart.min_scale > (int) ((w->strip_chart.max_value) + 1) )
      ret_val = TRUE;
     
    if ( w->strip_chart.fgpixel != old->strip_chart.fgpixel ) {
      new_gc |= FOREGROUND;
      ret_val = True;
    }
    
    if ( w->strip_chart.hipixel != old->strip_chart.hipixel ) {
      new_gc |= HIGHLIGHT;
      ret_val = True;
    }
    
    DestroyGC(old, new_gc);
    CreateGC(w, new_gc);

    return( ret_val );
}

/*	Function Name: SetPoints
 *	Description: Sets up the polypoint that will be used to draw in
 *                   the graph lines.
 *	Arguments: w - the PerfChart widget.
 *	Returns: none.
 */

#define HEIGHT ( (unsigned int) w->core.height)

static void
SetPoints(w)
PerfChartWidget w;
{
    XPoint * points;
    Cardinal size;
    int i;

    if (w->strip_chart.scale <= 1) { /* no scale lines. */
	XtFree ((char *) w->strip_chart.points);
	w->strip_chart.points = NULL;
	return;
    }
    
    size = sizeof(XPoint) * (w->strip_chart.scale - 1);

    points = (XPoint *) XtRealloc( (XtPointer) w->strip_chart.points, size);
    w->strip_chart.points = points;

    /* Draw graph reference lines into clip mask */

    for (i = 1; i < w->strip_chart.scale; i++) {
	points[i - 1].x = 0;
	points[i - 1].y = HEIGHT / w->strip_chart.scale;
    }
}
