/*
     kalc: A Scientific RPN Calculator
     Copyright (C) 1999-2000 Eduardo M Kalinowski (ekalin@iname.com)

     This program is free software. You may redistribute it, but only in
     its whole, unmodified form. You are allowed to make changes to this
     program, but you must not redistribute the changed version.

     This program is distributed in the hope it will be useful, but there
     is no warranty.

     For details, see the COPYING file.
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

/*
 * Replacement for non ANSI common functions, if they are not present
 */
#ifdef PROVIDE_OWN_STRCASECMP
#include <ctype.h>
int strcasecmp(char *str1, char *str2)
{
  while (tolower(*str1++) == tolower(*str2++))
    if (*str1 == '\0')
      return 0;

  return (tolower(*(str1 - 1)) - tolower(*(str2 - 1)));
}
#endif


#ifndef HAVE_STRDUP
char *strdup(char *str) 
{
  char *r = (char *) malloc(strlen(str) + 1);
  strcpy(r, str);
  return r;
}
#endif


#ifndef HAVE_GETCWD
#include <errno.h>
#define CURR_DIR "Sorry, getcwd() is not supported"
char *getcwd(char *buff, size_t size)
{
  if (size < strlen(CURR_DIR) + 1) {
    errno = ERANGE;
    return NULL;
  }

  strcpy(buff, CURR_DIR);
  return buff;
}
#undef CURR_DIR
#endif


#ifndef HAVE_GETOPT
#define WRITE(s) write(2, argv[0], strlen(argv[0]));    \
                       write(2, s, strlen(s));          \
                       write(2, errbuf, 2);

int optopt, opterr = 1, optind = 1;
char *optarg;

static int sp = 1;

int getopt(int argc, char * const argv[], const char *opts)
{
  /*
   * POSIX systems should have this function, but unfortunately not
   * everything is POSIX yet.
   */

  char *cp, errbuf[2];
  register char ch;

  if (sp == 1) {
    if (argc <= optind)
      return -1;
    if ((errbuf[0] = argv[optind][0]) == '\0')
      return -1;
    if (errbuf[0] != '-')
      return -1;
    if (argv[optind][1] == '\0')
      return -1;
    if (!strcmp(argv[optind], "--")) {
      optind++;
      return -1;
    }
  }
  ch = optopt = argv[optind][sp];
  if (ch == ':' || (cp = strchr(opts, ch)) == NULL) {
    if (!opterr) {
      errbuf[0] = ch;
      errbuf[1] = '\n';
      WRITE(": illegal option -- ");
    }
    sp++;
    if (argv[optind][sp] == '\0') {
      optind++;
      sp = 1;
    }
    return '?';
  }
  if (*(++cp) == ':') {
    if (argv[optind][sp + 1] != '\0') {
      optarg = argv[optind++] + sp + 1;
      sp = 1;
      return ch;
    }
    if (argc > ++optind) {
      optarg = argv[optind++];
      sp = 1;
      return ch;
    }
    if (opterr) {
      errbuf[0] = ch;
      errbuf[1] = '\n';
      WRITE(": option requires an argument -- ");
    }
    sp = 1;
    return '?';
  }
  if (argv[optind][++sp] == '\0') {
    sp = 1;
    optind++;
  }
  optarg = NULL;
  return ch;
}
#endif /* HAVE_GETOPT */


/*
 * Just the necessary functionality to replace the readline library.
 */
#ifndef HAVE_LIBREADLINE
#ifndef LINESIZE
#  define LINESIZE 256
#endif
#include <stdio.h>
char *readline(char *prompt)
{
  char *buffer = (char *) malloc(LINESIZE);
  if (!buffer)
    exit(1);

  printf("%s", prompt);
  fgets(buffer, LINESIZE, stdin);

  buffer[strlen(buffer) - 1] = '\0';

  return buffer;
}
#endif
