/////////(Copyright)//////(No modificar estas 11 primeras Lineas)/////////
//     Autor: Antonio Castro Snurmacher (E-mail <acastro@ctv.es> )
//
//  Este fuente puede ser utilizado, distribuido, y modificado libremente
//  pero siempre se deber respetar la propiedad intelectual de su autor.
//  El autor renuncia a todo tipo de beneficio econmico y no se hace
//  responsable de los posibles perjuicios derivados del uso del mismo.
//  Toda modificacin queda sujeta a las mismas condiciones de uso que el
//  original. En caso de traduccin deber conservarse el texto original
//  de esta cabecera y aadirse la traduccin a continuacin de ella.
//////////////////////////////////////////////////////////////////////////


//-----------------------------------------------------------------------
//       burbujas.pov  (1-Mayo-1998)
//-----------------------------------------------------------------------
//  Esta versin esta dedicada a su inclusin en la revista LinuxFocus
//-----------------------------------------------------------------------

// you can set the value of clock from 1 to 4
#declare Clock=4;
//#declare Clock=2;

#include "colors.inc"
#include "textures.inc"

// Por defecto max_trace_level vale 5 . Aumentado a 15 conseguimos 
// mayor nivel detalle en las imagenes recursivas generadas por reflejos 
global_settings {
#max_trace_level 15
}

// Declaramos distintos puntos de vista y solo elegiremos finalmente
// una en fucin del valor de Clock
#declare img1 =
camera {
  location <0, 10000 ,0 >
  look_at <0, 0, 0>
  angle 7
}

#declare img2 =
camera {
  location <0, 250 ,0 >
  look_at <0, 0, 0>
  angle 130
}

#declare img3 =
camera {
  location <12, 300 ,12 >
  look_at <200, 3, 50>
  angle 30
}

#declare img4 =
camera {
  location <12, 30 ,12 >
  look_at <200, 3, 50>
  angle 120
}

  #switch (Clock)
    #case (1)
      // This section is parsed if Clock=1
       camera {img1}
    #break  
    #case (2)
      // This section is parsed if Clock=2
       camera {img2}
    #break  
    #case (3)
      // This section is parsed if Clock=4
       camera {img3}
    #break 
    #case (4)
      // This section is parsed if Clock=5
       camera {img4}
    #break 
    #else
      #warning "Clock outside expected range\n"
  #end // End of conditional part

// Fuente de luz blanca
object {
  light_source {
  <100, 1000, 100>
  color White
  }
}

#declare textureBall = texture { Gold_Metal }

// El fichero include 'burbujas.inc' es un fichero obtenido mediante
// la salida de un programa escrito en lenguaje C.

#include "burbujas.inc"

