/*********************************************
* vim: set sw=8 ts=8 si :
* Author: Guido Socher, Copyright: GPL 
* This program is to test the led connected to
* PC5. 
* See http://linuxfocus.org/English/November2004/
* for details.
* Chip type           : ATMEGA8
* Clock frequency     : Internal clock 1 Mhz (factory default)
*********************************************/
#include <avr/io.h>
#include <inttypes.h>

//#define OLD 1

#ifdef OLD
/* compatibilty macros for old style */
#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif

#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif

#endif /*OLD*/

void delay_ms(unsigned short ms)
/* delay for a minimum of <ms> */
/* with a 1Mhz clock, the resolution is 1 ms */
{
	uint8_t inner,inner1;

    	while (ms) {
		inner = 100;
		while (inner) {
			inner--;
			inner1 = 70;
			while (inner1) {
				inner1--;
			}
		}
		ms--;
	}
}

#ifdef OLD
// old style now depricated:
void main(void)
{
	// enable  PC5 as output 
	sbi(DDRC,PC5);
	while (1) {
		// led on, pin=0 
		cbi(PORTC,PC5);
		delay_ms(500);
		// set output to 5V, LED off 
		sbi(PORTC,PC5);
		delay_ms(500);
	}
}

#else

/* new style */
void main(void)
{
          /* INITIALIZE */
          /* enable PC5 as output */
          DDRC|= _BV(PC5);


          /* BLINK, BLINK ... */

          /* PC5 is 5 (see file include/avr/iom8.h) and _BV(PC5) is 00100000 */
          while (1) {
                      /* led on, pin=0 */
                      PORTC &= ~_BV(PC5);
                      delay_ms(500);
                      /* set output to 5V, LED off */
                      PORTC|= _BV(PC5);
                      delay_ms(500);
          }
}

#endif /*OLD*/
