//
// Author: 
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
// 

using GConf;
using Glade;
using Gtk;
using System;

namespace Imendio.Blam {
    public class Preference {
	public static string REVERSE_ENTRIES   = "behaviour/reverse_entries";
	public static string AUTO_REFRESH      = "behaviour/auto_refresh";
	public static string AUTO_REFRESH_RATE = "behaviour/auto_refresh_rate";
        public static string FONT_PATH         = "/desktop/gnome/interface";
        public static string VARIABLE_FONT     = "/desktop/gnome/interface/font_name";
        public static string FIXED_FONT        = "/desktop/gnome/interface/monospace_font_name";
    }

    public class PreferencesDialog {
	[Widget] Gtk.Dialog      preferencesDialog;
	[Widget] Gtk.Label       boldBehaviourLabel;
	[Widget] Gtk.CheckButton reverseEntriesCheckButton;
	[Widget] Gtk.CheckButton autoRefreshCheckButton;
	[Widget] Gtk.SpinButton  refreshRateSpinButton;
	[Widget] Gtk.Button      closeButton;

	public PreferencesDialog (Gtk.Window parentWindow)
	{
	    Glade.XML gladeXML = Glade.XML.FromAssembly ("blam.glade",
							 "preferencesDialog",
							 null);
	    gladeXML.Autoconnect (this);
	    preferencesDialog.TransientFor = parentWindow;
	    preferencesDialog.Icon = Gdk.Pixbuf.LoadFromResource ("blam.png");

	    boldBehaviourLabel.Markup = "<b>" + boldBehaviourLabel.Text + "</b>";
	    
	    bool reverseEntries = Conf.Get (Preference.REVERSE_ENTRIES, false);
	    reverseEntriesCheckButton.Active = reverseEntries;

	    bool autoRefresh = Conf.Get (Preference.AUTO_REFRESH, false);
	    autoRefreshCheckButton.Active = autoRefresh;

	    int refreshRate = Conf.Get (Preference.AUTO_REFRESH_RATE, 15);
	    refreshRateSpinButton.Value = refreshRate;

	    Conf.AddNotify (new NotifyEventHandler (ConfNotifyHandler));
	}

	public void Show ()
	{
	    preferencesDialog.ShowAll ();
	}

	private void CloseButtonClicked (object obj, EventArgs args)
	{
	    preferencesDialog.Hide();
	}
	
	private void ReverseItemsCheckButtonToggled (object obj, EventArgs args)
	{
	    Conf.Set (Preference.REVERSE_ENTRIES,
		      reverseEntriesCheckButton.Active);
	}

	private void AutoRefreshCheckButtonToggled (object obj, EventArgs args)
	{
	    Conf.Set (Preference.AUTO_REFRESH, autoRefreshCheckButton.Active);
	}

	private void RefreshRateSpinButtonChanged (object obj, EventArgs args)
	{
	    Conf.Set (Preference.AUTO_REFRESH_RATE,
		      (int) refreshRateSpinButton.Value);
	}

	private void ConfNotifyHandler (object sender, NotifyEventArgs args)
	{
	    if (args.Key == Conf.GetFullKey (Preference.REVERSE_ENTRIES)) {
		reverseEntriesCheckButton.Active = (bool) args.Value;
	    } 
	    else if (args.Key == Conf.GetFullKey (Preference.AUTO_REFRESH)) {
		autoRefreshCheckButton.Active = (bool) args.Value;
	    } 
	    else if (args.Key == Conf.GetFullKey (Preference.AUTO_REFRESH_RATE)) {
		refreshRateSpinButton.Value = (int) args.Value;
	    }
	}
    }
}

