//
// Author: 
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
// 

using Gtk;
using System;

namespace Imendio.Blam {
    public class TrayIcon : Egg.TrayIcon {
	private string       mName;
	private Gtk.EventBox mEventBox;
	private Gtk.Image    mImage;
	private Gtk.Tooltips mTooltips;

	public new event ButtonPressEventHandler ButtonPressEvent;

	public Gtk.Image Image {
	    get {
		return mImage;
	    }
	}

	public string Tooltip {
	    set {
		mTooltips.SetTip (mEventBox, value, value);
	    }
	}

	public TrayIcon (string name) : base (name)
	{
	    mName = name;

	    Init ();
	}
	
	private void Init ()
	{
	    DestroyEvent += HandleDestroyEvent;

	    mEventBox = new Gtk.EventBox ();
	    mEventBox.Add (mImage = new Image ());

	    mEventBox.ButtonPressEvent += ButtonPressedCb;

	    mTooltips = new Gtk.Tooltips ();

	    this.Add (mEventBox);	
	}

	public new void Show ()
	{
	    ShowAll ();
	}

	private void ButtonPressedCb (object o, ButtonPressEventArgs args)
	{
	    if (this.ButtonPressEvent != null) {
		this.ButtonPressEvent (o, args);
	    }
	}

	private void HandleDestroyEvent (object o, DestroyEventArgs args)
	{
	    Init ();
	}
    }
}
