/* ease-background-widget.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-background-widget.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define EASE_TYPE_BACKGROUND_WIDGET (ease_background_widget_get_type ())
#define EASE_BACKGROUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidget))
#define EASE_BACKGROUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetClass))
#define EASE_IS_BACKGROUND_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND_WIDGET))
#define EASE_IS_BACKGROUND_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND_WIDGET))
#define EASE_BACKGROUND_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetClass))

typedef struct _EaseBackgroundWidget EaseBackgroundWidget;
typedef struct _EaseBackgroundWidgetClass EaseBackgroundWidgetClass;
typedef struct _EaseBackgroundWidgetPrivate EaseBackgroundWidgetPrivate;

#define EASE_TYPE_BACKGROUND (ease_background_get_type ())
#define EASE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND, EaseBackground))
#define EASE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND, EaseBackgroundClass))
#define EASE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND))
#define EASE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND))
#define EASE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND, EaseBackgroundClass))

typedef struct _EaseBackground EaseBackground;
typedef struct _EaseBackgroundClass EaseBackgroundClass;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define EASE_TYPE_BACKGROUND_TYPE (ease_background_type_get_type ())

#define EASE_TYPE_GRADIENT_TYPE (ease_gradient_type_get_type ())

#define EASE_TYPE_GRADIENT (ease_gradient_get_type ())
#define EASE_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_GRADIENT, EaseGradient))
#define EASE_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_GRADIENT, EaseGradientClass))
#define EASE_IS_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_GRADIENT))
#define EASE_IS_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_GRADIENT))
#define EASE_GRADIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_GRADIENT, EaseGradientClass))

typedef struct _EaseGradient EaseGradient;
typedef struct _EaseGradientClass EaseGradientClass;

#define EASE_TYPE_IMAGE_FILL_TYPE (ease_image_fill_type_get_type ())

#define EASE_TYPE_IMAGE (ease_image_get_type ())
#define EASE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE, EaseImage))
#define EASE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE, EaseImageClass))
#define EASE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE))
#define EASE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE))
#define EASE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE, EaseImageClass))

typedef struct _EaseImage EaseImage;
typedef struct _EaseImageClass EaseImageClass;

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_UNDO_ACTION (ease_undo_action_get_type ())
#define EASE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoAction))
#define EASE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))
#define EASE_IS_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ACTION))
#define EASE_IS_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ACTION))
#define EASE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))

typedef struct _EaseUndoAction EaseUndoAction;
typedef struct _EaseUndoActionClass EaseUndoActionClass;

#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_COLOR (ease_color_get_type ())
#define EASE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_COLOR, EaseColor))
#define EASE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_COLOR, EaseColorClass))
#define EASE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_COLOR))
#define EASE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_COLOR))
#define EASE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_COLOR, EaseColorClass))

typedef struct _EaseColor EaseColor;
typedef struct _EaseColorClass EaseColorClass;
typedef struct _Block4Data Block4Data;

struct _EaseBackgroundWidget {
	GtkAlignment parent_instance;
	EaseBackgroundWidgetPrivate * priv;
};

struct _EaseBackgroundWidgetClass {
	GtkAlignmentClass parent_class;
};

struct _EaseBackgroundWidgetPrivate {
	GtkComboBox* background_type;
	GtkListStore* store;
	GtkComboBox* gradient_type;
	GtkVBox* box_color;
	GtkVBox* box_gradient;
	GtkVBox* box_image;
	GtkComboBox* image_fill;
	GtkHScale* grad_angle;
	GtkColorButton* bg_color;
	GtkColorButton* grad_color1;
	GtkColorButton* grad_color2;
	GtkFileChooserButton* bg_image;
	EaseBackground* background;
	gboolean silence_undo;
	EaseDocument* document;
	EaseSlide* slide;
	EaseElement* element;
};

typedef enum  {
	EASE_BACKGROUND_TYPE_COLOR,
	EASE_BACKGROUND_TYPE_GRADIENT,
	EASE_BACKGROUND_TYPE_IMAGE
} EaseBackgroundType;

typedef enum  {
	EASE_GRADIENT_TYPE_LINEAR,
	EASE_GRADIENT_TYPE_LINEAR_MIRRORED,
	EASE_GRADIENT_TYPE_RADIAL
} EaseGradientType;

typedef enum  {
	EASE_IMAGE_FILL_TYPE_STRETCH,
	EASE_IMAGE_FILL_TYPE_ASPECT,
	EASE_IMAGE_FILL_TYPE_ORIGINAL
} EaseImageFillType;

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

typedef void (*EaseDialogFileChooserDialogExtension) (GtkFileChooserDialog* d, void* user_data);
struct _Block4Data {
	int _ref_count_;
	EaseBackgroundWidget * self;
	GtkColorButton* sender;
	EaseColor* color;
};


static gpointer ease_background_widget_parent_class = NULL;

GType ease_background_widget_get_type (void) G_GNUC_CONST;
GType ease_background_get_type (void) G_GNUC_CONST;
GType ease_document_get_type (void) G_GNUC_CONST;
GType ease_slide_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
#define EASE_BACKGROUND_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_BACKGROUND_WIDGET, EaseBackgroundWidgetPrivate))
enum  {
	EASE_BACKGROUND_WIDGET_DUMMY_PROPERTY,
	EASE_BACKGROUND_WIDGET_USE_ALPHA
};
#define EASE_BACKGROUND_WIDGET_UI_FILE_PATH "background.ui"
#define EASE_BACKGROUND_WIDGET_BG_DIALOG_TITLE _ ("Select Background Image")
EaseBackgroundWidget* ease_background_widget_new (EaseBackground* bg, EaseElement* e);
EaseBackgroundWidget* ease_background_widget_construct (GType object_type, EaseBackground* bg, EaseElement* e);
EaseSlide* ease_element_get_parent (EaseElement* self);
EaseDocument* ease_slide_get_parent (EaseSlide* self);
static void ease_background_widget_init (EaseBackgroundWidget* self);
void ease_background_widget_set_use_alpha (EaseBackgroundWidget* self, gboolean value);
EaseBackgroundWidget* ease_background_widget_new_for_slide (EaseSlide* s);
EaseBackgroundWidget* ease_background_widget_construct_for_slide (GType object_type, EaseSlide* s);
EaseBackground* ease_slide_get_background (EaseSlide* self);
char* ease_data_path (const char* path);
#define EASE_TEMP_UI_DIR "ui"
GType ease_background_type_get_type (void) G_GNUC_CONST;
static void ease_background_widget_display_bg_ui (EaseBackgroundWidget* self, EaseBackgroundType type);
EaseBackgroundType ease_background_get_background_type (EaseBackground* self);
GtkListStore* ease_gradient_type_list_store (void);
GtkListStore* ease_image_fill_type_list_store (void);
char* ease_background_type_description (EaseBackgroundType self);
GType ease_gradient_type_get_type (void) G_GNUC_CONST;
GType ease_gradient_get_type (void) G_GNUC_CONST;
EaseGradient* ease_background_get_gradient (EaseBackground* self);
EaseGradientType ease_gradient_get_mode (EaseGradient* self);
GType ease_image_fill_type_get_type (void) G_GNUC_CONST;
GType ease_image_get_type (void) G_GNUC_CONST;
EaseImage* ease_background_get_image (EaseBackground* self);
EaseImageFillType ease_image_get_fill (EaseImage* self);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
GType ease_undo_action_get_type (void) G_GNUC_CONST;
static void ease_background_widget_emit_undo (EaseBackgroundWidget* self, EaseUndoAction* action);
GType ease_undo_source_get_type (void) G_GNUC_CONST;
void ease_background_widget_on_background_changed (GtkWidget* sender, EaseBackgroundWidget* self);
EaseUndoAction* ease_undo_action_new (GObject* obj, const char* prop);
EaseUndoAction* ease_undo_action_construct (GType object_type, GObject* obj, const char* prop);
const char* ease_image_get_filename (EaseImage* self);
char* ease_dialog_open_ext (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target);
GtkWindow* ease_widget_window (GtkWidget* widg);
static void _lambda28_ (GtkFileChooserDialog* dialog, EaseBackgroundWidget* self);
static void __lambda28__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self);
void ease_image_set_source (EaseImage* self, const char* value);
char* ease_document_add_media_file (EaseDocument* self, const char* file, GError** error);
void ease_image_set_filename (EaseImage* self, const char* value);
EaseUndoItem* ease_undo_item_apply (EaseUndoItem* self);
static void _lambda29_ (EaseUndoAction* a, EaseBackgroundWidget* self);
static void __lambda29__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
void ease_undo_action_add (EaseUndoAction* self, GObject* obj, const char* prop);
void ease_background_set_background_type (EaseBackground* self, EaseBackgroundType value);
void ease_background_widget_on_gradient_type_changed (GtkComboBox* sender, EaseBackgroundWidget* self);
static void _lambda30_ (EaseUndoAction* a, EaseBackgroundWidget* self);
static void __lambda30__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
void ease_gradient_set_mode (EaseGradient* self, EaseGradientType value);
void ease_background_widget_on_image_fill_changed (GtkComboBox* sender, EaseBackgroundWidget* self);
static void _lambda31_ (EaseUndoAction* a, EaseBackgroundWidget* self);
static void __lambda31__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
void ease_image_set_fill (EaseImage* self, EaseImageFillType value);
void ease_background_widget_on_color_set (GtkColorButton* sender, EaseBackgroundWidget* self);
GType ease_color_get_type (void) G_GNUC_CONST;
static EaseUndoAction* ease_background_widget_set_color (EaseBackgroundWidget* self, GtkColorButton* sender, EaseColor* color);
EaseColor* ease_background_get_color (EaseBackground* self);
EaseColor* ease_gradient_get_start (EaseGradient* self);
EaseColor* ease_gradient_get_end (EaseGradient* self);
void ease_background_widget_on_file_set (GtkFileChooserButton* sender, EaseBackgroundWidget* self);
static void _lambda33_ (EaseUndoAction* a, EaseBackgroundWidget* self);
const char* ease_image_get_source (EaseImage* self);
static void __lambda33__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
void ease_background_widget_on_reverse_gradient (GtkWidget* sender, EaseBackgroundWidget* self);
void ease_gradient_flip (EaseGradient* self);
void ease_color_get_gdk (EaseColor* self, GdkColor* result);
static void _lambda34_ (EaseBackgroundWidget* self);
static void __lambda34__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
void ease_background_widget_on_set_angle (GtkWidget* sender, EaseBackgroundWidget* self);
void ease_gradient_set_angle (EaseGradient* self, double value);
static void _lambda35_ (EaseUndoAction* a, EaseBackgroundWidget* self);
static void __lambda35__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
EaseColor* ease_color_get_white (void);
void ease_background_set_color (EaseBackground* self, EaseColor* value);
EaseColor* ease_color_get_black (void);
EaseGradient* ease_gradient_new (EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_construct (GType object_type, EaseColor* start_color, EaseColor* end_color);
void ease_background_set_gradient (EaseBackground* self, EaseGradient* value);
double ease_gradient_get_angle (EaseGradient* self);
EaseUndoAction* ease_color_undo_action (EaseColor* self);
void ease_color_set_gdk (EaseColor* self, GdkColor* value);
gboolean ease_background_widget_get_use_alpha (EaseBackgroundWidget* self);
void ease_color_set_alpha16 (EaseColor* self, guint16 value);
static void _lambda32_ (Block4Data* _data4_);
guint16 ease_color_get_alpha16 (EaseColor* self);
static void __lambda32__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void ease_background_widget_finalize (GObject* obj);
static void ease_background_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_background_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

extern const EaseBackgroundType EASE_BACKGROUND_TYPE_TYPES[3];


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 67 "ease-background-widget.vala"
EaseBackgroundWidget* ease_background_widget_construct (GType object_type, EaseBackground* bg, EaseElement* e) {
#line 328 "ease-background-widget.c"
	EaseBackgroundWidget * self;
	EaseBackground* _tmp0_;
	EaseDocument* _tmp1_;
	EaseElement* _tmp2_;
#line 67 "ease-background-widget.vala"
	g_return_val_if_fail (bg != NULL, NULL);
#line 67 "ease-background-widget.vala"
	g_return_val_if_fail (e != NULL, NULL);
#line 337 "ease-background-widget.c"
	self = g_object_newv (object_type, 0, NULL);
#line 69 "ease-background-widget.vala"
	self->priv->background = (_tmp0_ = _g_object_ref0 (bg), _g_object_unref0 (self->priv->background), _tmp0_);
#line 70 "ease-background-widget.vala"
	self->priv->document = (_tmp1_ = _g_object_ref0 (ease_slide_get_parent (ease_element_get_parent (e))), _g_object_unref0 (self->priv->document), _tmp1_);
#line 71 "ease-background-widget.vala"
	self->priv->element = (_tmp2_ = _g_object_ref0 (e), _g_object_unref0 (self->priv->element), _tmp2_);
#line 72 "ease-background-widget.vala"
	ease_background_widget_init (self);
#line 74 "ease-background-widget.vala"
	ease_background_widget_set_use_alpha (self, TRUE);
#line 349 "ease-background-widget.c"
	return self;
}


#line 67 "ease-background-widget.vala"
EaseBackgroundWidget* ease_background_widget_new (EaseBackground* bg, EaseElement* e) {
#line 67 "ease-background-widget.vala"
	return ease_background_widget_construct (EASE_TYPE_BACKGROUND_WIDGET, bg, e);
#line 358 "ease-background-widget.c"
}


#line 77 "ease-background-widget.vala"
EaseBackgroundWidget* ease_background_widget_construct_for_slide (GType object_type, EaseSlide* s) {
#line 364 "ease-background-widget.c"
	EaseBackgroundWidget * self;
	EaseDocument* _tmp0_;
	EaseBackground* _tmp1_;
	EaseSlide* _tmp2_;
#line 77 "ease-background-widget.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 371 "ease-background-widget.c"
	self = g_object_newv (object_type, 0, NULL);
#line 79 "ease-background-widget.vala"
	self->priv->document = (_tmp0_ = _g_object_ref0 (ease_slide_get_parent (s)), _g_object_unref0 (self->priv->document), _tmp0_);
#line 80 "ease-background-widget.vala"
	self->priv->background = (_tmp1_ = _g_object_ref0 (ease_slide_get_background (s)), _g_object_unref0 (self->priv->background), _tmp1_);
#line 81 "ease-background-widget.vala"
	self->priv->slide = (_tmp2_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->slide), _tmp2_);
#line 82 "ease-background-widget.vala"
	ease_background_widget_init (self);
#line 84 "ease-background-widget.vala"
	ease_background_widget_set_use_alpha (self, FALSE);
#line 383 "ease-background-widget.c"
	return self;
}


#line 77 "ease-background-widget.vala"
EaseBackgroundWidget* ease_background_widget_new_for_slide (EaseSlide* s) {
#line 77 "ease-background-widget.vala"
	return ease_background_widget_construct_for_slide (EASE_TYPE_BACKGROUND_WIDGET, s);
#line 392 "ease-background-widget.c"
}


#line 87 "ease-background-widget.vala"
static void ease_background_widget_init (EaseBackgroundWidget* self) {
#line 398 "ease-background-widget.c"
	GtkBuilder* builder;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GtkVBox* _tmp4_;
	GObject* _tmp5_;
	GtkVBox* _tmp6_;
	GObject* _tmp7_;
	GtkVBox* _tmp8_;
	GObject* _tmp9_;
	GtkColorButton* _tmp10_;
	GObject* _tmp11_;
	GtkColorButton* _tmp12_;
	GObject* _tmp13_;
	GtkColorButton* _tmp14_;
	GObject* _tmp15_;
	GtkFileChooserButton* _tmp16_;
	GObject* _tmp17_;
	GtkComboBox* _tmp18_;
	GObject* _tmp19_;
	GtkHScale* _tmp20_;
	GObject* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkListStore* _tmp23_;
	GtkListStore* _tmp24_;
	GObject* _tmp25_;
	GtkComboBox* _tmp26_;
	GtkListStore* _tmp27_;
	GtkTreeIter iter = {0};
	GtkCellRendererText* render;
	GtkTreeIter itr = {0};
	EaseBackgroundType type = 0;
	EaseGradientType grad_type = 0;
	EaseImageFillType img_type = 0;
	GtkFileFilter* filter;
	GtkFileFilter* _tmp32_;
	GError * _inner_error_ = NULL;
#line 87 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 90 "ease-background-widget.vala"
	builder = gtk_builder_new ();
#line 439 "ease-background-widget.c"
	{
		char* _tmp0_;
		char* _tmp1_;
#line 93 "ease-background-widget.vala"
		gtk_builder_add_from_file (builder, _tmp1_ = ease_data_path (_tmp0_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_BACKGROUND_WIDGET_UI_FILE_PATH, NULL)), &_inner_error_);
#line 445 "ease-background-widget.c"
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 96 "ease-background-widget.vala"
			g_error ("ease-background-widget.vala:96: Error loading UI: %s", e->message);
#line 461 "ease-background-widget.c"
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 99 "ease-background-widget.vala"
	gtk_container_add ((GtkContainer*) self, (_tmp2_ = gtk_builder_get_object (builder, "root"), GTK_IS_WIDGET (_tmp2_) ? ((GtkWidget*) _tmp2_) : NULL));
#line 100 "ease-background-widget.vala"
	gtk_alignment_set ((GtkAlignment*) self, (float) 0, (float) 0, (float) 1, (float) 0);
#line 103 "ease-background-widget.vala"
	self->priv->box_color = (_tmp4_ = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (builder, "vbox-color"), GTK_IS_VBOX (_tmp3_) ? ((GtkVBox*) _tmp3_) : NULL)), _g_object_unref0 (self->priv->box_color), _tmp4_);
#line 104 "ease-background-widget.vala"
	self->priv->box_gradient = (_tmp6_ = _g_object_ref0 ((_tmp5_ = gtk_builder_get_object (builder, "vbox-gradient"), GTK_IS_VBOX (_tmp5_) ? ((GtkVBox*) _tmp5_) : NULL)), _g_object_unref0 (self->priv->box_gradient), _tmp6_);
#line 105 "ease-background-widget.vala"
	self->priv->box_image = (_tmp8_ = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (builder, "vbox-image"), GTK_IS_VBOX (_tmp7_) ? ((GtkVBox*) _tmp7_) : NULL)), _g_object_unref0 (self->priv->box_image), _tmp8_);
#line 106 "ease-background-widget.vala"
	self->priv->bg_color = (_tmp10_ = _g_object_ref0 ((_tmp9_ = gtk_builder_get_object (builder, "color-color"), GTK_IS_COLOR_BUTTON (_tmp9_) ? ((GtkColorButton*) _tmp9_) : NULL)), _g_object_unref0 (self->priv->bg_color), _tmp10_);
#line 107 "ease-background-widget.vala"
	self->priv->grad_color1 = (_tmp12_ = _g_object_ref0 ((_tmp11_ = gtk_builder_get_object (builder, "color-startgradient"), GTK_IS_COLOR_BUTTON (_tmp11_) ? ((GtkColorButton*) _tmp11_) : NULL)), _g_object_unref0 (self->priv->grad_color1), _tmp12_);
#line 109 "ease-background-widget.vala"
	self->priv->grad_color2 = (_tmp14_ = _g_object_ref0 ((_tmp13_ = gtk_builder_get_object (builder, "color-endgradient"), GTK_IS_COLOR_BUTTON (_tmp13_) ? ((GtkColorButton*) _tmp13_) : NULL)), _g_object_unref0 (self->priv->grad_color2), _tmp14_);
#line 111 "ease-background-widget.vala"
	self->priv->bg_image = (_tmp16_ = _g_object_ref0 ((_tmp15_ = gtk_builder_get_object (builder, "button-image"), GTK_IS_FILE_CHOOSER_BUTTON (_tmp15_) ? ((GtkFileChooserButton*) _tmp15_) : NULL)), _g_object_unref0 (self->priv->bg_image), _tmp16_);
#line 113 "ease-background-widget.vala"
	self->priv->gradient_type = (_tmp18_ = _g_object_ref0 ((_tmp17_ = gtk_builder_get_object (builder, "combo-gradient"), GTK_IS_COMBO_BOX (_tmp17_) ? ((GtkComboBox*) _tmp17_) : NULL)), _g_object_unref0 (self->priv->gradient_type), _tmp18_);
#line 115 "ease-background-widget.vala"
	self->priv->grad_angle = (_tmp20_ = _g_object_ref0 ((_tmp19_ = gtk_builder_get_object (builder, "hscale-angle"), GTK_IS_HSCALE (_tmp19_) ? ((GtkHScale*) _tmp19_) : NULL)), _g_object_unref0 (self->priv->grad_angle), _tmp20_);
#line 116 "ease-background-widget.vala"
	self->priv->image_fill = (_tmp22_ = _g_object_ref0 ((_tmp21_ = gtk_builder_get_object (builder, "image-fill"), GTK_IS_COMBO_BOX (_tmp21_) ? ((GtkComboBox*) _tmp21_) : NULL)), _g_object_unref0 (self->priv->image_fill), _tmp22_);
#line 119 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 122 "ease-background-widget.vala"
	gtk_combo_box_set_model (self->priv->gradient_type, (GtkTreeModel*) (_tmp23_ = ease_gradient_type_list_store ()));
#line 500 "ease-background-widget.c"
	_g_object_unref0 (_tmp23_);
#line 125 "ease-background-widget.vala"
	gtk_combo_box_set_model (self->priv->image_fill, (GtkTreeModel*) (_tmp24_ = ease_image_fill_type_list_store ()));
#line 504 "ease-background-widget.c"
	_g_object_unref0 (_tmp24_);
#line 128 "ease-background-widget.vala"
	self->priv->background_type = (_tmp26_ = _g_object_ref0 ((_tmp25_ = gtk_builder_get_object (builder, "combobox-style"), GTK_IS_COMBO_BOX (_tmp25_) ? ((GtkComboBox*) _tmp25_) : NULL)), _g_object_unref0 (self->priv->background_type), _tmp26_);
#line 131 "ease-background-widget.vala"
	self->priv->store = (_tmp27_ = gtk_list_store_new (2, G_TYPE_STRING, EASE_TYPE_BACKGROUND_TYPE), _g_object_unref0 (self->priv->store), _tmp27_);
#line 510 "ease-background-widget.c"
	{
		EaseBackgroundType* b_collection;
		int b_collection_length1;
		int b_it;
#line 133 "ease-background-widget.vala"
		b_collection = EASE_BACKGROUND_TYPE_TYPES;
#line 517 "ease-background-widget.c"
		b_collection_length1 = G_N_ELEMENTS (EASE_BACKGROUND_TYPE_TYPES);
		for (b_it = 0; b_it < G_N_ELEMENTS (EASE_BACKGROUND_TYPE_TYPES); b_it = b_it + 1) {
			EaseBackgroundType b;
			b = b_collection[b_it];
			{
				char* _tmp28_;
#line 135 "ease-background-widget.vala"
				gtk_list_store_append (self->priv->store, &iter);
#line 136 "ease-background-widget.vala"
				gtk_list_store_set (self->priv->store, &iter, 0, _tmp28_ = ease_background_type_description (b), 1, b, -1);
#line 528 "ease-background-widget.c"
				_g_free0 (_tmp28_);
			}
		}
	}
#line 139 "ease-background-widget.vala"
	render = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
#line 141 "ease-background-widget.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->background_type, (GtkCellRenderer*) render, TRUE);
#line 142 "ease-background-widget.vala"
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->background_type, (GtkCellRenderer*) render, "text", 0, NULL);
#line 143 "ease-background-widget.vala"
	gtk_combo_box_set_model (self->priv->background_type, (GtkTreeModel*) self->priv->store);
#line 148 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->store, &itr);
#line 543 "ease-background-widget.c"
	{
		gboolean _tmp29_;
#line 149 "ease-background-widget.vala"
		_tmp29_ = TRUE;
#line 149 "ease-background-widget.vala"
		while (TRUE) {
#line 149 "ease-background-widget.vala"
			if (!_tmp29_) {
#line 157 "ease-background-widget.vala"
				if (!gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->store, &itr)) {
#line 157 "ease-background-widget.vala"
					break;
#line 556 "ease-background-widget.c"
				}
			}
#line 149 "ease-background-widget.vala"
			_tmp29_ = FALSE;
#line 151 "ease-background-widget.vala"
			gtk_tree_model_get ((GtkTreeModel*) self->priv->store, &itr, 1, &type, -1);
#line 152 "ease-background-widget.vala"
			if (type == ease_background_get_background_type (self->priv->background)) {
#line 154 "ease-background-widget.vala"
				gtk_combo_box_set_active_iter (self->priv->background_type, &itr);
#line 155 "ease-background-widget.vala"
				break;
#line 569 "ease-background-widget.c"
			}
		}
	}
#line 161 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->priv->gradient_type), &itr);
#line 575 "ease-background-widget.c"
	{
		gboolean _tmp30_;
#line 162 "ease-background-widget.vala"
		_tmp30_ = TRUE;
#line 162 "ease-background-widget.vala"
		while (TRUE) {
#line 162 "ease-background-widget.vala"
			if (!_tmp30_) {
#line 170 "ease-background-widget.vala"
				if (!gtk_tree_model_iter_next (gtk_combo_box_get_model (self->priv->gradient_type), &itr)) {
#line 170 "ease-background-widget.vala"
					break;
#line 588 "ease-background-widget.c"
				}
			}
#line 162 "ease-background-widget.vala"
			_tmp30_ = FALSE;
#line 164 "ease-background-widget.vala"
			gtk_tree_model_get (gtk_combo_box_get_model (self->priv->gradient_type), &itr, 1, &grad_type, -1);
#line 165 "ease-background-widget.vala"
			if (grad_type == ease_gradient_get_mode (ease_background_get_gradient (self->priv->background))) {
#line 167 "ease-background-widget.vala"
				gtk_combo_box_set_active_iter (self->priv->gradient_type, &itr);
#line 168 "ease-background-widget.vala"
				break;
#line 601 "ease-background-widget.c"
			}
		}
	}
#line 174 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->priv->image_fill), &itr);
#line 607 "ease-background-widget.c"
	{
		gboolean _tmp31_;
#line 175 "ease-background-widget.vala"
		_tmp31_ = TRUE;
#line 175 "ease-background-widget.vala"
		while (TRUE) {
#line 175 "ease-background-widget.vala"
			if (!_tmp31_) {
#line 183 "ease-background-widget.vala"
				if (!gtk_tree_model_iter_next (gtk_combo_box_get_model (self->priv->image_fill), &itr)) {
#line 183 "ease-background-widget.vala"
					break;
#line 620 "ease-background-widget.c"
				}
			}
#line 175 "ease-background-widget.vala"
			_tmp31_ = FALSE;
#line 177 "ease-background-widget.vala"
			gtk_tree_model_get (gtk_combo_box_get_model (self->priv->image_fill), &itr, 1, &img_type, -1);
#line 178 "ease-background-widget.vala"
			if (img_type == ease_image_get_fill (ease_background_get_image (self->priv->background))) {
#line 180 "ease-background-widget.vala"
				gtk_combo_box_set_active_iter (self->priv->image_fill, &itr);
#line 181 "ease-background-widget.vala"
				break;
#line 633 "ease-background-widget.c"
			}
		}
	}
#line 186 "ease-background-widget.vala"
	filter = g_object_ref_sink (gtk_file_filter_new ());
#line 187 "ease-background-widget.vala"
	gtk_file_filter_add_pixbuf_formats (filter);
#line 188 "ease-background-widget.vala"
	gtk_file_filter_set_name (filter, _ ("Images"));
#line 189 "ease-background-widget.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) self->priv->bg_image, filter);
#line 192 "ease-background-widget.vala"
	filter = (_tmp32_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (filter), _tmp32_);
#line 193 "ease-background-widget.vala"
	gtk_file_filter_set_name (filter, _ ("All Files"));
#line 194 "ease-background-widget.vala"
	gtk_file_filter_add_pattern (filter, "*");
#line 195 "ease-background-widget.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) self->priv->bg_image, filter);
#line 198 "ease-background-widget.vala"
	gtk_builder_connect_signals (builder, self);
#line 655 "ease-background-widget.c"
	_g_object_unref0 (filter);
	_g_object_unref0 (render);
	_g_object_unref0 (builder);
}


#line 201 "ease-background-widget.vala"
static void ease_background_widget_emit_undo (EaseBackgroundWidget* self, EaseUndoAction* action) {
#line 201 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 201 "ease-background-widget.vala"
	g_return_if_fail (action != NULL);
#line 203 "ease-background-widget.vala"
	if (!self->priv->silence_undo) {
#line 205 "ease-background-widget.vala"
		if (self->priv->slide != NULL) {
#line 205 "ease-background-widget.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self->priv->slide, "undo", (EaseUndoItem*) action);
#line 674 "ease-background-widget.c"
		} else {
#line 206 "ease-background-widget.vala"
			g_signal_emit_by_name ((EaseUndoSource*) self->priv->element, "undo", (EaseUndoItem*) action);
#line 678 "ease-background-widget.c"
		}
	}
}


#line 234 "ease-background-widget.vala"
static void _lambda28_ (GtkFileChooserDialog* dialog, EaseBackgroundWidget* self) {
#line 686 "ease-background-widget.c"
	GtkFileFilter* filter;
	GtkFileFilter* _tmp0_;
#line 234 "ease-background-widget.vala"
	g_return_if_fail (dialog != NULL);
#line 236 "ease-background-widget.vala"
	filter = g_object_ref_sink (gtk_file_filter_new ());
#line 237 "ease-background-widget.vala"
	gtk_file_filter_add_pixbuf_formats (filter);
#line 238 "ease-background-widget.vala"
	gtk_file_filter_set_name (filter, _ ("Images"));
#line 239 "ease-background-widget.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 242 "ease-background-widget.vala"
	filter = (_tmp0_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (filter), _tmp0_);
#line 243 "ease-background-widget.vala"
	gtk_file_filter_set_name (filter, _ ("All Files"));
#line 244 "ease-background-widget.vala"
	gtk_file_filter_add_pattern (filter, "*");
#line 245 "ease-background-widget.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 707 "ease-background-widget.c"
	_g_object_unref0 (filter);
}


#line 234 "ease-background-widget.vala"
static void __lambda28__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self) {
#line 714 "ease-background-widget.c"
	_lambda28_ (d, self);
}


#line 269 "ease-background-widget.vala"
static void _lambda29_ (EaseUndoAction* a, EaseBackgroundWidget* self) {
#line 269 "ease-background-widget.vala"
	g_return_if_fail (a != NULL);
#line 270 "ease-background-widget.vala"
	self->priv->silence_undo = TRUE;
#line 271 "ease-background-widget.vala"
	gtk_combo_box_set_active (self->priv->background_type, (gint) ease_background_get_background_type (self->priv->background));
#line 272 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 273 "ease-background-widget.vala"
	self->priv->silence_undo = FALSE;
#line 731 "ease-background-widget.c"
}


#line 269 "ease-background-widget.vala"
static void __lambda29__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 737 "ease-background-widget.c"
	_lambda29_ (sender, self);
}


#line 211 "ease-background-widget.vala"
void ease_background_widget_on_background_changed (GtkWidget* sender, EaseBackgroundWidget* self) {
#line 744 "ease-background-widget.c"
	GtkTreeIter itr = {0};
	EaseBackgroundType type = 0;
	EaseUndoAction* action;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 211 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 214 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->store, &itr);
#line 754 "ease-background-widget.c"
	{
		gint i;
#line 217 "ease-background-widget.vala"
		i = 0;
#line 759 "ease-background-widget.c"
		{
			gboolean _tmp0_;
#line 217 "ease-background-widget.vala"
			_tmp0_ = TRUE;
#line 217 "ease-background-widget.vala"
			while (TRUE) {
#line 217 "ease-background-widget.vala"
				if (!_tmp0_) {
#line 217 "ease-background-widget.vala"
					i++;
#line 770 "ease-background-widget.c"
				}
#line 217 "ease-background-widget.vala"
				_tmp0_ = FALSE;
#line 217 "ease-background-widget.vala"
				if (!(i < gtk_combo_box_get_active (self->priv->background_type))) {
#line 217 "ease-background-widget.vala"
					break;
#line 778 "ease-background-widget.c"
				}
#line 219 "ease-background-widget.vala"
				gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->store, &itr);
#line 782 "ease-background-widget.c"
			}
		}
	}
#line 224 "ease-background-widget.vala"
	gtk_tree_model_get ((GtkTreeModel*) self->priv->store, &itr, 1, &type, -1);
#line 227 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) self->priv->background, "background-type");
#line 230 "ease-background-widget.vala"
	if (type == EASE_BACKGROUND_TYPE_IMAGE) {
#line 230 "ease-background-widget.vala"
		_tmp1_ = ease_image_get_filename (ease_background_get_image (self->priv->background)) == NULL;
#line 794 "ease-background-widget.c"
	} else {
#line 230 "ease-background-widget.vala"
		_tmp1_ = FALSE;
#line 798 "ease-background-widget.c"
	}
#line 230 "ease-background-widget.vala"
	if (_tmp1_) {
#line 802 "ease-background-widget.c"
		GtkWindow* _tmp2_;
		char* _tmp3_;
		char* filename;
#line 232 "ease-background-widget.vala"
		filename = (_tmp3_ = ease_dialog_open_ext (EASE_BACKGROUND_WIDGET_BG_DIALOG_TITLE, _tmp2_ = ease_widget_window ((GtkWidget*) self), __lambda28__ease_dialog_file_chooser_dialog_extension, self), _g_object_unref0 (_tmp2_), _tmp3_);
#line 248 "ease-background-widget.vala"
		if (filename != NULL) {
#line 810 "ease-background-widget.c"
			{
				char* image;
#line 252 "ease-background-widget.vala"
				ease_image_set_source (ease_background_get_image (self->priv->background), filename);
#line 253 "ease-background-widget.vala"
				image = ease_document_add_media_file (self->priv->document, filename, &_inner_error_);
#line 817 "ease-background-widget.c"
				if (_inner_error_ != NULL) {
					goto __catch4_g_error;
				}
#line 254 "ease-background-widget.vala"
				ease_image_set_filename (ease_background_get_image (self->priv->background), image);
#line 823 "ease-background-widget.c"
				_g_free0 (image);
			}
			goto __finally4;
			__catch4_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
#line 258 "ease-background-widget.vala"
					g_critical ("ease-background-widget.vala:258: Error adding background image: %s", e->message);
#line 835 "ease-background-widget.c"
					_g_error_free0 (e);
				}
			}
			__finally4:
			if (_inner_error_ != NULL) {
				_g_free0 (filename);
				_g_object_unref0 (action);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			EaseUndoItem* _tmp4_;
#line 264 "ease-background-widget.vala"
			_tmp4_ = ease_undo_item_apply ((EaseUndoItem*) action);
#line 851 "ease-background-widget.c"
			_g_object_unref0 (_tmp4_);
			_g_free0 (filename);
			_g_object_unref0 (action);
#line 265 "ease-background-widget.vala"
			return;
#line 857 "ease-background-widget.c"
		}
		_g_free0 (filename);
	}
#line 269 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda29__ease_undo_item_applied, self, 0);
#line 277 "ease-background-widget.vala"
	switch (type) {
#line 865 "ease-background-widget.c"
		case EASE_BACKGROUND_TYPE_COLOR:
		{
#line 280 "ease-background-widget.vala"
			ease_undo_action_add (action, (GObject*) self->priv->background, "color");
#line 281 "ease-background-widget.vala"
			break;
#line 872 "ease-background-widget.c"
		}
		case EASE_BACKGROUND_TYPE_GRADIENT:
		{
#line 283 "ease-background-widget.vala"
			ease_undo_action_add (action, (GObject*) self->priv->background, "gradient");
#line 284 "ease-background-widget.vala"
			break;
#line 880 "ease-background-widget.c"
		}
		case EASE_BACKGROUND_TYPE_IMAGE:
		{
#line 286 "ease-background-widget.vala"
			ease_undo_action_add (action, (GObject*) self->priv->background, "image");
#line 287 "ease-background-widget.vala"
			break;
#line 888 "ease-background-widget.c"
		}
	}
#line 290 "ease-background-widget.vala"
	ease_background_set_background_type (self->priv->background, type);
#line 292 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 295 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, type);
#line 897 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 303 "ease-background-widget.vala"
static void _lambda30_ (EaseUndoAction* a, EaseBackgroundWidget* self) {
#line 303 "ease-background-widget.vala"
	g_return_if_fail (a != NULL);
#line 304 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 908 "ease-background-widget.c"
}


#line 303 "ease-background-widget.vala"
static void __lambda30__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 914 "ease-background-widget.c"
	_lambda30_ (sender, self);
}


#line 299 "ease-background-widget.vala"
void ease_background_widget_on_gradient_type_changed (GtkComboBox* sender, EaseBackgroundWidget* self) {
#line 921 "ease-background-widget.c"
	EaseUndoAction* action;
	EaseGradientType type = 0;
	GtkTreeIter itr = {0};
#line 299 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 301 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) ease_background_get_gradient (self->priv->background), "mode");
#line 303 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda30__ease_undo_item_applied, self, 0);
#line 309 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first (gtk_combo_box_get_model (sender), &itr);
#line 933 "ease-background-widget.c"
	{
		gint i;
#line 310 "ease-background-widget.vala"
		i = 0;
#line 938 "ease-background-widget.c"
		{
			gboolean _tmp0_;
#line 310 "ease-background-widget.vala"
			_tmp0_ = TRUE;
#line 310 "ease-background-widget.vala"
			while (TRUE) {
#line 310 "ease-background-widget.vala"
				if (!_tmp0_) {
#line 310 "ease-background-widget.vala"
					i++;
#line 949 "ease-background-widget.c"
				}
#line 310 "ease-background-widget.vala"
				_tmp0_ = FALSE;
#line 310 "ease-background-widget.vala"
				if (!(i < gtk_combo_box_get_active (sender))) {
#line 310 "ease-background-widget.vala"
					break;
#line 957 "ease-background-widget.c"
				}
#line 312 "ease-background-widget.vala"
				gtk_tree_model_iter_next (gtk_combo_box_get_model (sender), &itr);
#line 961 "ease-background-widget.c"
			}
		}
	}
#line 314 "ease-background-widget.vala"
	gtk_tree_model_get (gtk_combo_box_get_model (sender), &itr, 1, &type, -1);
#line 315 "ease-background-widget.vala"
	ease_gradient_set_mode (ease_background_get_gradient (self->priv->background), type);
#line 316 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 971 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 324 "ease-background-widget.vala"
static void _lambda31_ (EaseUndoAction* a, EaseBackgroundWidget* self) {
#line 324 "ease-background-widget.vala"
	g_return_if_fail (a != NULL);
#line 325 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 982 "ease-background-widget.c"
}


#line 324 "ease-background-widget.vala"
static void __lambda31__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 988 "ease-background-widget.c"
	_lambda31_ (sender, self);
}


#line 320 "ease-background-widget.vala"
void ease_background_widget_on_image_fill_changed (GtkComboBox* sender, EaseBackgroundWidget* self) {
#line 995 "ease-background-widget.c"
	EaseUndoAction* action;
	EaseImageFillType type = 0;
	GtkTreeIter itr = {0};
#line 320 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 322 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) ease_background_get_image (self->priv->background), "fill");
#line 324 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda31__ease_undo_item_applied, self, 0);
#line 330 "ease-background-widget.vala"
	gtk_tree_model_get_iter_first (gtk_combo_box_get_model (sender), &itr);
#line 1007 "ease-background-widget.c"
	{
		gint i;
#line 331 "ease-background-widget.vala"
		i = 0;
#line 1012 "ease-background-widget.c"
		{
			gboolean _tmp0_;
#line 331 "ease-background-widget.vala"
			_tmp0_ = TRUE;
#line 331 "ease-background-widget.vala"
			while (TRUE) {
#line 331 "ease-background-widget.vala"
				if (!_tmp0_) {
#line 331 "ease-background-widget.vala"
					i++;
#line 1023 "ease-background-widget.c"
				}
#line 331 "ease-background-widget.vala"
				_tmp0_ = FALSE;
#line 331 "ease-background-widget.vala"
				if (!(i < gtk_combo_box_get_active (sender))) {
#line 331 "ease-background-widget.vala"
					break;
#line 1031 "ease-background-widget.c"
				}
#line 333 "ease-background-widget.vala"
				gtk_tree_model_iter_next (gtk_combo_box_get_model (sender), &itr);
#line 1035 "ease-background-widget.c"
			}
		}
	}
#line 335 "ease-background-widget.vala"
	gtk_tree_model_get (gtk_combo_box_get_model (sender), &itr, 1, &type, -1);
#line 336 "ease-background-widget.vala"
	ease_image_set_fill (ease_background_get_image (self->priv->background), type);
#line 337 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 1045 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 341 "ease-background-widget.vala"
void ease_background_widget_on_color_set (GtkColorButton* sender, EaseBackgroundWidget* self) {
#line 1052 "ease-background-widget.c"
	EaseUndoAction* action;
#line 341 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 343 "ease-background-widget.vala"
	action = NULL;
#line 344 "ease-background-widget.vala"
	if (sender == self->priv->bg_color) {
#line 1060 "ease-background-widget.c"
		EaseUndoAction* _tmp0_;
#line 346 "ease-background-widget.vala"
		action = (_tmp0_ = ease_background_widget_set_color (self, self->priv->bg_color, ease_background_get_color (self->priv->background)), _g_object_unref0 (action), _tmp0_);
#line 1064 "ease-background-widget.c"
	} else {
#line 348 "ease-background-widget.vala"
		if (sender == self->priv->grad_color1) {
#line 1068 "ease-background-widget.c"
			EaseUndoAction* _tmp1_;
#line 350 "ease-background-widget.vala"
			action = (_tmp1_ = ease_background_widget_set_color (self, self->priv->grad_color1, ease_gradient_get_start (ease_background_get_gradient (self->priv->background))), _g_object_unref0 (action), _tmp1_);
#line 1072 "ease-background-widget.c"
		} else {
#line 352 "ease-background-widget.vala"
			if (sender == self->priv->grad_color2) {
#line 1076 "ease-background-widget.c"
				EaseUndoAction* _tmp2_;
#line 354 "ease-background-widget.vala"
				action = (_tmp2_ = ease_background_widget_set_color (self, self->priv->grad_color2, ease_gradient_get_end (ease_background_get_gradient (self->priv->background))), _g_object_unref0 (action), _tmp2_);
#line 1080 "ease-background-widget.c"
			}
		}
	}
#line 356 "ease-background-widget.vala"
	if (action != NULL) {
#line 356 "ease-background-widget.vala"
		ease_background_widget_emit_undo (self, action);
#line 1088 "ease-background-widget.c"
	}
	_g_object_unref0 (action);
}


#line 368 "ease-background-widget.vala"
static void _lambda33_ (EaseUndoAction* a, EaseBackgroundWidget* self) {
#line 368 "ease-background-widget.vala"
	g_return_if_fail (a != NULL);
#line 370 "ease-background-widget.vala"
	if (ease_image_get_source (ease_background_get_image (self->priv->background)) != NULL) {
#line 372 "ease-background-widget.vala"
		gtk_file_chooser_set_filename ((GtkFileChooser*) self->priv->bg_image, ease_image_get_source (ease_background_get_image (self->priv->background)));
#line 1102 "ease-background-widget.c"
	} else {
#line 376 "ease-background-widget.vala"
		gtk_file_chooser_unselect_all ((GtkFileChooser*) self->priv->bg_image);
#line 1106 "ease-background-widget.c"
	}
#line 379 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 1110 "ease-background-widget.c"
}


#line 368 "ease-background-widget.vala"
static void __lambda33__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 1116 "ease-background-widget.c"
	_lambda33_ (sender, self);
}


#line 360 "ease-background-widget.vala"
void ease_background_widget_on_file_set (GtkFileChooserButton* sender, EaseBackgroundWidget* self) {
#line 1123 "ease-background-widget.c"
	EaseUndoAction* action;
	GError * _inner_error_ = NULL;
#line 360 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 362 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) ease_background_get_image (self->priv->background), "filename");
#line 363 "ease-background-widget.vala"
	ease_undo_action_add (action, (GObject*) ease_background_get_image (self->priv->background), "source");
#line 368 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda33__ease_undo_item_applied, self, 0);
#line 1134 "ease-background-widget.c"
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		char* i;
#line 384 "ease-background-widget.vala"
		ease_image_set_source (ease_background_get_image (self->priv->background), _tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) sender));
#line 1142 "ease-background-widget.c"
		_g_free0 (_tmp0_);
#line 385 "ease-background-widget.vala"
		i = (_tmp2_ = ease_document_add_media_file (self->priv->document, _tmp1_ = gtk_file_chooser_get_filename ((GtkFileChooser*) sender), &_inner_error_), _g_free0 (_tmp1_), _tmp2_);
#line 1146 "ease-background-widget.c"
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
#line 386 "ease-background-widget.vala"
		ease_image_set_filename (ease_background_get_image (self->priv->background), i);
#line 1152 "ease-background-widget.c"
		_g_free0 (i);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 390 "ease-background-widget.vala"
			g_critical ("ease-background-widget.vala:390: Error adding background image: %s", e->message);
#line 1164 "ease-background-widget.c"
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 393 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 1177 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 411 "ease-background-widget.vala"
static void _lambda34_ (EaseBackgroundWidget* self) {
#line 1184 "ease-background-widget.c"
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_;
	GdkColor _tmp2_ = {0};
	GdkColor _tmp3_;
#line 412 "ease-background-widget.vala"
	gtk_color_button_set_color (self->priv->grad_color1, (_tmp1_ = (ease_color_get_gdk (ease_gradient_get_start (ease_background_get_gradient (self->priv->background)), &_tmp0_), _tmp0_), &_tmp1_));
#line 413 "ease-background-widget.vala"
	gtk_color_button_set_color (self->priv->grad_color2, (_tmp3_ = (ease_color_get_gdk (ease_gradient_get_end (ease_background_get_gradient (self->priv->background)), &_tmp2_), _tmp2_), &_tmp3_));
#line 1193 "ease-background-widget.c"
}


#line 411 "ease-background-widget.vala"
static void __lambda34__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 1199 "ease-background-widget.c"
	_lambda34_ (self);
}


#line 397 "ease-background-widget.vala"
void ease_background_widget_on_reverse_gradient (GtkWidget* sender, EaseBackgroundWidget* self) {
#line 1206 "ease-background-widget.c"
	EaseUndoAction* action;
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_;
	GdkColor _tmp2_ = {0};
	GdkColor _tmp3_;
#line 397 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 400 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) ease_background_get_gradient (self->priv->background), "start");
#line 401 "ease-background-widget.vala"
	ease_undo_action_add (action, (GObject*) ease_background_get_gradient (self->priv->background), "end");
#line 404 "ease-background-widget.vala"
	ease_gradient_flip (ease_background_get_gradient (self->priv->background));
#line 407 "ease-background-widget.vala"
	gtk_color_button_set_color (self->priv->grad_color1, (_tmp1_ = (ease_color_get_gdk (ease_gradient_get_start (ease_background_get_gradient (self->priv->background)), &_tmp0_), _tmp0_), &_tmp1_));
#line 408 "ease-background-widget.vala"
	gtk_color_button_set_color (self->priv->grad_color2, (_tmp3_ = (ease_color_get_gdk (ease_gradient_get_end (ease_background_get_gradient (self->priv->background)), &_tmp2_), _tmp2_), &_tmp3_));
#line 411 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda34__ease_undo_item_applied, self, 0);
#line 417 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 1228 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 428 "ease-background-widget.vala"
static void _lambda35_ (EaseUndoAction* a, EaseBackgroundWidget* self) {
#line 428 "ease-background-widget.vala"
	g_return_if_fail (a != NULL);
#line 429 "ease-background-widget.vala"
	ease_background_widget_display_bg_ui (self, ease_background_get_background_type (self->priv->background));
#line 1239 "ease-background-widget.c"
}


#line 428 "ease-background-widget.vala"
static void __lambda35__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 1245 "ease-background-widget.c"
	_lambda35_ (sender, self);
}


#line 421 "ease-background-widget.vala"
void ease_background_widget_on_set_angle (GtkWidget* sender, EaseBackgroundWidget* self) {
#line 1252 "ease-background-widget.c"
	EaseUndoAction* action;
	GtkWidget* _tmp0_;
#line 421 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 423 "ease-background-widget.vala"
	action = ease_undo_action_new ((GObject*) ease_background_get_gradient (self->priv->background), "angle");
#line 424 "ease-background-widget.vala"
	ease_gradient_set_angle (ease_background_get_gradient (self->priv->background), gtk_adjustment_get_value (gtk_range_get_adjustment ((GtkRange*) (_tmp0_ = sender, GTK_IS_HSCALE (_tmp0_) ? ((GtkHScale*) _tmp0_) : NULL))));
#line 426 "ease-background-widget.vala"
	ease_background_widget_emit_undo (self, action);
#line 428 "ease-background-widget.vala"
	g_signal_connect_object ((EaseUndoItem*) action, "applied", (GCallback) __lambda35__ease_undo_item_applied, self, 0);
#line 1265 "ease-background-widget.c"
	_g_object_unref0 (action);
}


#line 433 "ease-background-widget.vala"
static void ease_background_widget_display_bg_ui (EaseBackgroundWidget* self, EaseBackgroundType type) {
#line 433 "ease-background-widget.vala"
	g_return_if_fail (self != NULL);
#line 435 "ease-background-widget.vala"
	switch (type) {
#line 1276 "ease-background-widget.c"
		case EASE_BACKGROUND_TYPE_COLOR:
		{
			GdkColor _tmp1_ = {0};
			GdkColor _tmp2_;
#line 438 "ease-background-widget.vala"
			gtk_widget_show_all ((GtkWidget*) self->priv->box_color);
#line 439 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_gradient);
#line 440 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_image);
#line 442 "ease-background-widget.vala"
			if (ease_background_get_color (self->priv->background) == NULL) {
#line 1289 "ease-background-widget.c"
				EaseColor* _tmp0_;
#line 444 "ease-background-widget.vala"
				ease_background_set_color (self->priv->background, _tmp0_ = ease_color_get_white ());
#line 1293 "ease-background-widget.c"
				_g_object_unref0 (_tmp0_);
			}
#line 446 "ease-background-widget.vala"
			ease_background_set_background_type (self->priv->background, EASE_BACKGROUND_TYPE_COLOR);
#line 448 "ease-background-widget.vala"
			gtk_color_button_set_color (self->priv->bg_color, (_tmp2_ = (ease_color_get_gdk (ease_background_get_color (self->priv->background), &_tmp1_), _tmp1_), &_tmp2_));
#line 450 "ease-background-widget.vala"
			break;
#line 1302 "ease-background-widget.c"
		}
		case EASE_BACKGROUND_TYPE_GRADIENT:
		{
			GdkColor _tmp6_ = {0};
			GdkColor _tmp7_;
			GdkColor _tmp8_ = {0};
			GdkColor _tmp9_;
#line 453 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_color);
#line 454 "ease-background-widget.vala"
			gtk_widget_show_all ((GtkWidget*) self->priv->box_gradient);
#line 455 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_image);
#line 457 "ease-background-widget.vala"
			if (ease_background_get_gradient (self->priv->background) == NULL) {
#line 1318 "ease-background-widget.c"
				EaseColor* _tmp3_;
				EaseColor* _tmp4_;
				EaseGradient* _tmp5_;
#line 459 "ease-background-widget.vala"
				ease_background_set_gradient (self->priv->background, _tmp5_ = ease_gradient_new (_tmp3_ = ease_color_get_black (), _tmp4_ = ease_color_get_white ()));
#line 1324 "ease-background-widget.c"
				_g_object_unref0 (_tmp5_);
				_g_object_unref0 (_tmp4_);
				_g_object_unref0 (_tmp3_);
			}
#line 463 "ease-background-widget.vala"
			gtk_combo_box_set_active (self->priv->gradient_type, (gint) ease_gradient_get_mode (ease_background_get_gradient (self->priv->background)));
#line 465 "ease-background-widget.vala"
			ease_background_set_background_type (self->priv->background, EASE_BACKGROUND_TYPE_GRADIENT);
#line 467 "ease-background-widget.vala"
			gtk_color_button_set_color (self->priv->grad_color1, (_tmp7_ = (ease_color_get_gdk (ease_gradient_get_start (ease_background_get_gradient (self->priv->background)), &_tmp6_), _tmp6_), &_tmp7_));
#line 468 "ease-background-widget.vala"
			gtk_color_button_set_color (self->priv->grad_color2, (_tmp9_ = (ease_color_get_gdk (ease_gradient_get_end (ease_background_get_gradient (self->priv->background)), &_tmp8_), _tmp8_), &_tmp9_));
#line 470 "ease-background-widget.vala"
			gtk_adjustment_set_value (gtk_range_get_adjustment ((GtkRange*) self->priv->grad_angle), ease_gradient_get_angle (ease_background_get_gradient (self->priv->background)));
#line 472 "ease-background-widget.vala"
			break;
#line 1341 "ease-background-widget.c"
		}
		case EASE_BACKGROUND_TYPE_IMAGE:
		{
#line 475 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_color);
#line 476 "ease-background-widget.vala"
			gtk_widget_hide_all ((GtkWidget*) self->priv->box_gradient);
#line 477 "ease-background-widget.vala"
			gtk_widget_show_all ((GtkWidget*) self->priv->box_image);
#line 479 "ease-background-widget.vala"
			ease_background_set_background_type (self->priv->background, EASE_BACKGROUND_TYPE_IMAGE);
#line 480 "ease-background-widget.vala"
			if (ease_image_get_source (ease_background_get_image (self->priv->background)) != NULL) {
#line 482 "ease-background-widget.vala"
				gtk_file_chooser_set_filename ((GtkFileChooser*) self->priv->bg_image, ease_image_get_source (ease_background_get_image (self->priv->background)));
#line 1357 "ease-background-widget.c"
			} else {
#line 486 "ease-background-widget.vala"
				gtk_file_chooser_unselect_all ((GtkFileChooser*) self->priv->bg_image);
#line 1361 "ease-background-widget.c"
			}
#line 489 "ease-background-widget.vala"
			gtk_combo_box_set_active (self->priv->image_fill, (gint) ease_image_get_fill (ease_background_get_image (self->priv->background)));
#line 491 "ease-background-widget.vala"
			break;
#line 1367 "ease-background-widget.c"
		}
	}
}


#line 507 "ease-background-widget.vala"
static void _lambda32_ (Block4Data* _data4_) {
#line 1375 "ease-background-widget.c"
	EaseBackgroundWidget * self;
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_;
	self = _data4_->self;
#line 508 "ease-background-widget.vala"
	gtk_color_button_set_color (_data4_->sender, (_tmp1_ = (ease_color_get_gdk (_data4_->color, &_tmp0_), _tmp0_), &_tmp1_));
#line 509 "ease-background-widget.vala"
	gtk_color_button_set_alpha (_data4_->sender, (guint) ease_color_get_alpha16 (_data4_->color));
#line 1384 "ease-background-widget.c"
}


#line 507 "ease-background-widget.vala"
static void __lambda32__ease_undo_item_applied (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 1390 "ease-background-widget.c"
	_lambda32_ (self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->sender);
		_g_object_unref0 (_data4_->color);
		g_slice_free (Block4Data, _data4_);
	}
}


#line 495 "ease-background-widget.vala"
static EaseUndoAction* ease_background_widget_set_color (EaseBackgroundWidget* self, GtkColorButton* sender, EaseColor* color) {
#line 1413 "ease-background-widget.c"
	EaseUndoAction* result = NULL;
	Block4Data* _data4_;
	EaseUndoAction* action;
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_;
#line 495 "ease-background-widget.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 495 "ease-background-widget.vala"
	g_return_val_if_fail (color != NULL, NULL);
#line 1423 "ease-background-widget.c"
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->sender = _g_object_ref0 (sender);
	_data4_->color = _g_object_ref0 (color);
#line 498 "ease-background-widget.vala"
	action = ease_color_undo_action (_data4_->color);
#line 501 "ease-background-widget.vala"
	ease_color_set_gdk (_data4_->color, (_tmp1_ = (gtk_color_button_get_color (_data4_->sender, &_tmp0_), _tmp0_), &_tmp1_));
#line 504 "ease-background-widget.vala"
	if (ease_background_widget_get_use_alpha (self)) {
#line 504 "ease-background-widget.vala"
		ease_color_set_alpha16 (_data4_->color, (guint16) gtk_color_button_get_alpha (_data4_->sender));
#line 1437 "ease-background-widget.c"
	}
#line 507 "ease-background-widget.vala"
	g_signal_connect_data ((EaseUndoItem*) action, "applied", (GCallback) __lambda32__ease_undo_item_applied, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 1441 "ease-background-widget.c"
	result = action;
	block4_data_unref (_data4_);
#line 512 "ease-background-widget.vala"
	return result;
#line 1446 "ease-background-widget.c"
}


gboolean ease_background_widget_get_use_alpha (EaseBackgroundWidget* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_color_button_get_use_alpha (self->priv->bg_color);
#line 58 "ease-background-widget.vala"
	return result;
#line 1456 "ease-background-widget.c"
}


void ease_background_widget_set_use_alpha (EaseBackgroundWidget* self, gboolean value) {
	g_return_if_fail (self != NULL);
#line 61 "ease-background-widget.vala"
	gtk_color_button_set_use_alpha (self->priv->bg_color, value);
#line 62 "ease-background-widget.vala"
	gtk_color_button_set_use_alpha (self->priv->grad_color1, value);
#line 63 "ease-background-widget.vala"
	gtk_color_button_set_use_alpha (self->priv->grad_color2, value);
#line 1468 "ease-background-widget.c"
	g_object_notify ((GObject *) self, "use-alpha");
}


static void ease_background_widget_class_init (EaseBackgroundWidgetClass * klass) {
	ease_background_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseBackgroundWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_background_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_background_widget_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_background_widget_finalize;
	/**
	 * Whether or not the background widget's color selection dialogs display
	 * an opacity slider. By default, they will display the slider (except with 
	 * the {@link BackgroundWidget.for_slide} constructor.
	 *
	 * This property controls visibility of the opacity control for both solid
	 * color and gradient backgrounds. There is no way to disable or enable it
	 * independently. 
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_BACKGROUND_WIDGET_USE_ALPHA, g_param_spec_boolean ("use-alpha", "use-alpha", "use-alpha", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void ease_background_widget_instance_init (EaseBackgroundWidget * self) {
	self->priv = EASE_BACKGROUND_WIDGET_GET_PRIVATE (self);
}


static void ease_background_widget_finalize (GObject* obj) {
	EaseBackgroundWidget * self;
	self = EASE_BACKGROUND_WIDGET (obj);
	_g_object_unref0 (self->priv->background_type);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->gradient_type);
	_g_object_unref0 (self->priv->box_color);
	_g_object_unref0 (self->priv->box_gradient);
	_g_object_unref0 (self->priv->box_image);
	_g_object_unref0 (self->priv->image_fill);
	_g_object_unref0 (self->priv->grad_angle);
	_g_object_unref0 (self->priv->bg_color);
	_g_object_unref0 (self->priv->grad_color1);
	_g_object_unref0 (self->priv->grad_color2);
	_g_object_unref0 (self->priv->bg_image);
	_g_object_unref0 (self->priv->background);
	_g_object_unref0 (self->priv->document);
	_g_object_unref0 (self->priv->slide);
	_g_object_unref0 (self->priv->element);
	G_OBJECT_CLASS (ease_background_widget_parent_class)->finalize (obj);
}


/**
 * A widget that controls the properties of an {@link Ease.Background}.
 */
GType ease_background_widget_get_type (void) {
	static volatile gsize ease_background_widget_type_id__volatile = 0;
	if (g_once_init_enter (&ease_background_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseBackgroundWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_background_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseBackgroundWidget), 0, (GInstanceInitFunc) ease_background_widget_instance_init, NULL };
		GType ease_background_widget_type_id;
		ease_background_widget_type_id = g_type_register_static (GTK_TYPE_ALIGNMENT, "EaseBackgroundWidget", &g_define_type_info, 0);
		g_once_init_leave (&ease_background_widget_type_id__volatile, ease_background_widget_type_id);
	}
	return ease_background_widget_type_id__volatile;
}


static void ease_background_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseBackgroundWidget * self;
	self = EASE_BACKGROUND_WIDGET (object);
	switch (property_id) {
		case EASE_BACKGROUND_WIDGET_USE_ALPHA:
		g_value_set_boolean (value, ease_background_widget_get_use_alpha (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_background_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseBackgroundWidget * self;
	self = EASE_BACKGROUND_WIDGET (object);
	switch (property_id) {
		case EASE_BACKGROUND_WIDGET_USE_ALPHA:
		ease_background_widget_set_use_alpha (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




