/* ease-html-exporter.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-html-exporter.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;
typedef struct _EaseHTMLExporterPrivate EaseHTMLExporterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _EaseHTMLExporter {
	GObject parent_instance;
	EaseHTMLExporterPrivate * priv;
};

struct _EaseHTMLExporterClass {
	GObjectClass parent_class;
};

struct _EaseHTMLExporterPrivate {
	GtkDialog* window;
	GtkProgressBar* progress;
	gint render_index_priv;
	char* _path;
};


static gpointer ease_html_exporter_parent_class = NULL;

GType ease_html_exporter_get_type (void) G_GNUC_CONST;
#define EASE_HTML_EXPORTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterPrivate))
enum  {
	EASE_HTML_EXPORTER_DUMMY_PROPERTY,
	EASE_HTML_EXPORTER_RENDER_INDEX,
	EASE_HTML_EXPORTER_PATH,
	EASE_HTML_EXPORTER_BASENAME
};
#define EASE_HTML_EXPORTER_HEADER "<!DOCTYPE html>\n" \
"<html>\n" \
"<head>\n" \
"\t<title>Presentation</title>\n" \
"\t\n" \
"\t<script type=\"text/javascript\">\n" \
"\t\tvar slide = -1;\n" \
"\n" \
"\t\tfunction load() {\n" \
"\t\t\tadvance();\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction keydown(e) {\n" \
"\t\t\tvar code = e.keyCode;\n" \
"\t\t\tif (code == 32 || code == 39 || code == 13 || code == 40 || code" \
" == 39) {\n" \
"\t\t\t\tadvance();\n" \
"\t\t\t}\n" \
"\t\n" \
"\t\t\telse if (code == 8 || code == 46 || code == 37 || code == 38) {\n" \
"\t\t\t\tretreat();\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction advance() {\n" \
"\t\t\tif (document.getElementById(\"slide\" + (slide + 1)) != null) {\n" \
"\t\t\t\tif (slide >= 0) {\n" \
"\t\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"" \
"none\";\n" \
"\t\t\t\t}\n" \
"\t\t\t\tslide++;\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"b" \
"lock\";\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction retreat() {\n" \
"\t\t\tif (slide > 0) {\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"n" \
"one\";\n" \
"\t\t\t\tslide--;\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"b" \
"lock\";\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tdocument.onkeydown = keydown;\n" \
"\t</script>\n" \
"\t\n" \
"\t<style>\n" \
"\t\t.slide {\n" \
"\t\t\twidth: %ipx;\n" \
"\t\t\theight: %ipx;\n" \
"\t\t\tdisplay: none;\n" \
"\t\t\toverflow: hidden;\n" \
"\t\t\tposition: relative;\n" \
"\t\t\tmargin: 20px auto 20px auto;\n" \
"\t\t}\n" \
"\t\thtml {\n" \
"\t\t\tpadding: 0px;\n" \
"\t\t\tmargin: 0px;\n" \
"\t\t\tbackground-color: black;\n" \
"\t\t}\n" \
"\t</style>\n" \
"</head>\n" \
"<body onload=load()>\n"
EaseHTMLExporter* ease_html_exporter_new (void);
EaseHTMLExporter* ease_html_exporter_construct (GType object_type);
gboolean ease_html_exporter_request_path (EaseHTMLExporter* self, GtkWindow* win);
char* ease_dialog_save (const char* title, GtkWindow* modal);
static void ease_html_exporter_set_path (EaseHTMLExporter* self, const char* value);
const char* ease_html_exporter_get_path (EaseHTMLExporter* self);
void ease_html_exporter_add_progress (EaseHTMLExporter* self, double amount);
void ease_html_exporter_finish (EaseHTMLExporter* self);
void ease_html_exporter_copy_file (EaseHTMLExporter* self, const char* end_path, const char* base_path);
void ease_error_dialog (const char* title, const char* message);
char* ease_html_exporter_copy_rendered (EaseHTMLExporter* self, const char* rendered);
gint ease_html_exporter_get_render_index (EaseHTMLExporter* self);
char* ease_html_exporter_get_basename (EaseHTMLExporter* self);
static void ease_html_exporter_finalize (GObject* obj);
static void ease_html_exporter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_html_exporter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



/**
 * Creates a new HTMLExporter.
 */
#line 59 "ease-html-exporter.vala"
EaseHTMLExporter* ease_html_exporter_construct (GType object_type) {
#line 99 "ease-html-exporter.c"
	EaseHTMLExporter * self;
	GtkProgressBar* _tmp0_;
#line 59 "ease-html-exporter.vala"
	self = (EaseHTMLExporter*) g_object_new (object_type, NULL);
#line 61 "ease-html-exporter.vala"
	self->priv->progress = (_tmp0_ = g_object_ref_sink ((GtkProgressBar*) gtk_progress_bar_new ()), _g_object_unref0 (self->priv->progress), _tmp0_);
#line 106 "ease-html-exporter.c"
	return self;
}


#line 59 "ease-html-exporter.vala"
EaseHTMLExporter* ease_html_exporter_new (void) {
#line 59 "ease-html-exporter.vala"
	return ease_html_exporter_construct (EASE_TYPE_HTML_EXPORTER);
#line 115 "ease-html-exporter.c"
}


/**
 * Asks the user for an output path
 *
 * Shows a file chooser dialog. If the user does not cancel the export,
 * creates a the progress dialog. Returns false if the user cancels,
 * otherwise returns true.
 * 
 * @param win The window that the dialog should be modal for
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 73 "ease-html-exporter.vala"
gboolean ease_html_exporter_request_path (EaseHTMLExporter* self, GtkWindow* win) {
#line 135 "ease-html-exporter.c"
	gboolean result = FALSE;
	char* _tmp0_;
#line 73 "ease-html-exporter.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 73 "ease-html-exporter.vala"
	g_return_val_if_fail (win != NULL, FALSE);
#line 75 "ease-html-exporter.vala"
	ease_html_exporter_set_path (self, _tmp0_ = ease_dialog_save (_ ("Export to HTML"), win));
#line 144 "ease-html-exporter.c"
	_g_free0 (_tmp0_);
#line 77 "ease-html-exporter.vala"
	if (self->priv->_path != NULL) {
#line 148 "ease-html-exporter.c"
		GtkDialog* _tmp1_;
		GtkVBox* vbox;
#line 80 "ease-html-exporter.vala"
		self->priv->window = (_tmp1_ = g_object_ref_sink ((GtkDialog*) gtk_dialog_new ()), _g_object_unref0 (self->priv->window), _tmp1_);
#line 81 "ease-html-exporter.vala"
		g_object_set ((GtkWidget*) self->priv->window, "width-request", 400, NULL);
#line 82 "ease-html-exporter.vala"
		gtk_window_set_title ((GtkWindow*) self->priv->window, _ ("Exporting as HTML"));
#line 83 "ease-html-exporter.vala"
		vbox = _g_object_ref0 (GTK_VBOX (gtk_dialog_get_content_area (self->priv->window)));
#line 84 "ease-html-exporter.vala"
		gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->progress, TRUE, TRUE, (guint) 5);
#line 85 "ease-html-exporter.vala"
		gtk_widget_show_all ((GtkWidget*) self->priv->window);
#line 163 "ease-html-exporter.c"
		result = TRUE;
		_g_object_unref0 (vbox);
#line 87 "ease-html-exporter.vala"
		return result;
#line 168 "ease-html-exporter.c"
	}
	result = FALSE;
#line 90 "ease-html-exporter.vala"
	return result;
#line 173 "ease-html-exporter.c"
}


/**
 * Adds to the progress dialog's progress bar, which ranges from 0 to 1
 *
 * @param amount The amount of progress to add
 */
#line 98 "ease-html-exporter.vala"
void ease_html_exporter_add_progress (EaseHTMLExporter* self, double amount) {
#line 98 "ease-html-exporter.vala"
	g_return_if_fail (self != NULL);
#line 100 "ease-html-exporter.vala"
	gtk_progress_bar_set_fraction (self->priv->progress, gtk_progress_bar_get_fraction (self->priv->progress) + amount);
#line 188 "ease-html-exporter.c"
}


/**
 * Finishes exporting and hides the progress dialog
 */
#line 106 "ease-html-exporter.vala"
void ease_html_exporter_finish (EaseHTMLExporter* self) {
#line 106 "ease-html-exporter.vala"
	g_return_if_fail (self != NULL);
#line 108 "ease-html-exporter.vala"
	gtk_widget_hide_all ((GtkWidget*) self->priv->window);
#line 109 "ease-html-exporter.vala"
	gtk_object_destroy ((GtkObject*) self->priv->window);
#line 203 "ease-html-exporter.c"
}


/**
 * Copies a file to the output path
 *
 * To show images or videos in an HTML presentation, they must be
 * copied to a path relative to the HTML document.
 *
 * @param end_path The file's path relative to the Ease file
 * @param base_path The output directory and filename
 */
#line 121 "ease-html-exporter.vala"
void ease_html_exporter_copy_file (EaseHTMLExporter* self, const char* end_path, const char* base_path) {
#line 218 "ease-html-exporter.c"
	char* _tmp0_;
	GFile* _tmp1_;
	GFile* source;
	char* _tmp2_;
	char* _tmp3_;
	GFile* _tmp4_;
	GFile* destination;
	GError * _inner_error_ = NULL;
#line 121 "ease-html-exporter.vala"
	g_return_if_fail (self != NULL);
#line 121 "ease-html-exporter.vala"
	g_return_if_fail (end_path != NULL);
#line 121 "ease-html-exporter.vala"
	g_return_if_fail (base_path != NULL);
#line 123 "ease-html-exporter.vala"
	source = (_tmp1_ = g_file_new_for_path (_tmp0_ = g_build_path ("/", base_path, end_path, NULL)), _g_free0 (_tmp0_), _tmp1_);
#line 125 "ease-html-exporter.vala"
	destination = (_tmp4_ = g_file_new_for_path (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (self->priv->_path, " ", NULL), end_path, NULL)), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _tmp4_);
#line 237 "ease-html-exporter.c"
	{
		GFile* parent;
#line 130 "ease-html-exporter.vala"
		parent = g_file_get_parent (destination);
#line 131 "ease-html-exporter.vala"
		if (!g_file_query_exists (parent, NULL)) {
#line 133 "ease-html-exporter.vala"
			g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
#line 246 "ease-html-exporter.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				goto __catch13_g_error;
			}
		}
#line 137 "ease-html-exporter.vala"
		g_file_copy (source, destination, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
#line 254 "ease-html-exporter.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			goto __catch13_g_error;
		}
		_g_object_unref0 (parent);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 144 "ease-html-exporter.vala"
			ease_error_dialog (_ ("Error Copying File"), e->message);
#line 270 "ease-html-exporter.c"
			_g_error_free0 (e);
		}
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (destination);
		_g_object_unref0 (source);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (destination);
	_g_object_unref0 (source);
}


/**
 * Copies a rendered file to the output path. Returns the filename.
 */
#line 151 "ease-html-exporter.vala"
char* ease_html_exporter_copy_rendered (EaseHTMLExporter* self, const char* rendered) {
#line 292 "ease-html-exporter.c"
	char* result = NULL;
	GFile* source;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* dest_path;
	char* _tmp3_;
	char* _tmp4_;
	GFile* _tmp5_;
	GFile* destination;
	GError * _inner_error_ = NULL;
#line 151 "ease-html-exporter.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 151 "ease-html-exporter.vala"
	g_return_val_if_fail (rendered != NULL, NULL);
#line 153 "ease-html-exporter.vala"
	source = g_file_new_for_path (rendered);
#line 154 "ease-html-exporter.vala"
	dest_path = (_tmp2_ = g_build_filename ("Rendered", _tmp1_ = g_strconcat (_tmp0_ = g_strdup_printf ("%i", ease_html_exporter_get_render_index (self)), ".png", NULL), NULL), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
#line 156 "ease-html-exporter.vala"
	destination = (_tmp5_ = g_file_new_for_path (_tmp4_ = g_build_filename (_tmp3_ = g_strconcat (self->priv->_path, " Media", NULL), dest_path, NULL)), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp5_);
#line 314 "ease-html-exporter.c"
	{
		GFile* parent;
#line 162 "ease-html-exporter.vala"
		parent = g_file_get_parent (destination);
#line 163 "ease-html-exporter.vala"
		if (!g_file_query_exists (parent, NULL)) {
#line 165 "ease-html-exporter.vala"
			g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
#line 323 "ease-html-exporter.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				goto __catch14_g_error;
			}
		}
#line 169 "ease-html-exporter.vala"
		g_file_copy (source, destination, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
#line 331 "ease-html-exporter.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			goto __catch14_g_error;
		}
		_g_object_unref0 (parent);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 176 "ease-html-exporter.vala"
			ease_error_dialog (_ ("Error Copying File"), e->message);
#line 347 "ease-html-exporter.c"
			_g_error_free0 (e);
		}
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (destination);
		_g_free0 (dest_path);
		_g_object_unref0 (source);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = dest_path;
	_g_object_unref0 (destination);
	_g_object_unref0 (source);
#line 179 "ease-html-exporter.vala"
	return result;
#line 365 "ease-html-exporter.c"
}


gint ease_html_exporter_get_render_index (EaseHTMLExporter* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->render_index_priv++;
#line 35 "ease-html-exporter.vala"
	return result;
#line 375 "ease-html-exporter.c"
}


const char* ease_html_exporter_get_path (EaseHTMLExporter* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_path;
#line 42 "ease-html-exporter.vala"
	return result;
#line 385 "ease-html-exporter.c"
}


static void ease_html_exporter_set_path (EaseHTMLExporter* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_path), _tmp0_);
	g_object_notify ((GObject *) self, "path");
}


char* ease_html_exporter_get_basename (EaseHTMLExporter* self) {
	char* result;
	GFile* file;
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "ease-html-exporter.vala"
	file = g_file_new_for_path (self->priv->_path);
#line 403 "ease-html-exporter.c"
	result = g_file_get_basename (file);
	_g_object_unref0 (file);
#line 52 "ease-html-exporter.vala"
	return result;
#line 408 "ease-html-exporter.c"
}


static void ease_html_exporter_class_init (EaseHTMLExporterClass * klass) {
	ease_html_exporter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseHTMLExporterPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_html_exporter_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_html_exporter_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_html_exporter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_HTML_EXPORTER_RENDER_INDEX, g_param_spec_int ("render-index", "render-index", "render-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The path to export HTML to.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_HTML_EXPORTER_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The final path component of the export path.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_HTML_EXPORTER_BASENAME, g_param_spec_string ("basename", "basename", "basename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void ease_html_exporter_instance_init (EaseHTMLExporter * self) {
	self->priv = EASE_HTML_EXPORTER_GET_PRIVATE (self);
	self->priv->render_index_priv = 0;
}


static void ease_html_exporter_finalize (GObject* obj) {
	EaseHTMLExporter * self;
	self = EASE_HTML_EXPORTER (obj);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->progress);
	_g_free0 (self->priv->_path);
	G_OBJECT_CLASS (ease_html_exporter_parent_class)->finalize (obj);
}


/**
 * Exports Ease {@link Document}s as HTML5 files
 *
 * HTMLExporter creates a save dialog and a progress dialog. The actual
 * exporting is done with the {@link Document}, {@link Slide}, and
 * {@link Element} classes. The exported {@link Document} reports back to
 * HTMLExported when the export is complete, allowing the dialog to close.
 *
 * HTMLExporter also handles copying media files to the output directory.
 */
GType ease_html_exporter_get_type (void) {
	static volatile gsize ease_html_exporter_type_id__volatile = 0;
	if (g_once_init_enter (&ease_html_exporter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseHTMLExporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_html_exporter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseHTMLExporter), 0, (GInstanceInitFunc) ease_html_exporter_instance_init, NULL };
		GType ease_html_exporter_type_id;
		ease_html_exporter_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseHTMLExporter", &g_define_type_info, 0);
		g_once_init_leave (&ease_html_exporter_type_id__volatile, ease_html_exporter_type_id);
	}
	return ease_html_exporter_type_id__volatile;
}


static void ease_html_exporter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseHTMLExporter * self;
	self = EASE_HTML_EXPORTER (object);
	switch (property_id) {
		case EASE_HTML_EXPORTER_RENDER_INDEX:
		g_value_set_int (value, ease_html_exporter_get_render_index (self));
		break;
		case EASE_HTML_EXPORTER_PATH:
		g_value_set_string (value, ease_html_exporter_get_path (self));
		break;
		case EASE_HTML_EXPORTER_BASENAME:
		g_value_take_string (value, ease_html_exporter_get_basename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_html_exporter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseHTMLExporter * self;
	self = EASE_HTML_EXPORTER (object);
	switch (property_id) {
		case EASE_HTML_EXPORTER_PATH:
		ease_html_exporter_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




