/* ease-plugin-import-service.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-plugin-import-service.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rest/rest-proxy.h>
#include <rest/rest-proxy-call.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gio/gio.h>


#define EASE_PLUGIN_TYPE_IMPORT_SERVICE (ease_plugin_import_service_get_type ())
#define EASE_PLUGIN_IMPORT_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_PLUGIN_TYPE_IMPORT_SERVICE, EasePluginImportService))
#define EASE_PLUGIN_IMPORT_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_PLUGIN_TYPE_IMPORT_SERVICE, EasePluginImportServiceClass))
#define EASE_PLUGIN_IS_IMPORT_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_PLUGIN_TYPE_IMPORT_SERVICE))
#define EASE_PLUGIN_IS_IMPORT_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_PLUGIN_TYPE_IMPORT_SERVICE))
#define EASE_PLUGIN_IMPORT_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_PLUGIN_TYPE_IMPORT_SERVICE, EasePluginImportServiceClass))

typedef struct _EasePluginImportService EasePluginImportService;
typedef struct _EasePluginImportServiceClass EasePluginImportServiceClass;
typedef struct _EasePluginImportServicePrivate EasePluginImportServicePrivate;

#define EASE_PLUGIN_TYPE_IMPORT_MEDIA (ease_plugin_import_media_get_type ())
#define EASE_PLUGIN_IMPORT_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_PLUGIN_TYPE_IMPORT_MEDIA, EasePluginImportMedia))
#define EASE_PLUGIN_IMPORT_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_PLUGIN_TYPE_IMPORT_MEDIA, EasePluginImportMediaClass))
#define EASE_PLUGIN_IS_IMPORT_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_PLUGIN_TYPE_IMPORT_MEDIA))
#define EASE_PLUGIN_IS_IMPORT_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_PLUGIN_TYPE_IMPORT_MEDIA))
#define EASE_PLUGIN_IMPORT_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_PLUGIN_TYPE_IMPORT_MEDIA, EasePluginImportMediaClass))

typedef struct _EasePluginImportMedia EasePluginImportMedia;
typedef struct _EasePluginImportMediaClass EasePluginImportMediaClass;

#define EASE_PLUGIN_IMPORT_SERVICE_TYPE_COLUMN (ease_plugin_import_service_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _EasePluginImportMediaPrivate EasePluginImportMediaPrivate;

struct _EasePluginImportService {
	GObject parent_instance;
	EasePluginImportServicePrivate * priv;
	GtkListStore* model;
};

struct _EasePluginImportServiceClass {
	GObjectClass parent_class;
	void (*parse_data) (EasePluginImportService* self, const char* data);
	RestProxy* (*create_proxy) (EasePluginImportService* self);
	RestProxyCall* (*create_call) (EasePluginImportService* self, RestProxy* proxy, const char* search);
	GtkWidget* (*extra_widget) (EasePluginImportService* self);
};

struct _EasePluginImportServicePrivate {
	RestProxy* proxy;
	RestProxyCall* call;
	GStaticRecMutex __lock_model;
	float list_size;
	GeeLinkedList* images_list;
	GStaticRecMutex __lock_images_list;
};

typedef enum  {
	EASE_PLUGIN_IMPORT_SERVICE_COLUMN_PIXBUF = 0,
	EASE_PLUGIN_IMPORT_SERVICE_COLUMN_TEXT = 1,
	EASE_PLUGIN_IMPORT_SERVICE_COLUMN_IMPORT_MEDIA = 2
} EasePluginImportServiceColumn;

struct _EasePluginImportMedia {
	GObject parent_instance;
	EasePluginImportMediaPrivate * priv;
	char* title;
	char* file_link;
	char* thumb_link;
};

struct _EasePluginImportMediaClass {
	GObjectClass parent_class;
};


static gpointer ease_plugin_import_service_parent_class = NULL;

GType ease_plugin_import_service_get_type (void) G_GNUC_CONST;
GType ease_plugin_import_media_get_type (void) G_GNUC_CONST;
#define EASE_PLUGIN_IMPORT_SERVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_PLUGIN_TYPE_IMPORT_SERVICE, EasePluginImportServicePrivate))
enum  {
	EASE_PLUGIN_IMPORT_SERVICE_DUMMY_PROPERTY
};
GType ease_plugin_import_service_column_get_type (void) G_GNUC_CONST;
void ease_plugin_import_service_parse_data (EasePluginImportService* self, const char* data);
static void ease_plugin_import_service_real_parse_data (EasePluginImportService* self, const char* data);
RestProxy* ease_plugin_import_service_create_proxy (EasePluginImportService* self);
static RestProxy* ease_plugin_import_service_real_create_proxy (EasePluginImportService* self);
RestProxyCall* ease_plugin_import_service_create_call (EasePluginImportService* self, RestProxy* proxy, const char* search);
static RestProxyCall* ease_plugin_import_service_real_create_call (EasePluginImportService* self, RestProxy* proxy, const char* search);
void ease_plugin_import_service_add_media (EasePluginImportService* self, EasePluginImportMedia* media);
void ease_plugin_import_service_run (EasePluginImportService* self, const char* search);
static void ease_plugin_import_service_on_call_finish (EasePluginImportService* self, RestProxyCall* call);
static void _ease_plugin_import_service_on_call_finish_rest_proxy_call_async_callback (RestProxyCall* call, GError* _error_, GObject* weak_object, gpointer self);
GtkWidget* ease_plugin_import_service_extra_widget (EasePluginImportService* self);
static GtkWidget* ease_plugin_import_service_real_extra_widget (EasePluginImportService* self);
static void* ease_plugin_import_service_threaded_get_pixbufs (EasePluginImportService* self);
static void* _ease_plugin_import_service_threaded_get_pixbufs_gthread_func (gpointer self);
static GdkPixbuf* ease_plugin_import_service_gdk_pixbuf_from_uri (EasePluginImportService* self, const char* uri);
EasePluginImportService* ease_plugin_import_service_construct (GType object_type);
static void ease_plugin_import_service_finalize (GObject* obj);


static void g_cclosure_user_marshal_OBJECT__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
 * Enumerator for columns in the "model" ListStore.
 */
GType ease_plugin_import_service_column_get_type (void) {
	static volatile gsize ease_plugin_import_service_column_type_id__volatile = 0;
	if (g_once_init_enter (&ease_plugin_import_service_column_type_id__volatile)) {
		static const GEnumValue values[] = {{EASE_PLUGIN_IMPORT_SERVICE_COLUMN_PIXBUF, "EASE_PLUGIN_IMPORT_SERVICE_COLUMN_PIXBUF", "pixbuf"}, {EASE_PLUGIN_IMPORT_SERVICE_COLUMN_TEXT, "EASE_PLUGIN_IMPORT_SERVICE_COLUMN_TEXT", "text"}, {EASE_PLUGIN_IMPORT_SERVICE_COLUMN_IMPORT_MEDIA, "EASE_PLUGIN_IMPORT_SERVICE_COLUMN_IMPORT_MEDIA", "import-media"}, {0, NULL, NULL}};
		GType ease_plugin_import_service_column_type_id;
		ease_plugin_import_service_column_type_id = g_enum_register_static ("EasePluginImportServiceColumn", values);
		g_once_init_leave (&ease_plugin_import_service_column_type_id__volatile, ease_plugin_import_service_column_type_id);
	}
	return ease_plugin_import_service_column_type_id__volatile;
}


/**
 * Subclasses must override this function to parse the data returned from
 * their Rest.ProxyCall.
 *
 * This method should construct images_list, a Gee.LinkedList of
 * {@link ImportMedia}s (or a subclass specific to your plugin).
 * ImportService will then automatically download the images.
 *
 * @param data The data returned from the REST call.
 */
#line 100 "ease-plugin-import-service.vala"
static void ease_plugin_import_service_real_parse_data (EasePluginImportService* self, const char* data) {
#line 161 "ease-plugin-import-service.c"
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `ease_plugin_import_service_parse_data'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


#line 22 "ease-plugin-import-media.vala"
void ease_plugin_import_service_parse_data (EasePluginImportService* self, const char* data) {
#line 22 "ease-plugin-import-media.vala"
	EASE_PLUGIN_IMPORT_SERVICE_GET_CLASS (self)->parse_data (self, data);
#line 172 "ease-plugin-import-service.c"
}


/**
 * Allows subclasses to provide a Rest.Proxy for their website.
 */
#line 105 "ease-plugin-import-service.vala"
static RestProxy* ease_plugin_import_service_real_create_proxy (EasePluginImportService* self) {
#line 181 "ease-plugin-import-service.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `ease_plugin_import_service_create_proxy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


#line 22 "ease-plugin-import-media.vala"
RestProxy* ease_plugin_import_service_create_proxy (EasePluginImportService* self) {
#line 22 "ease-plugin-import-media.vala"
	return EASE_PLUGIN_IMPORT_SERVICE_GET_CLASS (self)->create_proxy (self);
#line 192 "ease-plugin-import-service.c"
}


/**
 * Allows subclasses to provide a Rest.ProxyCall for their website.
 *
 * @param proxy The proxy that the subclass created.
 * @param search The search string provided by the user.
 */
#line 113 "ease-plugin-import-service.vala"
static RestProxyCall* ease_plugin_import_service_real_create_call (EasePluginImportService* self, RestProxy* proxy, const char* search) {
#line 204 "ease-plugin-import-service.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `ease_plugin_import_service_create_call'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


#line 22 "ease-plugin-import-media.vala"
RestProxyCall* ease_plugin_import_service_create_call (EasePluginImportService* self, RestProxy* proxy, const char* search) {
#line 22 "ease-plugin-import-media.vala"
	return EASE_PLUGIN_IMPORT_SERVICE_GET_CLASS (self)->create_call (self, proxy, search);
#line 215 "ease-plugin-import-service.c"
}


/**
 * Adds an {@link ImportMedia} to the downloads list.
 */
#line 118 "ease-plugin-import-service.vala"
void ease_plugin_import_service_add_media (EasePluginImportService* self, EasePluginImportMedia* media) {
#line 118 "ease-plugin-import-service.vala"
	g_return_if_fail (self != NULL);
#line 118 "ease-plugin-import-service.vala"
	g_return_if_fail (media != NULL);
#line 120 "ease-plugin-import-service.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->images_list, media);
#line 230 "ease-plugin-import-service.c"
}


/**
 * Runs a search with this service.
 *
 * @param search The search string to use.
 */
#line 163 "ease-plugin-import-service.vala"
static void _ease_plugin_import_service_on_call_finish_rest_proxy_call_async_callback (RestProxyCall* call, GError* _error_, GObject* weak_object, gpointer self) {
#line 241 "ease-plugin-import-service.c"
	ease_plugin_import_service_on_call_finish (self, call);
}


#line 128 "ease-plugin-import-service.vala"
void ease_plugin_import_service_run (EasePluginImportService* self, const char* search) {
#line 248 "ease-plugin-import-service.c"
	RestProxy* _tmp0_;
	RestProxyCall* _tmp1_;
	GError * _inner_error_ = NULL;
#line 128 "ease-plugin-import-service.vala"
	g_return_if_fail (self != NULL);
#line 128 "ease-plugin-import-service.vala"
	g_return_if_fail (search != NULL);
#line 131 "ease-plugin-import-service.vala"
	self->priv->proxy = (_tmp0_ = ease_plugin_import_service_create_proxy (self), _g_object_unref0 (self->priv->proxy), _tmp0_);
#line 132 "ease-plugin-import-service.vala"
	self->priv->call = (_tmp1_ = ease_plugin_import_service_create_call (self, self->priv->proxy, search), _g_object_unref0 (self->priv->call), _tmp1_);
#line 134 "ease-plugin-import-service.vala"
	g_signal_emit_by_name (self, "started");
#line 262 "ease-plugin-import-service.c"
	{
#line 137 "ease-plugin-import-service.vala"
		rest_proxy_call_async (self->priv->call, _ease_plugin_import_service_on_call_finish_rest_proxy_call_async_callback, self, (GObject*) self, &_inner_error_);
#line 266 "ease-plugin-import-service.c"
		if (_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 138 "ease-plugin-import-service.vala"
			g_critical ("ease-plugin-import-service.vala:138: %s", e->message);
#line 280 "ease-plugin-import-service.c"
			_g_error_free0 (e);
		}
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
 * This virtual function should be overridden by services that require
 * more advanced control than a simple string search.
 *
 * For example, it can be used to select different types of Creative
 * Commons licenses. By default, it returns null.
 *
 * In order to properly fit into Ease's current search window layout, 
 * this should be a relatively short and narrow widget. One or two
 * checkboxes is ideal, any more will take up too much space (consider a
 * popup window if more space is required).
 */
#line 153 "ease-plugin-import-service.vala"
static GtkWidget* ease_plugin_import_service_real_extra_widget (EasePluginImportService* self) {
#line 307 "ease-plugin-import-service.c"
	GtkWidget* result = NULL;
#line 153 "ease-plugin-import-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 311 "ease-plugin-import-service.c"
	result = NULL;
#line 155 "ease-plugin-import-service.vala"
	return result;
#line 315 "ease-plugin-import-service.c"
}


#line 22 "ease-plugin-import-media.vala"
GtkWidget* ease_plugin_import_service_extra_widget (EasePluginImportService* self) {
#line 22 "ease-plugin-import-media.vala"
	return EASE_PLUGIN_IMPORT_SERVICE_GET_CLASS (self)->extra_widget (self);
#line 323 "ease-plugin-import-service.c"
}


/**
 * Signal handler for Rest.ProxyCall completion.
 *
 * @param call The completed Rest.ProxyCall.
 */
#line 215 "ease-plugin-import-service.vala"
static void* _ease_plugin_import_service_threaded_get_pixbufs_gthread_func (gpointer self) {
#line 334 "ease-plugin-import-service.c"
	void* result;
	result = ease_plugin_import_service_threaded_get_pixbufs (self);
	return result;
}


#line 163 "ease-plugin-import-service.vala"
static void ease_plugin_import_service_on_call_finish (EasePluginImportService* self, RestProxyCall* call) {
#line 343 "ease-plugin-import-service.c"
	GeeLinkedList* _tmp0_;
	GError * _inner_error_ = NULL;
#line 163 "ease-plugin-import-service.vala"
	g_return_if_fail (self != NULL);
#line 163 "ease-plugin-import-service.vala"
	g_return_if_fail (call != NULL);
#line 165 "ease-plugin-import-service.vala"
	g_signal_emit_by_name (self, "proxy-call-complete");
#line 168 "ease-plugin-import-service.vala"
	self->priv->images_list = (_tmp0_ = gee_linked_list_new (EASE_PLUGIN_TYPE_IMPORT_MEDIA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->images_list), _tmp0_);
#line 171 "ease-plugin-import-service.vala"
	ease_plugin_import_service_parse_data (self, rest_proxy_call_get_payload (call));
#line 174 "ease-plugin-import-service.vala"
	self->priv->list_size = (float) gee_collection_get_size ((GeeCollection*) self->priv->images_list);
#line 176 "ease-plugin-import-service.vala"
	if (self->priv->list_size > 0) {
#line 360 "ease-plugin-import-service.c"
		GtkListStore* _tmp1_;
		GtkIconView* _tmp2_ = NULL;
		GtkIconView* icons;
#line 179 "ease-plugin-import-service.vala"
		self->model = (_tmp1_ = gtk_list_store_new (3, GDK_TYPE_PIXBUF, G_TYPE_STRING, EASE_PLUGIN_TYPE_IMPORT_MEDIA), _g_object_unref0 (self->model), _tmp1_);
#line 183 "ease-plugin-import-service.vala"
		icons = (g_signal_emit_by_name (self, "loading-started", &_tmp2_), _tmp2_);
#line 184 "ease-plugin-import-service.vala"
		gtk_icon_view_set_model (icons, (GtkTreeModel*) self->model);
#line 185 "ease-plugin-import-service.vala"
		gtk_icon_view_set_text_column (icons, (gint) EASE_PLUGIN_IMPORT_SERVICE_COLUMN_TEXT);
#line 186 "ease-plugin-import-service.vala"
		gtk_icon_view_set_pixbuf_column (icons, (gint) EASE_PLUGIN_IMPORT_SERVICE_COLUMN_PIXBUF);
#line 189 "ease-plugin-import-service.vala"
		if (g_thread_supported ()) {
#line 376 "ease-plugin-import-service.c"
			{
#line 191 "ease-plugin-import-service.vala"
				g_thread_create (_ease_plugin_import_service_threaded_get_pixbufs_gthread_func, self, FALSE, &_inner_error_);
#line 380 "ease-plugin-import-service.c"
				if (_inner_error_ != NULL) {
					goto __catch21_g_error;
				}
			}
			goto __finally21;
			__catch21_g_error:
			{
				g_clear_error (&_inner_error_);
				_inner_error_ = NULL;
				{
#line 192 "ease-plugin-import-service.vala"
					ease_plugin_import_service_threaded_get_pixbufs (self);
#line 393 "ease-plugin-import-service.c"
				}
			}
			__finally21:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (icons);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
#line 196 "ease-plugin-import-service.vala"
			ease_plugin_import_service_threaded_get_pixbufs (self);
#line 406 "ease-plugin-import-service.c"
		}
		_g_object_unref0 (icons);
	} else {
#line 201 "ease-plugin-import-service.vala"
		g_signal_emit_by_name (self, "no-results");
#line 412 "ease-plugin-import-service.c"
	}
}


/**
 * Retrieves the first pixbuf in "images_list", then calls itself again if
 * there are more images.
 *
 * As its name implies, threaded_get_pixbufs should be used in a thread,
 * because getting images from the web can be slow. While it will work
 * when not run in a thread (if, for example, threads are not supported),
 * this will lock up the user interface and be a bad experience for the
 * user.
 */
#line 215 "ease-plugin-import-service.vala"
static void* ease_plugin_import_service_threaded_get_pixbufs (EasePluginImportService* self) {
#line 429 "ease-plugin-import-service.c"
	void* result = NULL;
	EasePluginImportMedia* image;
	const char* _tmp1_;
	GdkPixbuf* pixbuf;
	GtkTreeIter tree_itr = {0};
	GError * _inner_error_ = NULL;
#line 215 "ease-plugin-import-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 438 "ease-plugin-import-service.c"
	image = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_images_list);
		{
			EasePluginImportMedia* _tmp0_;
#line 219 "ease-plugin-import-service.vala"
			image = (_tmp0_ = (EasePluginImportMedia*) gee_deque_poll_head ((GeeDeque*) self->priv->images_list), _g_object_unref0 (image), _tmp0_);
#line 446 "ease-plugin-import-service.c"
		}
		__finally22:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_images_list);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (image);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = NULL;
#line 222 "ease-plugin-import-service.vala"
	if (image->thumb_link == NULL) {
#line 223 "ease-plugin-import-service.vala"
		_tmp1_ = image->file_link;
#line 464 "ease-plugin-import-service.c"
	} else {
#line 224 "ease-plugin-import-service.vala"
		_tmp1_ = image->thumb_link;
#line 468 "ease-plugin-import-service.c"
	}
#line 222 "ease-plugin-import-service.vala"
	pixbuf = ease_plugin_import_service_gdk_pixbuf_from_uri (self, _tmp1_);
#line 472 "ease-plugin-import-service.c"
	memset (&tree_itr, 0, sizeof (GtkTreeIter));
	{
		g_static_rec_mutex_lock (&self->priv->__lock_model);
		{
#line 229 "ease-plugin-import-service.vala"
			gtk_list_store_append (self->model, &tree_itr);
#line 230 "ease-plugin-import-service.vala"
			gtk_list_store_set (self->model, &tree_itr, EASE_PLUGIN_IMPORT_SERVICE_COLUMN_PIXBUF, pixbuf, EASE_PLUGIN_IMPORT_SERVICE_COLUMN_TEXT, image->title, EASE_PLUGIN_IMPORT_SERVICE_COLUMN_IMPORT_MEDIA, image, -1);
#line 481 "ease-plugin-import-service.c"
		}
		__finally23:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_model);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (image);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 236 "ease-plugin-import-service.vala"
	g_signal_emit_by_name (self, "loading-progress", (double) (1 - (gee_collection_get_size ((GeeCollection*) self->priv->images_list) / self->priv->list_size)));
#line 497 "ease-plugin-import-service.c"
	{
		g_static_rec_mutex_lock (&self->priv->__lock_images_list);
		{
#line 241 "ease-plugin-import-service.vala"
			if (gee_collection_get_size ((GeeCollection*) self->priv->images_list) > 0) {
#line 241 "ease-plugin-import-service.vala"
				ease_plugin_import_service_threaded_get_pixbufs (self);
#line 505 "ease-plugin-import-service.c"
			}
		}
		__finally24:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_images_list);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (image);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 245 "ease-plugin-import-service.vala"
	g_signal_emit_by_name (self, "loading-complete");
#line 522 "ease-plugin-import-service.c"
	result = NULL;
	_g_object_unref0 (pixbuf);
	_g_object_unref0 (image);
#line 246 "ease-plugin-import-service.vala"
	return result;
#line 528 "ease-plugin-import-service.c"
}


/**
 * Loads and returns a pixbuf from a URI. Best used threaded, to prevent 
 * lock up.
 *
 * @param uri The URI to load from.
 */
#line 255 "ease-plugin-import-service.vala"
static GdkPixbuf* ease_plugin_import_service_gdk_pixbuf_from_uri (EasePluginImportService* self, const char* uri) {
#line 540 "ease-plugin-import-service.c"
	GdkPixbuf* result = NULL;
	GFile* file;
	GFileInputStream* filestream;
	GdkPixbuf* pix;
	GError * _inner_error_ = NULL;
#line 255 "ease-plugin-import-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 255 "ease-plugin-import-service.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 257 "ease-plugin-import-service.vala"
	file = g_file_new_for_uri (uri);
#line 552 "ease-plugin-import-service.c"
	filestream = NULL;
	{
		GFileInputStream* _tmp0_;
		GFileInputStream* _tmp1_;
#line 259 "ease-plugin-import-service.vala"
		_tmp0_ = g_file_read (file, NULL, &_inner_error_);
#line 559 "ease-plugin-import-service.c"
		if (_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
#line 259 "ease-plugin-import-service.vala"
		filestream = (_tmp1_ = _tmp0_, _g_object_unref0 (filestream), _tmp1_);
#line 565 "ease-plugin-import-service.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GFileInputStream* _tmp2_;
#line 262 "ease-plugin-import-service.vala"
			filestream = (_tmp2_ = NULL, _g_object_unref0 (filestream), _tmp2_);
#line 263 "ease-plugin-import-service.vala"
			g_critical ("ease-plugin-import-service.vala:263: Couldn't read distant file : %s", e->message);
#line 579 "ease-plugin-import-service.c"
			_g_error_free0 (e);
		}
	}
	__finally25:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (filestream);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 265 "ease-plugin-import-service.vala"
	g_assert (filestream != NULL);
#line 593 "ease-plugin-import-service.c"
	pix = NULL;
	{
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
#line 269 "ease-plugin-import-service.vala"
		_tmp3_ = gdk_pixbuf_new_from_stream_at_scale ((GInputStream*) filestream, 200, 200, TRUE, NULL, &_inner_error_);
#line 600 "ease-plugin-import-service.c"
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
#line 269 "ease-plugin-import-service.vala"
		pix = (_tmp4_ = _tmp3_, _g_object_unref0 (pix), _tmp4_);
#line 606 "ease-plugin-import-service.c"
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GdkPixbuf* _tmp5_;
#line 275 "ease-plugin-import-service.vala"
			g_critical ("ease-plugin-import-service.vala:275: Couldn't create pixbuf from file:" \
" %s", e->message);
#line 276 "ease-plugin-import-service.vala"
			pix = (_tmp5_ = NULL, _g_object_unref0 (pix), _tmp5_);
#line 620 "ease-plugin-import-service.c"
			_g_error_free0 (e);
		}
	}
	__finally26:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pix);
		_g_object_unref0 (filestream);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = pix;
	_g_object_unref0 (filestream);
	_g_object_unref0 (file);
#line 278 "ease-plugin-import-service.vala"
	return result;
#line 638 "ease-plugin-import-service.c"
}


#line 28 "ease-plugin-import-service.vala"
EasePluginImportService* ease_plugin_import_service_construct (GType object_type) {
#line 644 "ease-plugin-import-service.c"
	EasePluginImportService * self;
#line 28 "ease-plugin-import-service.vala"
	self = (EasePluginImportService*) g_object_new (object_type, NULL);
#line 648 "ease-plugin-import-service.c"
	return self;
}


static void ease_plugin_import_service_class_init (EasePluginImportServiceClass * klass) {
	ease_plugin_import_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EasePluginImportServicePrivate));
	EASE_PLUGIN_IMPORT_SERVICE_CLASS (klass)->parse_data = ease_plugin_import_service_real_parse_data;
	EASE_PLUGIN_IMPORT_SERVICE_CLASS (klass)->create_proxy = ease_plugin_import_service_real_create_proxy;
	EASE_PLUGIN_IMPORT_SERVICE_CLASS (klass)->create_call = ease_plugin_import_service_real_create_call;
	EASE_PLUGIN_IMPORT_SERVICE_CLASS (klass)->extra_widget = ease_plugin_import_service_real_extra_widget;
	G_OBJECT_CLASS (klass)->finalize = ease_plugin_import_service_finalize;
	/**
	 * Emitted when the search begins.
	 */
	g_signal_new ("started", EASE_PLUGIN_TYPE_IMPORT_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	 * Emitted when the search completes.
	 */
	g_signal_new ("proxy_call_complete", EASE_PLUGIN_TYPE_IMPORT_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	 * Emitted if no results are found. This signal is the alterative to
	 * {@link loading_started}.
	 */
	g_signal_new ("no_results", EASE_PLUGIN_TYPE_IMPORT_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	 * Emitted when image previews begin downloading. This signal is the
	 * alternative to {@link no_results}.
	 */
	g_signal_new ("loading_started", EASE_PLUGIN_TYPE_IMPORT_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_OBJECT__VOID, GTK_TYPE_ICON_VIEW, 0);
	/**
	 * Emitted when progress is made in loading the image previews.
	 *
	 * @param progress The current progress.
	 */
	g_signal_new ("loading_progress", EASE_PLUGIN_TYPE_IMPORT_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	/**
	 * Emitted when the loading of image previews is complete.
	 */
	g_signal_new ("loading_complete", EASE_PLUGIN_TYPE_IMPORT_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void ease_plugin_import_service_instance_init (EasePluginImportService * self) {
	self->priv = EASE_PLUGIN_IMPORT_SERVICE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_model);
	g_static_rec_mutex_init (&self->priv->__lock_images_list);
}


static void ease_plugin_import_service_finalize (GObject* obj) {
	EasePluginImportService * self;
	self = EASE_PLUGIN_IMPORT_SERVICE (obj);
	_g_object_unref0 (self->priv->proxy);
	_g_object_unref0 (self->priv->call);
	g_static_rec_mutex_free (&self->priv->__lock_model);
	_g_object_unref0 (self->model);
	g_static_rec_mutex_free (&self->priv->__lock_images_list);
	_g_object_unref0 (self->priv->images_list);
	G_OBJECT_CLASS (ease_plugin_import_service_parent_class)->finalize (obj);
}


/**
 * Base class for an "import media" dialog that searches a website for media.
 *
 * PluginImportDialog offers a generic interface and almost entirely controls
 * the user interface for the dialog. Therefore, by using PluginImportDialog
 * to write a plugin, the author ensures that it fits in with all similar
 * plugins. PluginImportDialog also automatically manages the downloading
 * of images and image data - subclasses only need to provide a REST call,
 * and parse the response to generate a list of data.
 */
GType ease_plugin_import_service_get_type (void) {
	static volatile gsize ease_plugin_import_service_type_id__volatile = 0;
	if (g_once_init_enter (&ease_plugin_import_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EasePluginImportServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_plugin_import_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EasePluginImportService), 0, (GInstanceInitFunc) ease_plugin_import_service_instance_init, NULL };
		GType ease_plugin_import_service_type_id;
		ease_plugin_import_service_type_id = g_type_register_static (G_TYPE_OBJECT, "EasePluginImportService", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&ease_plugin_import_service_type_id__volatile, ease_plugin_import_service_type_id);
	}
	return ease_plugin_import_service_type_id__volatile;
}



static void g_cclosure_user_marshal_OBJECT__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gpointer (*GMarshalFunc_OBJECT__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_OBJECT__VOID callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gpointer v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_OBJECT__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_take_object (return_value, v_return);
}



