/* ease-temp.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-temp.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <unistd.h>


#define EASE_TYPE_TEMP (ease_temp_get_type ())
#define EASE_TEMP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_TEMP, EaseTemp))
#define EASE_TEMP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_TEMP, EaseTempClass))
#define EASE_IS_TEMP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_TEMP))
#define EASE_IS_TEMP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_TEMP))
#define EASE_TEMP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_TEMP, EaseTempClass))

typedef struct _EaseTemp EaseTemp;
typedef struct _EaseTempClass EaseTempClass;
typedef struct _EaseTempPrivate EaseTempPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _EaseTemp {
	GObject parent_instance;
	EaseTempPrivate * priv;
};

struct _EaseTempClass {
	GObjectClass parent_class;
};


static gint ease_temp_index;
static gint ease_temp_index = 0;
static char* ease_temp_m_temp;
static char* ease_temp_m_temp = NULL;
static GeeLinkedList* ease_temp_m_dirs;
static GeeLinkedList* ease_temp_m_dirs = NULL;
static gpointer ease_temp_parent_class = NULL;

GType ease_temp_get_type (void) G_GNUC_CONST;
enum  {
	EASE_TEMP_DUMMY_PROPERTY
};
#define EASE_TEMP_ARCHIVE_BUFFER 4096
#define EASE_TEMP_TEMP_DIR "ease"
#define EASE_TEMP_THEME_DIR "themes"
#define EASE_TEMP_IMG_DIR "svg"
#define EASE_TEMP_UI_DIR "ui"
char* ease_temp_request (GError** error);
gboolean ease_temp_exists (gint dir, const char* tmp);
static const char* ease_temp_get_temp (void);
static GeeLinkedList* ease_temp_get_dirs (void);
char* ease_temp_request_str (const char* str, GError** error);
void ease_temp_clean (void);
void ease_recursive_delete (const char* path, GError** error);
EaseTemp* ease_temp_new (void);
EaseTemp* ease_temp_construct (GType object_type);
static void ease_temp_finalize (GObject* obj);
static void ease_temp_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);



/**
 * Requests a temporary directory.
 *
 * request() creates a temporary directory (typically under /tmp/ease).
 * Each directory has a integer name, incrementing by one for each new
 * directory.
 */
#line 70 "ease-temp.vala"
char* ease_temp_request (GError** error) {
#line 95 "ease-temp.c"
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	char* tmp;
	GFile* file;
	GError * _inner_error_ = NULL;
#line 73 "ease-temp.vala"
	while (TRUE) {
#line 73 "ease-temp.vala"
		if (!ease_temp_exists (ease_temp_index, ease_temp_get_temp ())) {
#line 73 "ease-temp.vala"
			break;
#line 108 "ease-temp.c"
		}
#line 75 "ease-temp.vala"
		ease_temp_index++;
#line 112 "ease-temp.c"
	}
#line 79 "ease-temp.vala"
	tmp = (_tmp1_ = g_build_filename (ease_temp_get_temp (), _tmp0_ = g_strdup_printf ("%i", ease_temp_index), NULL), _g_free0 (_tmp0_), _tmp1_);
#line 82 "ease-temp.vala"
	gee_deque_offer_head ((GeeDeque*) ease_temp_get_dirs (), tmp);
#line 85 "ease-temp.vala"
	file = g_file_new_for_path (tmp);
#line 86 "ease-temp.vala"
	g_file_make_directory_with_parents (file, NULL, &_inner_error_);
#line 122 "ease-temp.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		_g_free0 (tmp);
		return NULL;
	}
	result = tmp;
	_g_object_unref0 (file);
#line 88 "ease-temp.vala"
	return result;
#line 133 "ease-temp.c"
}


/**
 * Requests a temporary directory with a specific name.
 *
 * This function is useful for debugging and cleanliness purposes.
 * However, be sure to use unique names. Do not use "integer" strings,
 * as those could overlap with directories created through request().
 *
 * If the directory name is taken, "-0, "-1", etc. will be appended until
 * an available directory is found.
 *
 * @param str The directory name to request.
 */
#line 103 "ease-temp.vala"
char* ease_temp_request_str (const char* str, GError** error) {
#line 151 "ease-temp.c"
	char* result = NULL;
	char* tmp;
	GFile* file;
	GError * _inner_error_ = NULL;
#line 103 "ease-temp.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 106 "ease-temp.vala"
	tmp = g_build_filename (ease_temp_get_temp (), str, NULL);
#line 107 "ease-temp.vala"
	file = g_file_new_for_path (tmp);
#line 108 "ease-temp.vala"
	if (g_file_query_exists (file, NULL)) {
#line 164 "ease-temp.c"
		{
			gint i;
#line 110 "ease-temp.vala"
			i = 0;
#line 169 "ease-temp.c"
			{
				gboolean _tmp0_;
#line 110 "ease-temp.vala"
				_tmp0_ = TRUE;
#line 110 "ease-temp.vala"
				while (TRUE) {
#line 176 "ease-temp.c"
					char* _tmp1_;
					char* _tmp2_;
					char* _tmp3_;
					char* _tmp4_;
					GFile* _tmp5_;
#line 110 "ease-temp.vala"
					if (!_tmp0_) {
#line 110 "ease-temp.vala"
						i++;
#line 186 "ease-temp.c"
					}
#line 110 "ease-temp.vala"
					_tmp0_ = FALSE;
#line 110 "ease-temp.vala"
					if (!g_file_query_exists (file, NULL)) {
#line 110 "ease-temp.vala"
						break;
#line 194 "ease-temp.c"
					}
#line 112 "ease-temp.vala"
					tmp = (_tmp4_ = g_build_filename (ease_temp_get_temp (), _tmp3_ = g_strconcat (_tmp1_ = g_strconcat (str, "-", NULL), _tmp2_ = g_strdup_printf ("%i", i), NULL), NULL), _g_free0 (tmp), _tmp4_);
#line 198 "ease-temp.c"
					_g_free0 (_tmp3_);
					_g_free0 (_tmp2_);
					_g_free0 (_tmp1_);
#line 113 "ease-temp.vala"
					file = (_tmp5_ = g_file_new_for_path (tmp), _g_object_unref0 (file), _tmp5_);
#line 204 "ease-temp.c"
				}
			}
		}
	}
#line 118 "ease-temp.vala"
	gee_deque_offer_head ((GeeDeque*) ease_temp_get_dirs (), tmp);
#line 121 "ease-temp.vala"
	g_file_make_directory_with_parents (file, NULL, &_inner_error_);
#line 213 "ease-temp.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		_g_free0 (tmp);
		return NULL;
	}
	result = tmp;
	_g_object_unref0 (file);
#line 123 "ease-temp.vala"
	return result;
#line 224 "ease-temp.c"
}


/**
 * Deletes all temporary directories created by this instance of Ease.
 * Call when exiting.
 */
#line 130 "ease-temp.vala"
void ease_temp_clean (void) {
#line 234 "ease-temp.c"
	char* dir;
	char* tmp;
	GError * _inner_error_ = NULL;
#line 132 "ease-temp.vala"
	if (ease_temp_get_dirs () == NULL) {
#line 132 "ease-temp.vala"
		return;
#line 242 "ease-temp.c"
	}
	dir = NULL;
#line 135 "ease-temp.vala"
	while (TRUE) {
#line 247 "ease-temp.c"
		char* _tmp0_;
#line 135 "ease-temp.vala"
		if (!((dir = (_tmp0_ = (char*) gee_deque_poll_head ((GeeDeque*) ease_temp_get_dirs ()), _g_free0 (dir), _tmp0_)) != NULL)) {
#line 135 "ease-temp.vala"
			break;
#line 253 "ease-temp.c"
		}
		{
#line 137 "ease-temp.vala"
			ease_recursive_delete (dir, &_inner_error_);
#line 258 "ease-temp.c"
			if (_inner_error_ != NULL) {
				goto __catch32_g_error;
			}
		}
		goto __finally32;
		__catch32_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
#line 140 "ease-temp.vala"
				g_debug ("ease-temp.vala:140: %s", e->message);
#line 272 "ease-temp.c"
				_g_error_free0 (e);
			}
		}
		__finally32:
		if (_inner_error_ != NULL) {
			_g_free0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 148 "ease-temp.vala"
	tmp = g_build_filename (g_get_tmp_dir (), EASE_TEMP_TEMP_DIR, NULL);
#line 286 "ease-temp.c"
	{
		GFile* file;
		GFile* _tmp1_;
#line 152 "ease-temp.vala"
		file = g_file_new_for_path (ease_temp_get_temp ());
#line 153 "ease-temp.vala"
		g_file_delete (file, NULL, &_inner_error_);
#line 294 "ease-temp.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch33_g_error;
		}
#line 156 "ease-temp.vala"
		file = (_tmp1_ = g_file_new_for_path (tmp), _g_object_unref0 (file), _tmp1_);
#line 157 "ease-temp.vala"
		g_file_delete (file, NULL, &_inner_error_);
#line 303 "ease-temp.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch33_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally33:
	if (_inner_error_ != NULL) {
		_g_free0 (tmp);
		_g_free0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (tmp);
	_g_free0 (dir);
}


/**
 * Checks if a temporary directory already exists.
 *
 * @param dir The index of the directory.
 * @param tmp The parent temporary directory (typically /tmp/ease).
 */
#line 168 "ease-temp.vala"
gboolean ease_temp_exists (gint dir, const char* tmp) {
#line 341 "ease-temp.c"
	gboolean result = FALSE;
	char* _tmp0_;
	char* _tmp1_;
	char* dir_tmp;
	GFile* file;
#line 168 "ease-temp.vala"
	g_return_val_if_fail (tmp != NULL, FALSE);
#line 170 "ease-temp.vala"
	dir_tmp = (_tmp1_ = g_build_filename (tmp, _tmp0_ = g_strdup_printf ("%i", dir), NULL), _g_free0 (_tmp0_), _tmp1_);
#line 171 "ease-temp.vala"
	file = g_file_new_for_path (dir_tmp);
#line 353 "ease-temp.c"
	result = g_file_query_exists (file, NULL);
	_g_object_unref0 (file);
	_g_free0 (dir_tmp);
#line 173 "ease-temp.vala"
	return result;
#line 359 "ease-temp.c"
}


#line 31 "ease-temp.vala"
EaseTemp* ease_temp_construct (GType object_type) {
#line 365 "ease-temp.c"
	EaseTemp * self;
#line 31 "ease-temp.vala"
	self = (EaseTemp*) g_object_new (object_type, NULL);
#line 369 "ease-temp.c"
	return self;
}


#line 31 "ease-temp.vala"
EaseTemp* ease_temp_new (void) {
#line 31 "ease-temp.vala"
	return ease_temp_construct (EASE_TYPE_TEMP);
#line 378 "ease-temp.c"
}


static const char* ease_temp_get_temp (void) {
	const char* result;
	char* _tmp0_;
	char* _tmp1_;
#line 40 "ease-temp.vala"
	if (ease_temp_m_temp != NULL) {
#line 388 "ease-temp.c"
		result = ease_temp_m_temp;
#line 40 "ease-temp.vala"
		return result;
#line 392 "ease-temp.c"
	}
#line 41 "ease-temp.vala"
	ease_temp_m_temp = (_tmp1_ = g_build_filename (g_get_tmp_dir (), EASE_TEMP_TEMP_DIR, _tmp0_ = g_strdup_printf ("%i", (gint) getpid ()), NULL), _g_free0 (ease_temp_m_temp), _tmp1_);
#line 396 "ease-temp.c"
	_g_free0 (_tmp0_);
	result = ease_temp_m_temp;
#line 43 "ease-temp.vala"
	return result;
#line 401 "ease-temp.c"
}


static GeeLinkedList* ease_temp_get_dirs (void) {
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
#line 52 "ease-temp.vala"
	if (ease_temp_m_dirs != NULL) {
#line 410 "ease-temp.c"
		result = ease_temp_m_dirs;
#line 52 "ease-temp.vala"
		return result;
#line 414 "ease-temp.c"
	}
	result = ease_temp_m_dirs = (_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (ease_temp_m_dirs), _tmp0_);
#line 53 "ease-temp.vala"
	return result;
#line 419 "ease-temp.c"
}


static void ease_temp_class_init (EaseTempClass * klass) {
	ease_temp_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = ease_temp_get_property;
	G_OBJECT_CLASS (klass)->finalize = ease_temp_finalize;
}


static void ease_temp_instance_init (EaseTemp * self) {
}


static void ease_temp_finalize (GObject* obj) {
	EaseTemp * self;
	self = EASE_TEMP (obj);
	G_OBJECT_CLASS (ease_temp_parent_class)->finalize (obj);
}


/**
 * Creates temporary directories for use by Ease.
 *
 * Temporary directories are (typically) stored in /tmp/ease/[PID]/[INDEX],
 * where [PID] is the process ID and [INDEX] increments with each new directory.
 * Ease automatically cleans up temporary directories when exiting, and will
 * remove /tmp/ease if no other folders are being used in it.
 *
 * Code that is internal to Ease can also use the request_str() function, which
 * allows a named directory. This is for debugging and cleanliness purposes
 * only - other than the directory name, functionality is identical to
 * request().
 */
GType ease_temp_get_type (void) {
	static volatile gsize ease_temp_type_id__volatile = 0;
	if (g_once_init_enter (&ease_temp_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseTempClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_temp_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseTemp), 0, (GInstanceInitFunc) ease_temp_instance_init, NULL };
		GType ease_temp_type_id;
		ease_temp_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseTemp", &g_define_type_info, 0);
		g_once_init_leave (&ease_temp_type_id__volatile, ease_temp_type_id);
	}
	return ease_temp_type_id__volatile;
}


static void ease_temp_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseTemp * self;
	self = EASE_TEMP (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




