/* ease-text-actor.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-text-actor.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>


#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;
typedef struct _EaseActorPrivate EaseActorPrivate;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_TEXT_ACTOR (ease_text_actor_get_type ())
#define EASE_TEXT_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_TEXT_ACTOR, EaseTextActor))
#define EASE_TEXT_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_TEXT_ACTOR, EaseTextActorClass))
#define EASE_IS_TEXT_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_TEXT_ACTOR))
#define EASE_IS_TEXT_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_TEXT_ACTOR))
#define EASE_TEXT_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_TEXT_ACTOR, EaseTextActorClass))

typedef struct _EaseTextActor EaseTextActor;
typedef struct _EaseTextActorClass EaseTextActorClass;
typedef struct _EaseTextActorPrivate EaseTextActorPrivate;

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_UNDO_ACTION (ease_undo_action_get_type ())
#define EASE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoAction))
#define EASE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))
#define EASE_IS_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ACTION))
#define EASE_IS_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ACTION))
#define EASE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))

typedef struct _EaseUndoAction EaseUndoAction;
typedef struct _EaseUndoActionClass EaseUndoActionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define EASE_TYPE_TEXT_ELEMENT (ease_text_element_get_type ())
#define EASE_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElement))
#define EASE_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))
#define EASE_IS_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_TEXT_ELEMENT))
#define EASE_IS_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_TEXT_ELEMENT))
#define EASE_TEXT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))

typedef struct _EaseTextElement EaseTextElement;
typedef struct _EaseTextElementClass EaseTextElementClass;

#define EASE_TYPE_COLOR (ease_color_get_type ())
#define EASE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_COLOR, EaseColor))
#define EASE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_COLOR, EaseColorClass))
#define EASE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_COLOR))
#define EASE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_COLOR))
#define EASE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_COLOR, EaseColorClass))

typedef struct _EaseColor EaseColor;
typedef struct _EaseColorClass EaseColorClass;
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;

#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseActor {
	ClutterGroup parent_instance;
	EaseActorPrivate * priv;
	ClutterActor* contents;
	EaseElement* element;
	EaseActorContext context;
	gboolean is_background;
};

struct _EaseActorClass {
	ClutterGroupClass parent_class;
	void (*edit) (EaseActor* self, GtkWidget* sender);
	void (*end_edit) (EaseActor* self, GtkWidget* sender);
};

struct _EaseTextActor {
	EaseActor parent_instance;
	EaseTextActorPrivate * priv;
};

struct _EaseTextActorClass {
	EaseActorClass parent_class;
};

struct _EaseTextActorPrivate {
	EaseUndoAction* undo_action;
	char* original_text;
};

struct _Block11Data {
	int _ref_count_;
	EaseTextActor * self;
	ClutterText* text;
	EaseTextElement* e;
};

struct _Block12Data {
	int _ref_count_;
	EaseTextActor * self;
	ClutterText* text;
	GtkWidget* sender;
};

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};


static gpointer ease_text_actor_parent_class = NULL;

GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
GType ease_text_actor_get_type (void) G_GNUC_CONST;
GType ease_undo_item_get_type (void) G_GNUC_CONST;
GType ease_undo_action_get_type (void) G_GNUC_CONST;
#define EASE_TEXT_ACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_TEXT_ACTOR, EaseTextActorPrivate))
enum  {
	EASE_TEXT_ACTOR_DUMMY_PROPERTY
};
#define EASE_TEXT_ACTOR_SELECTION_ALPHA ((guchar) 200)
GType ease_text_element_get_type (void) G_GNUC_CONST;
EaseTextActor* ease_text_actor_new (EaseTextElement* e, EaseActorContext c);
EaseTextActor* ease_text_actor_construct (GType object_type, EaseTextElement* e, EaseActorContext c);
EaseActor* ease_actor_construct (GType object_type, EaseElement* e, EaseActorContext c);
GType ease_color_get_type (void) G_GNUC_CONST;
EaseColor* ease_text_element_get_color (EaseTextElement* self);
void ease_color_get_clutter (EaseColor* self, ClutterColor* result);
PangoAlignment ease_text_element_get_text_align (EaseTextElement* self);
PangoFontDescription* ease_text_element_get_font_description (EaseTextElement* self);
const char* ease_text_element_get_display_text (EaseTextElement* self);
float ease_element_get_width (EaseElement* self);
float ease_element_get_height (EaseElement* self);
float ease_element_get_x (EaseElement* self);
float ease_element_get_y (EaseElement* self);
static void _lambda7_ (GObject* sender, GParamSpec* spec, Block11Data* _data11_);
static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda8_ (GObject* sender, GParamSpec* spec, Block11Data* _data11_);
static void __lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda9_ (GObject* sender, GParamSpec* spec, Block11Data* _data11_);
static void __lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda10_ (GObject* sender, GParamSpec* spec, Block11Data* _data11_);
static void __lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda11_ (GObject* sender, GParamSpec* spec, Block11Data* _data11_);
static void __lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void ease_text_actor_real_edit (EaseActor* base, GtkWidget* sender);
static void ease_text_actor_text_changed (EaseTextActor* self, ClutterText* sender);
static void _ease_text_actor_text_changed_clutter_text_text_changed (ClutterText* _sender, gpointer self);
static void ease_text_actor_text_activate (EaseTextActor* self, ClutterText* sender);
static void _ease_text_actor_text_activate_clutter_text_activate (ClutterText* _sender, gpointer self);
gboolean ease_element_get_has_been_edited (EaseElement* self);
EaseUndoAction* ease_undo_action_new (GObject* obj, const char* prop);
EaseUndoAction* ease_undo_action_construct (GType object_type, GObject* obj, const char* prop);
void ease_undo_action_add (EaseUndoAction* self, GObject* obj, const char* prop);
const char* ease_text_element_get_text (EaseTextElement* self);
static void _lambda12_ (EaseUndoAction* action, Block12Data* _data12_);
void ease_actor_end_edit (EaseActor* self, GtkWidget* sender);
static void __lambda12__ease_undo_item_pre_apply (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
static void ease_text_actor_real_end_edit (EaseActor* base, GtkWidget* sender);
void ease_element_set_has_been_edited (EaseElement* self, gboolean value);
GType ease_undo_source_get_type (void) G_GNUC_CONST;
void ease_text_element_set_text (EaseTextElement* self, const char* value);
GType ease_slide_get_type (void) G_GNUC_CONST;
EaseSlide* ease_element_get_parent (EaseElement* self);
static void ease_text_actor_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * Instantiates a new TextActor from an Element.
 * 
 * TextActor uses {@link Clutter.Text} for rendering.
 *
 * @param e The represented element.
 * @param c The context of this Actor (Presentation, Sidebar, Editor)
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 71 "ease-text-actor.vala"
static void _lambda7_ (GObject* sender, GParamSpec* spec, Block11Data* _data11_) {
#line 264 "ease-text-actor.c"
	EaseTextActor * self;
	GObject* _tmp0_;
	ClutterColor _tmp1_ = {0};
	ClutterColor _tmp2_;
	self = _data11_->self;
#line 71 "ease-text-actor.vala"
	g_return_if_fail (sender != NULL);
#line 71 "ease-text-actor.vala"
	g_return_if_fail (spec != NULL);
#line 72 "ease-text-actor.vala"
	clutter_text_set_color (_data11_->text, (_tmp2_ = (ease_color_get_clutter (ease_text_element_get_color ((_tmp0_ = sender, EASE_IS_TEXT_ELEMENT (_tmp0_) ? ((EaseTextElement*) _tmp0_) : NULL)), &_tmp1_), _tmp1_), &_tmp2_));
#line 276 "ease-text-actor.c"
}


#line 71 "ease-text-actor.vala"
static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 282 "ease-text-actor.c"
	_lambda7_ (_sender, pspec, self);
}


#line 75 "ease-text-actor.vala"
static void _lambda8_ (GObject* sender, GParamSpec* spec, Block11Data* _data11_) {
#line 289 "ease-text-actor.c"
	EaseTextActor * self;
	PangoFontDescription* _tmp0_;
	self = _data11_->self;
#line 75 "ease-text-actor.vala"
	g_return_if_fail (sender != NULL);
#line 75 "ease-text-actor.vala"
	g_return_if_fail (spec != NULL);
#line 76 "ease-text-actor.vala"
	clutter_text_set_font_name (_data11_->text, pango_font_description_to_string (_tmp0_ = ease_text_element_get_font_description (_data11_->e)));
#line 299 "ease-text-actor.c"
	_pango_font_description_free0 (_tmp0_);
}


#line 75 "ease-text-actor.vala"
static void __lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 306 "ease-text-actor.c"
	_lambda8_ (_sender, pspec, self);
}


#line 79 "ease-text-actor.vala"
static void _lambda9_ (GObject* sender, GParamSpec* spec, Block11Data* _data11_) {
#line 313 "ease-text-actor.c"
	EaseTextActor * self;
	self = _data11_->self;
#line 79 "ease-text-actor.vala"
	g_return_if_fail (sender != NULL);
#line 79 "ease-text-actor.vala"
	g_return_if_fail (spec != NULL);
#line 80 "ease-text-actor.vala"
	clutter_text_set_line_alignment (_data11_->text, ease_text_element_get_text_align (_data11_->e));
#line 322 "ease-text-actor.c"
}


#line 79 "ease-text-actor.vala"
static void __lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 328 "ease-text-actor.c"
	_lambda9_ (_sender, pspec, self);
}


#line 83 "ease-text-actor.vala"
static void _lambda10_ (GObject* sender, GParamSpec* spec, Block11Data* _data11_) {
#line 335 "ease-text-actor.c"
	EaseTextActor * self;
	ClutterColor _tmp0_ = {0};
	ClutterColor _tmp1_;
	self = _data11_->self;
#line 83 "ease-text-actor.vala"
	g_return_if_fail (sender != NULL);
#line 83 "ease-text-actor.vala"
	g_return_if_fail (spec != NULL);
#line 84 "ease-text-actor.vala"
	clutter_text_set_color (_data11_->text, (_tmp1_ = (ease_color_get_clutter (ease_text_element_get_color (_data11_->e), &_tmp0_), _tmp0_), &_tmp1_));
#line 346 "ease-text-actor.c"
}


#line 83 "ease-text-actor.vala"
static void __lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 352 "ease-text-actor.c"
	_lambda10_ (_sender, pspec, self);
}


#line 87 "ease-text-actor.vala"
static void _lambda11_ (GObject* sender, GParamSpec* spec, Block11Data* _data11_) {
#line 359 "ease-text-actor.c"
	EaseTextActor * self;
	self = _data11_->self;
#line 87 "ease-text-actor.vala"
	g_return_if_fail (sender != NULL);
#line 87 "ease-text-actor.vala"
	g_return_if_fail (spec != NULL);
#line 88 "ease-text-actor.vala"
	if (!clutter_text_get_editable (_data11_->text)) {
#line 368 "ease-text-actor.c"
		EaseElement* _tmp0_;
#line 90 "ease-text-actor.vala"
		clutter_text_set_markup (_data11_->text, ease_text_element_get_display_text ((_tmp0_ = ((EaseActor*) self)->element, EASE_IS_TEXT_ELEMENT (_tmp0_) ? ((EaseTextElement*) _tmp0_) : NULL)));
#line 372 "ease-text-actor.c"
	}
}


#line 87 "ease-text-actor.vala"
static void __lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 379 "ease-text-actor.c"
	_lambda11_ (_sender, pspec, self);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->text);
		_g_object_unref0 (_data11_->e);
		g_slice_free (Block11Data, _data11_);
	}
}


#line 48 "ease-text-actor.vala"
EaseTextActor* ease_text_actor_construct (GType object_type, EaseTextElement* e, EaseActorContext c) {
#line 402 "ease-text-actor.c"
	EaseTextActor * self;
	Block11Data* _data11_;
	ClutterActor* _tmp0_;
	ClutterColor _tmp1_ = {0};
	ClutterColor _tmp2_;
	PangoFontDescription* _tmp3_;
#line 48 "ease-text-actor.vala"
	g_return_val_if_fail (e != NULL, NULL);
#line 411 "ease-text-actor.c"
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->e = _g_object_ref0 (e);
#line 50 "ease-text-actor.vala"
	_data11_->self = g_object_ref (self = (EaseTextActor*) ease_actor_construct (object_type, (EaseElement*) _data11_->e, c));
#line 417 "ease-text-actor.c"
	_data11_->text = g_object_ref_sink ((ClutterText*) clutter_text_new ());
#line 53 "ease-text-actor.vala"
	((EaseActor*) self)->contents = (_tmp0_ = _g_object_ref0 ((ClutterActor*) _data11_->text), _g_object_unref0 (((EaseActor*) self)->contents), _tmp0_);
#line 56 "ease-text-actor.vala"
	clutter_text_set_use_markup (_data11_->text, TRUE);
#line 57 "ease-text-actor.vala"
	clutter_text_set_line_wrap (_data11_->text, TRUE);
#line 58 "ease-text-actor.vala"
	clutter_text_set_line_wrap_mode (_data11_->text, PANGO_WRAP_WORD_CHAR);
#line 59 "ease-text-actor.vala"
	clutter_text_set_color (_data11_->text, (_tmp2_ = (ease_color_get_clutter (ease_text_element_get_color (_data11_->e), &_tmp1_), _tmp1_), &_tmp2_));
#line 60 "ease-text-actor.vala"
	clutter_text_set_line_alignment (_data11_->text, ease_text_element_get_text_align (_data11_->e));
#line 61 "ease-text-actor.vala"
	clutter_text_set_font_name (_data11_->text, pango_font_description_to_string (_tmp3_ = ease_text_element_get_font_description (_data11_->e)));
#line 433 "ease-text-actor.c"
	_pango_font_description_free0 (_tmp3_);
#line 62 "ease-text-actor.vala"
	clutter_text_set_markup (_data11_->text, ease_text_element_get_display_text (_data11_->e));
#line 64 "ease-text-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self, ((EaseActor*) self)->contents);
#line 65 "ease-text-actor.vala"
	clutter_actor_set_width (((EaseActor*) self)->contents, ease_element_get_width ((EaseElement*) _data11_->e));
#line 66 "ease-text-actor.vala"
	clutter_actor_set_height (((EaseActor*) self)->contents, ease_element_get_height ((EaseElement*) _data11_->e));
#line 67 "ease-text-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self, ease_element_get_x ((EaseElement*) _data11_->e));
#line 68 "ease-text-actor.vala"
	clutter_actor_set_y ((ClutterActor*) self, ease_element_get_y ((EaseElement*) _data11_->e));
#line 71 "ease-text-actor.vala"
	g_signal_connect_data ((GObject*) _data11_->e, "notify::color", (GCallback) __lambda7__g_object_notify, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 75 "ease-text-actor.vala"
	g_signal_connect_data ((GObject*) _data11_->e, "notify::font-description", (GCallback) __lambda8__g_object_notify, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 79 "ease-text-actor.vala"
	g_signal_connect_data ((GObject*) _data11_->e, "notify::text-align", (GCallback) __lambda9__g_object_notify, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 83 "ease-text-actor.vala"
	g_signal_connect_data ((GObject*) _data11_->e, "notify::color", (GCallback) __lambda10__g_object_notify, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 87 "ease-text-actor.vala"
	g_signal_connect_data ((GObject*) _data11_->e, "notify::text", (GCallback) __lambda11__g_object_notify, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 457 "ease-text-actor.c"
	block11_data_unref (_data11_);
	return self;
}


#line 48 "ease-text-actor.vala"
EaseTextActor* ease_text_actor_new (EaseTextElement* e, EaseActorContext c) {
#line 48 "ease-text-actor.vala"
	return ease_text_actor_construct (EASE_TYPE_TEXT_ACTOR, e, c);
#line 467 "ease-text-actor.c"
}


/**
 * {@inheritDoc}
 */
#line 174 "ease-text-actor.vala"
static void _ease_text_actor_text_changed_clutter_text_text_changed (ClutterText* _sender, gpointer self) {
#line 476 "ease-text-actor.c"
	ease_text_actor_text_changed (self, _sender);
}


#line 183 "ease-text-actor.vala"
static void _ease_text_actor_text_activate_clutter_text_activate (ClutterText* _sender, gpointer self) {
#line 483 "ease-text-actor.c"
	ease_text_actor_text_activate (self, _sender);
}


#line 132 "ease-text-actor.vala"
static void _lambda12_ (EaseUndoAction* action, Block12Data* _data12_) {
#line 490 "ease-text-actor.c"
	EaseTextActor * self;
	self = _data12_->self;
#line 132 "ease-text-actor.vala"
	g_return_if_fail (action != NULL);
#line 133 "ease-text-actor.vala"
	if (clutter_text_get_editable (_data12_->text)) {
#line 133 "ease-text-actor.vala"
		ease_actor_end_edit ((EaseActor*) self, _data12_->sender);
#line 499 "ease-text-actor.c"
	}
}


#line 132 "ease-text-actor.vala"
static void __lambda12__ease_undo_item_pre_apply (EaseUndoItem* _sender, EaseUndoAction* sender, gpointer self) {
#line 506 "ease-text-actor.c"
	_lambda12_ (sender, self);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		_g_object_unref0 (_data12_->self);
		_g_object_unref0 (_data12_->text);
		_g_object_unref0 (_data12_->sender);
		g_slice_free (Block12Data, _data12_);
	}
}


#line 98 "ease-text-actor.vala"
static void ease_text_actor_real_edit (EaseActor* base, GtkWidget* sender) {
#line 529 "ease-text-actor.c"
	EaseTextActor * self;
	Block12Data* _data12_;
	ClutterActor* _tmp0_;
	ClutterColor _tmp1_ = {0};
	ClutterColor _tmp2_ = {0};
	ClutterColor _tmp3_ = {0};
	ClutterColor _tmp4_ = {0};
	ClutterColor _tmp5_;
	EaseUndoAction* _tmp6_;
	EaseElement* _tmp7_;
	char* _tmp8_;
	self = (EaseTextActor*) base;
#line 98 "ease-text-actor.vala"
	g_return_if_fail (sender != NULL);
#line 544 "ease-text-actor.c"
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_data12_->sender = _g_object_ref0 (sender);
	_data12_->text = _g_object_ref0 ((_tmp0_ = ((EaseActor*) self)->contents, CLUTTER_IS_TEXT (_tmp0_) ? ((ClutterText*) _tmp0_) : NULL));
#line 102 "ease-text-actor.vala"
	clutter_text_set_editable (_data12_->text, TRUE);
#line 103 "ease-text-actor.vala"
	clutter_actor_set_reactive ((ClutterActor*) _data12_->text, TRUE);
#line 104 "ease-text-actor.vala"
	clutter_text_set_activatable (_data12_->text, TRUE);
#line 105 "ease-text-actor.vala"
	g_signal_connect_object (_data12_->text, "text-changed", (GCallback) _ease_text_actor_text_changed_clutter_text_text_changed, self, 0);
#line 106 "ease-text-actor.vala"
	g_signal_connect_object (_data12_->text, "activate", (GCallback) _ease_text_actor_text_activate_clutter_text_activate, self, 0);
#line 109 "ease-text-actor.vala"
	clutter_stage_set_key_focus (CLUTTER_STAGE (clutter_actor_get_stage ((ClutterActor*) self)), (ClutterActor*) _data12_->text);
#line 110 "ease-text-actor.vala"
	gtk_widget_grab_focus (_data12_->sender);
#line 113 "ease-text-actor.vala"
	clutter_text_set_selection_color (_data12_->text, (_tmp5_ = (_tmp4_.red = (guchar) (255 - (clutter_text_get_color (_data12_->text, &_tmp1_), _tmp1_.red)), _tmp4_.green = (guchar) (255 - (clutter_text_get_color (_data12_->text, &_tmp2_), _tmp2_.green)), _tmp4_.blue = (guchar) (255 - (clutter_text_get_color (_data12_->text, &_tmp3_), _tmp3_.blue)), _tmp4_.alpha = EASE_TEXT_ACTOR_SELECTION_ALPHA, _tmp4_), &_tmp5_));
#line 119 "ease-text-actor.vala"
	if (!ease_element_get_has_been_edited (((EaseActor*) self)->element)) {
#line 121 "ease-text-actor.vala"
		clutter_text_set_text (_data12_->text, "");
#line 570 "ease-text-actor.c"
	}
#line 125 "ease-text-actor.vala"
	self->priv->undo_action = (_tmp6_ = ease_undo_action_new ((GObject*) ((EaseActor*) self)->element, "has-been-edited"), _g_object_unref0 (self->priv->undo_action), _tmp6_);
#line 128 "ease-text-actor.vala"
	ease_undo_action_add (self->priv->undo_action, (GObject*) ((EaseActor*) self)->element, "text");
#line 129 "ease-text-actor.vala"
	self->priv->original_text = (_tmp8_ = g_strdup (ease_text_element_get_text ((_tmp7_ = ((EaseActor*) self)->element, EASE_IS_TEXT_ELEMENT (_tmp7_) ? ((EaseTextElement*) _tmp7_) : NULL))), _g_free0 (self->priv->original_text), _tmp8_);
#line 132 "ease-text-actor.vala"
	g_signal_connect_data ((EaseUndoItem*) self->priv->undo_action, "pre-apply", (GCallback) __lambda12__ease_undo_item_pre_apply, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
#line 580 "ease-text-actor.c"
	block12_data_unref (_data12_);
}


/**
 * {@inheritDoc}
 */
#line 140 "ease-text-actor.vala"
static void ease_text_actor_real_end_edit (EaseActor* base, GtkWidget* sender) {
#line 590 "ease-text-actor.c"
	EaseTextActor * self;
	ClutterActor* _tmp0_;
	ClutterText* text;
	guint _tmp1_;
	guint _tmp2_;
	gboolean _tmp3_ = FALSE;
	EaseElement* _tmp5_;
	self = (EaseTextActor*) base;
#line 140 "ease-text-actor.vala"
	g_return_if_fail (sender != NULL);
#line 143 "ease-text-actor.vala"
	clutter_stage_set_key_focus (CLUTTER_STAGE (clutter_actor_get_stage ((ClutterActor*) self)), NULL);
#line 146 "ease-text-actor.vala"
	text = _g_object_ref0 ((_tmp0_ = ((EaseActor*) self)->contents, CLUTTER_IS_TEXT (_tmp0_) ? ((ClutterText*) _tmp0_) : NULL));
#line 147 "ease-text-actor.vala"
	clutter_text_set_editable (text, FALSE);
#line 148 "ease-text-actor.vala"
	clutter_actor_set_reactive ((ClutterActor*) text, FALSE);
#line 149 "ease-text-actor.vala"
	clutter_text_set_activatable (text, FALSE);
#line 150 "ease-text-actor.vala"
	g_signal_parse_name ("text-changed", CLUTTER_TYPE_TEXT, &_tmp1_, NULL, FALSE);
#line 150 "ease-text-actor.vala"
	g_signal_handlers_disconnect_matched (text, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_text_actor_text_changed_clutter_text_text_changed, self);
#line 151 "ease-text-actor.vala"
	g_signal_parse_name ("activate", CLUTTER_TYPE_TEXT, &_tmp2_, NULL, FALSE);
#line 151 "ease-text-actor.vala"
	g_signal_handlers_disconnect_matched (text, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _ease_text_actor_text_activate_clutter_text_activate, self);
#line 154 "ease-text-actor.vala"
	if (_vala_strcmp0 (clutter_text_get_text (text), "") == 0) {
#line 154 "ease-text-actor.vala"
		_tmp3_ = !ease_element_get_has_been_edited (((EaseActor*) self)->element);
#line 623 "ease-text-actor.c"
	} else {
#line 154 "ease-text-actor.vala"
		_tmp3_ = FALSE;
#line 627 "ease-text-actor.c"
	}
#line 154 "ease-text-actor.vala"
	if (_tmp3_) {
#line 631 "ease-text-actor.c"
		EaseElement* _tmp4_;
#line 156 "ease-text-actor.vala"
		clutter_text_set_text (text, ease_text_element_get_display_text ((_tmp4_ = ((EaseActor*) self)->element, EASE_IS_TEXT_ELEMENT (_tmp4_) ? ((EaseTextElement*) _tmp4_) : NULL)));
#line 635 "ease-text-actor.c"
	} else {
#line 160 "ease-text-actor.vala"
		ease_element_set_has_been_edited (((EaseActor*) self)->element, TRUE);
#line 639 "ease-text-actor.c"
	}
#line 164 "ease-text-actor.vala"
	if (_vala_strcmp0 (self->priv->original_text, ease_text_element_get_text ((_tmp5_ = ((EaseActor*) self)->element, EASE_IS_TEXT_ELEMENT (_tmp5_) ? ((EaseTextElement*) _tmp5_) : NULL))) != 0) {
#line 166 "ease-text-actor.vala"
		g_signal_emit_by_name ((EaseUndoSource*) ((EaseActor*) self)->element, "undo", (EaseUndoItem*) self->priv->undo_action);
#line 645 "ease-text-actor.c"
	}
	_g_object_unref0 (text);
}


/**
 * Signal handler for text editing. Updates the "text" property on the
 * linked {@link Element}.
 */
#line 174 "ease-text-actor.vala"
static void ease_text_actor_text_changed (EaseTextActor* self, ClutterText* sender) {
#line 657 "ease-text-actor.c"
	EaseElement* _tmp0_;
#line 174 "ease-text-actor.vala"
	g_return_if_fail (self != NULL);
#line 174 "ease-text-actor.vala"
	g_return_if_fail (sender != NULL);
#line 176 "ease-text-actor.vala"
	ease_text_element_set_text ((_tmp0_ = ((EaseActor*) self)->element, EASE_IS_TEXT_ELEMENT (_tmp0_) ? ((EaseTextElement*) _tmp0_) : NULL), clutter_text_get_text (sender));
#line 177 "ease-text-actor.vala"
	g_signal_emit_by_name (ease_element_get_parent (((EaseActor*) self)->element), "changed", ease_element_get_parent (((EaseActor*) self)->element));
#line 667 "ease-text-actor.c"
}


/**
 * Signal handler for text "activation", inserts a newline character.
 */
#line 183 "ease-text-actor.vala"
static void ease_text_actor_text_activate (EaseTextActor* self, ClutterText* sender) {
#line 676 "ease-text-actor.c"
	ClutterActor* _tmp0_;
#line 183 "ease-text-actor.vala"
	g_return_if_fail (self != NULL);
#line 183 "ease-text-actor.vala"
	g_return_if_fail (sender != NULL);
#line 185 "ease-text-actor.vala"
	clutter_text_insert_unichar ((_tmp0_ = ((EaseActor*) self)->contents, CLUTTER_IS_TEXT (_tmp0_) ? ((ClutterText*) _tmp0_) : NULL), (gunichar) '\n');
#line 684 "ease-text-actor.c"
}


static void ease_text_actor_class_init (EaseTextActorClass * klass) {
	ease_text_actor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseTextActorPrivate));
	EASE_ACTOR_CLASS (klass)->edit = ease_text_actor_real_edit;
	EASE_ACTOR_CLASS (klass)->end_edit = ease_text_actor_real_end_edit;
	G_OBJECT_CLASS (klass)->finalize = ease_text_actor_finalize;
}


static void ease_text_actor_instance_init (EaseTextActor * self) {
	self->priv = EASE_TEXT_ACTOR_GET_PRIVATE (self);
}


static void ease_text_actor_finalize (GObject* obj) {
	EaseTextActor * self;
	self = EASE_TEXT_ACTOR (obj);
	_g_object_unref0 (self->priv->undo_action);
	_g_free0 (self->priv->original_text);
	G_OBJECT_CLASS (ease_text_actor_parent_class)->finalize (obj);
}


/**
 * {@link Actor} for blocks of text
 * 
 * TextActor uses {@link Clutter.Text} for rendering.
 */
GType ease_text_actor_get_type (void) {
	static volatile gsize ease_text_actor_type_id__volatile = 0;
	if (g_once_init_enter (&ease_text_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseTextActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_text_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseTextActor), 0, (GInstanceInitFunc) ease_text_actor_instance_init, NULL };
		GType ease_text_actor_type_id;
		ease_text_actor_type_id = g_type_register_static (EASE_TYPE_ACTOR, "EaseTextActor", &g_define_type_info, 0);
		g_once_init_leave (&ease_text_actor_type_id__volatile, ease_text_actor_type_id);
	}
	return ease_text_actor_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




