/* Eye of Gnome image viewer - image structure and image loading
 *
 * Copyright (C) 1999 The Free Software Foundation
 *
 * Author: Federico Mena-Quintero <federico@gimp.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef IMAGE_H
#define IMAGE_H

#include <gdk-pixbuf/gdk-pixbuf.h>



/* The main image structure */
typedef struct {
	/* Reference count */
	guint ref_count;

	/* Buffer with original image data */
	GdkPixbuf *pixbuf;

	/* Color substitution tables */
	guchar *r_lut, *g_lut, *b_lut;
} Image;

Image *image_new (void);
void image_ref (Image *image);
void image_unref (Image *image);

gboolean image_load (Image *image, const char *filename);



#endif
