/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * ggv-prefs.h: GGV preferences
 *
 * Copyright (C) 2002 the Free Software Foundation
 *
 * Author: Jaka Mocnik  <jaka@gnu.org>
 */

#ifndef __GGV_PREFS_H__

#include <config.h>

#include <glib.h>
#include <gconf/gconf-client.h>

G_BEGIN_DECLS 

#define DEFAULT_WINDOW_WIDTH  640
#define DEFAULT_WINDOW_HEIGHT 480

#define DEFAULT_FILE_SEL_WIDTH   320
#define DEFAULT_FILE_SEL_HEIGHT  256

typedef void (*GgvPrefsCb)(gpointer data);

extern gchar    *ggv_print_cmd;       /* print command: must print its stdin */
extern gboolean  ggv_panel;           /* panel visible */
extern gboolean  ggv_toolbar;         /* toolbar visible */
extern gboolean  ggv_toolbar_labels;  /* toolbar has labels */
extern gboolean  ggv_menubar;         /* menubar visible */
extern gboolean  ggv_statusbar;       /* statusbar visible */
extern gboolean  ggv_save_geometry;   /* Save the current geometry for next session */
extern gint      ggv_unit_index;      /* the unit we want to use for coordinates */
extern gboolean  ggv_autojump;        /* auto jump to beginning of the page */

/* default window dimensions */
extern gint ggv_default_width, file_sel_width;
extern gint ggv_default_height, file_sel_height;

void         ggv_prefs_load (void);
void         ggv_prefs_save (void);
GConfClient *ggv_prefs_gconf_client (void);
void         ggv_prefs_add_callback (GgvPrefsCb cb, gpointer data);
void         ggv_prefs_remove_callback (gpointer data);

G_END_DECLS

#endif /* __GGV_PREFS_H__ */
