# Note that this is NOT a relocatable package
%define ver      0.3.0
%define rel      1
%define prefix   /usr

Summary: gIDE
Name: gide
Version: %ver
Release: %rel
Copyright: GPL
Group: Development
Source: http://gide.pn.org/download/gide-%{ver}.tar.gz
BuildRoot: /tmp/gide-root
URL: http://gide.pn.org
Docdir: %{prefix}/doc

Requires: gnome-libs >= 1.0.0
Requires: libglade >= 0.11
Requires: guile >= 1.3

%description
gIDE

gIDE is part of the GNOME project and is an integrated design environment.

%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix --localstatedir=/var/lib
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix --localstatedir=/var/lib
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} \
	localstatedir=$RPM_BUILD_ROOT/var/lib install

strip $RPM_BUILD_ROOT%{prefix}/bin/* || :

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%{prefix}/bin/*
%{prefix}/lib/gide/*
%{prefix}/share/gide/*
%{prefix}/share/locale/*/*/*
%{prefix}/share/pixmaps/*
%{prefix}/share/gnome/apps/Development/*
























