/* ########################################################################

			      class_dict.h

   File: class_dict.h
   Description: 
   Created: Fri Jan 27 10:53:57 MET 1995
   Author: Dominique Leveque
   Modified: Aug 28 1999
   Last maintained by: Oliver Granert

   ########################################################################

   Note: 

   ########################################################################

   Copyright (c) : Dominique Leveque

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ######################################################################## */


#ifndef CLASSDICT_H
#define CLASSDICT_H


/*------------------------------------------------------------------------------
*/
enum ScopeType {
	UNKNOWN_SCOPE,
	PUBLIC_SCOPE,
	PROTECTED_SCOPE,
	PRIVATE_SCOPE
};
typedef enum ScopeType ScopeType;


/*------------------------------------------------------------------------------
*/
struct ParentRec {
  char*             _name;             /*  name of the class parent    */
  ScopeType         _scope;            /*  La nature de l'heritage     */
  LineNumber        _decl_line;        /*  La ligne dans le fichier    */  
  struct ParentRec* _next;             /*  La classe suivante          */
};

typedef struct ParentRec ParentRec;


struct ClassRec;

#define METHOD_ISA_CONSTRUCTOR(decl) (decl & 0x10)
#define METHOD_IS_VIRTUAL(decl) (decl & 0x100)
#define METHOD_IS_INLINE(decl) (decl & 0x8)

struct MethodRec {
  char*             _name;             /*  Le de la methode                    */
  char*             _class_name;       /*  Le nom de la classe                 */
  ScopeType         _scope;            /*  La portee de la methode             */
  int		    _decl;
  FileRec*          _decl_file;        /*  Le fichier de declaration           */
  LineNumber        _decl_line;        /*  La ligne dans le fichier precedent  */
  FileRec*          _impl_file;        /*  Le fichier d'implementation         */
  LineNumber        _impl_line;        /*  La ligne d'implementation           */
  unsigned	    _hide;
  struct MethodRec* _next_marked;      /*  Le pointeur de marquage             */
  struct MethodRec* _next;             /*  La methode suivante                 */
};

typedef struct MethodRec MethodRec;


#define ATTRIBUT_IS_STATIC(decl) (decl & 0x8)

struct AttributeRec {
  char*             _name;             /*  the attributes name                 */
  char*             _class_name;       /*  the class_name                      */
  ScopeType         _scope;            /*  the scope from the attribute        */
  int		        _decl;
  FileRec*          _decl_file;        /*  Le fichier de declaration           */
  LineNumber        _decl_line;        /*  La ligne dans le fichier precedent  */
  unsigned	        _hide;
  struct AttributeRec* _next_marked;   /*  Le pointeur de marquage             */
  struct AttributeRec* _next;          /*  L'attribut suivant                  */
};

typedef struct AttributeRec AttributeRec;


/*------------------------------------------------------------------------------
*/
struct ClassRec {
  char*            _name;              /*  La nom de la classe                 */
  FileRec*         _decl_file;         /*  Le fichier de declaration           */
  LineNumber       _decl_line;         /*  La ligne de declaration             */
  ParentRec*       _parents_list;      /*  La liste des parents                */
  int              _parents_count;     /*  Le nombre de parents                */
  MethodRec*       _methods_list;      /*  La liste des methodes               */
  AttributeRec*    _attributes_list;   /*  La liste des methodes               */
  unsigned	   _decl;
  unsigned	   _hide;
  struct ClassRec* _next_marked;       /*  Le pointeur de marquage             */
  struct ClassRec* _next;              /*  La classe suivante                  */
};
typedef struct ClassRec ClassRec;

#define TYPEDEF_TYPE 1
#define TEMPLATE_TYPE 2
#define ISA_TYPEDEF(x)(x & TYPEDEF_TYPE)

/*------------------------------------------------------------------------------
//                         Le dictionnaire des classes
//------------------------------------------------------------------------------
*/

#define CLASS_DICT_SIZE      503

extern ClassRec*  class_dict[CLASS_DICT_SIZE];

extern int        class_count;

/* routines to manipulate the class dictionary */
ClassRec* create_class(char* file_name, unsigned decl);
ClassRec* find_class(char* file_name);
void class_eraze_file(char* file_name);
void garbage_class(void);
void init_class(void);

#endif  /*  CLASSDICT_H  */

