/*
 * Text manipulation plugin
 *
 * Author:
 *   JP Rosevear (jpr@arcavia.com)
 */
#include <gnome.h>
#include <glib.h>

#include "../../src/gI_plugin.h"
#include "../../src/gide.h"
#include "../../src/gI_tools.h"
#include "plugin_text_delete.h"

void
plugin_text_delete_to_bof( Tool *tool, ToolState *state )
{
	g_return_if_fail( state->document );

	gtk_editable_select_region( GTK_EDITABLE( state->document ),
				    gI_text_get_point( state->document ), 0 );

	gI_document_delete_selection( state->document );
}


void
plugin_text_delete_to_eof( Tool *tool, ToolState *state )
{
	g_return_if_fail( state->document );

	gtk_editable_select_region( GTK_EDITABLE( state->document ),
	                            gI_text_get_point( state->document ),
	                            gI_text_get_length( state->document ) );

	gI_document_delete_selection( state->document );
}

static glong
get_end_of_line( GtkWidget *text, glong point )
{
	static glong eol;

	g_return_val_if_fail( text != NULL, 0 );

	for(eol=point;eol<gI_text_get_length( text );eol++)
	{
		if( gtk_editable_get_chars( GTK_EDITABLE( text ), eol, eol+1 )[0] == '\n' )
			break;
	}

	if( eol < 0 )
		eol = 0;
	if( eol > gI_text_get_length( text ) )
		eol = gI_text_get_length( text );

	return( eol );
}

static glong
get_begin_of_line( GtkWidget *text, glong point )
{
	static glong bol;

	g_return_val_if_fail( text != NULL, 0 );

	for(bol=point;bol>0;bol--)
	{
		if( gtk_editable_get_chars( GTK_EDITABLE( text ), bol, bol-1 )[0] == '\n' )
			break;
	}

	if( bol < 0 )
		bol = 0;
	if( bol > gI_text_get_length( text ) )
		bol = gI_text_get_length( text );

	return( bol );
}

void
plugin_text_delete_to_bol( Tool *tool, ToolState *state )
{
	gint point;
	
	g_return_if_fail( state->document );

	point = gI_text_get_point( state->document );
	gtk_editable_select_region( GTK_EDITABLE( state->document ), 
	                            gI_text_get_point( state->document ),
	                            get_begin_of_line( GTK_WIDGET(state->document),
						       point ) );

	gI_document_delete_selection( state->document );
}


void
plugin_text_delete_to_eol( Tool *tool, ToolState *state )
{
	gint point;
	
	g_return_if_fail( state->document );

	point = gI_text_get_point( state->document );
	gtk_editable_select_region( GTK_EDITABLE( state->document ), point,
	                            get_end_of_line( GTK_WIDGET(state->document),
						     point ) );

	gI_document_delete_selection( state->document );
}




