/* $Header: /cvs/gnome/gIDE/src/gI_flist.c,v 1.4 2000/04/16 04:59:56 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gide.h"
#include <sys/types.h>
#include <dirent.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/utsname.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include "gI_file.h"
#include "gI_compile.h"
#include "gI_flist.h"
#include "gI_common.h"


/* globals */
static GtkWidget *files_list;
static gchar *files_list_titles[] = { "Name", "Size", "Date/Time" };


/*
 * IT'S NOT IMPORTANT ... STUFF FROM THIS FILE NOT USED IN GIDE YET....
 */

/*
 CHANGE THIS STUFF TO A CLIST CONTAINING "Name", "Size (/Dir/Link)", "Time" ) !!!!

 AND HOW TO FREE ALL THE ALLOCATED MEMORY AND WHEN????
 */


static void files_list_select( GtkWidget *widget, gint row, gint column, GdkEventButton *event, GtkWidget *window )
{
    gI_flist_item_info *item_info;
    
    if( event->type == GDK_2BUTTON_PRESS )
    {
        item_info = (gI_flist_item_info *) gtk_clist_get_row_data( GTK_CLIST( files_list ), row );
        if( item_info->isdir )
        {
            /* destroy old tree and generate a new one */
            gtk_clist_clear( GTK_CLIST( files_list ) );
            gen_files_list( item_info->filename, item_info->window );
        }
        else
        {
            if( !check_file_open( item_info->filename ) )
            {
                file_open_by_name( main_window, item_info->filename );
            }
            else
            {
                goto_file( item_info->filename );
            }
        }
    }
}


static gchar *flist_file_size( gchar *dname, gchar *fname )
{
    static gchar filesize[100];
    gchar filename[MAXLEN];

    g_snprintf( filename, MAXLEN, "%s/%s", dname, fname );
    sprintf( filesize, "%ld", get_file_size( filename ) );

    return( filesize );
}


static gchar *flist_time( struct stat *f_stat )
{
    static gchar filetime[100];

    strncpy( filetime, ctime( &f_stat->st_mtime ), 100 );

    return( filetime );
}


void gen_files_list( gchar *dirname, GtkWidget *window )
{
    DIR *dir;
    struct dirent *entry;
    struct stat f_stat;
    gI_flist_item_info *item_info;
    gchar cwdbak[STRLEN];
    gchar fwp[MAXLEN];
    gchar *insrow[3];
    int row;

    /* setup clist */
    if( !files_list )
    {
        files_list = gtk_clist_new_with_titles( 3, files_list_titles );
        gtk_clist_column_titles_passive( GTK_CLIST( files_list ) );
        gtk_clist_set_column_width( GTK_CLIST( files_list ), 0, 250 );
        gtk_clist_set_column_width( GTK_CLIST( files_list ), 1, 125 );
        gtk_container_add( GTK_CONTAINER( window ), files_list );
        gtk_signal_connect( GTK_OBJECT( files_list ), "select_row",
                            GTK_SIGNAL_FUNC( files_list_select ), (gpointer) window );
        gtk_widget_show( files_list );
    }
    
    /* correct dirname, FIXME: does somebody know a better way? */

    /* backup current directory */
    getcwd( cwdbak, STRLEN );

    /* fix dirname */
    if( chdir( dirname ) != 0 )
    {
        /* abort */
        g_error( "FUCK: error changing directory\n" );
        return;
    }
    else
    {
        dirname = realloc( dirname, STRLEN );
        getcwd( dirname, STRLEN );
    }

    /* back to old directory */
    chdir( cwdbak );
    
    
    g_print( "Processing '%s'...\n", dirname );
    gtk_window_set_title( GTK_WINDOW( window ), dirname );

    dir = opendir( dirname );

    while( (entry = readdir( dir )) )
    {
        g_snprintf( fwp, MAXLEN, "%s/%s", dirname, entry->d_name );
        if( stat( fwp, &f_stat ) != 0 )
        {
            g_print( "%s: %s\n", fwp, g_strerror( errno ) );
        }
        else
        {
            if( S_ISDIR( f_stat.st_mode ) )
            {
                insrow[0] = entry->d_name;
                insrow[1] = ISDIR;
                insrow[2] = flist_time( &f_stat ); /* date/time */
                item_info = g_malloc0( sizeof( gI_flist_item_info ) );
                item_info->window = window;
                if( dirname[strlen(dirname)] != '/' )
                {
                    item_info->filename = g_strconcat( dirname, "/", entry->d_name, NULL );
                }
                else
                {
                    item_info->filename = g_strconcat( dirname, entry->d_name, NULL );
                }
                item_info->isdir = TRUE;
                row = gtk_clist_append( GTK_CLIST( files_list ), insrow );
                gtk_clist_set_row_data( GTK_CLIST( files_list ), row, (gpointer) item_info );
            }
            if( S_ISLNK( f_stat.st_mode ) )
            {
                insrow[0] = entry->d_name;
                insrow[1] = ISLNK;
                insrow[2] = flist_time( &f_stat ); /* date/time */
                item_info = g_malloc0( sizeof( gI_flist_item_info ) );
                item_info->window = window;
                if( dirname[strlen(dirname)] != '/' )
                {
                    item_info->filename = g_strconcat( dirname, "/", entry->d_name, NULL );
                }
                else
                {
                    item_info->filename = g_strconcat( dirname, entry->d_name, NULL );
                }
                item_info->isdir = FALSE;
                row = gtk_clist_append( GTK_CLIST( files_list ), insrow );
                gtk_clist_set_row_data( GTK_CLIST( files_list ), row, (gpointer) item_info );
            }
            if( S_ISREG( f_stat.st_mode ) )
            {
                insrow[0] = entry->d_name;
                insrow[1] = flist_file_size( dirname, entry->d_name );
                insrow[2] = flist_time( &f_stat ); /* date/time */
                item_info = g_malloc0( sizeof( gI_flist_item_info ) );
                item_info->window = window;
                if( dirname[strlen(dirname)] != '/' )
                {
                    item_info->filename = g_strconcat( dirname, "/", entry->d_name, NULL );
                }
                else
                {
                    item_info->filename = g_strconcat( dirname, entry->d_name, NULL );
                }
                item_info->isdir = FALSE;
                row = gtk_clist_append( GTK_CLIST( files_list ), insrow );
                gtk_clist_set_row_data( GTK_CLIST( files_list ), row, (gpointer) item_info );
            }
        }
    }

    closedir( dir );
}


GtkWidget *setup_list_window()
{
    GtkWidget *window;

    window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    gtk_window_set_title( GTK_WINDOW( window ), "D/F List" );
    gtk_widget_set_usize( window, 600, 400 );
    gtk_signal_connect_object( GTK_OBJECT( window ), "destroy",
                        GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );
    gtk_widget_show( window );

    return( window );
}


void flist(void)
{
    GtkWidget *window;
    
    window = setup_list_window();
    gen_files_list( getcwd(NULL, STRLEN), window );
}


