/* $Header: /cvs/gnome/gIDE/src/gI_search.c,v 1.14 2000/04/22 17:23:01 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include "gide.h"

#ifdef HAVE_GNU_REGEXP
#include <regex.h>
#endif
#ifdef HAVE_GTKTEXT_PATCH
#include <gtksctext.h>
#endif

#include "dialogs.h"
#include "gI_common.h"
#include "gI_compile.h"
#include "gI_search.h"

/* local prototypes */
static void _goto_line( gchar *line, gpointer data );

static void _goto_line( gchar *line, gpointer data )
{
	gint _line;
	GideDocument *current;

	if( !line )
	{
		return;
	}

	gI_window_clear_statusbar( main_window );

	current = gI_window_get_current_doc( main_window );
	g_return_if_fail( current != NULL );

	_line = atoi( line );

	if( ( _line <= 0 ) || ( get_point_from_line( _line ) > gI_text_get_length( current ) ) )
	{
		/* error */
		gI_error_dialog( _("Invalid Line!") );
		return;
	}

	goto_line( _line );
}

/*
 * this __goto_point() function really takes a point,
 * maybe we should re-name the functions one day
 * (there's a goto_point() function in gI_compile.[hc]
 * that takes a line as argument. the difference to
 * goto_line() is that it really goes to the line not
 * just makes them visible on the screen)
 */
void __goto_point( gint point )
{
	GideDocument *current;
	double tl, ln, adjval;
	glong line;

	current = gI_window_get_current_doc( main_window );
	if( !current )
		return;

	line = get_line_from_point( point );

	tl = (double) get_total_lines( GTK_WIDGET(current) );
	ln = (double) line;

	if( tl < 10.0 )
	{
		/* is on the screen */
		return;
	}

	if( ln > tl )
	{
		/* should not happen */
		return;
	}

	gI_text_set_point( current, point );

	/* borrowed from gEdit */
	adjval = (ln * GTK_ADJUSTMENT( gI_text_vadj( current ) )->upper ) / tl - GTK_ADJUSTMENT( gI_text_vadj( current ) )->page_increment;

	gtk_adjustment_set_value( GTK_ADJUSTMENT( gI_text_vadj( current ) ), adjval );

	/* track movement and set statusbar */
	gI_document_track_movement( current );
}


/*
 ---------------------------------------------------------------------
     Function: search_goto_line()
     Desc: Callback-Function /Search/Goto Line
 ---------------------------------------------------------------------
*/
void search_goto_line( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;
	GtkWidget *dlg;

	g_return_if_fail(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW(data);
	document = gI_window_get_current_doc( window );

	g_return_if_fail(window);
	
	dlg = gnome_request_dialog( FALSE,
	                            _("Goto line:"),
	                            "",
	                            10,
	                            _goto_line,
	                            NULL,
	                            GTK_WINDOW(window) );

	gtk_window_set_title( GTK_WINDOW( dlg ), _("Goto line...") );

	gnome_dialog_run_and_close( GNOME_DIALOG( dlg ) );
}


static void
search_not_found( SearchReplaceState *state )
{
	gchar *error;
	
	error = g_strdup_printf( _("[%s] not found!\n"), state->search );
	gI_error_dialog( error );
	g_free( error) ;
}


/*
 ---------------------------------------------------------------------
     Function: search_search()
     Desc: Callback-Function /Search/Search
 ---------------------------------------------------------------------
*/

void search_search( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;
	SearchReplaceState *state;
	
	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window);

	state = gtk_object_get_data( GTK_OBJECT(window),
				     "Gide::search_replace_state");
				     
	if (!state) {
		state = g_new0( SearchReplaceState, 1 );
		gtk_object_set_data( GTK_OBJECT(window),
				     "Gide::search_replace_state",
				     state );
	}

	dialog_search_replace( window, state );
}

/*
 ---------------------------------------------------------------------
     Function: search_again()
     Desc: Callback-Function /Search/Search Again
 ---------------------------------------------------------------------
*/

void search_again( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;
	SearchReplaceState *state;
	
	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window);

	state = gtk_object_get_data( GTK_OBJECT(window),
				     "Gide::search_replace_state");

	g_return_if_fail( state );

	state->start = gI_text_get_point( document );

	
	if ( state->back && GTK_EDITABLE(document)->has_selection )
		state->start--;
		
	state->found = gI_document_search( document, state );

	if ( state->found == -1 )
		search_not_found( state );
}


/*
 ---------------------------------------------------------------------
     Function: search_replace()
     Desc: Callback-Function /Search/Replace
 ---------------------------------------------------------------------
*/

void
search_replace( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;
	SearchReplaceState *state;
	
	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window);

	state = gtk_object_get_data( GTK_OBJECT(window),
				     "Gide::search_replace_state");
				     
	if (!state) {
		state = g_new0( SearchReplaceState, 1 );
		gtk_object_set_data( GTK_OBJECT(window),
				     "Gide::search_replace_state",
				     state );
	}

	dialog_search_replace( window, state );
}

void find_in_files( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;
	FileSearchReplaceState *state;
	
	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window);

	state = gtk_object_get_data( GTK_OBJECT(window),
				     "Gide::file_search_replace_state");
				     
	if (!state) {
		state = g_new0( FileSearchReplaceState, 1 );
		gtk_object_set_data( GTK_OBJECT(window),
				     "Gide::file_search_replace_state",
				     state );
	}

	dialog_file_search_replace( window, state );
}

void replace_in_files( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;
	FileSearchReplaceState *state;
	
	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window);

	state = gtk_object_get_data( GTK_OBJECT(window),
				     "Gide::file_search_replace_state");
				     
	if (!state) {
		state = g_new0( FileSearchReplaceState, 1 );
		gtk_object_set_data( GTK_OBJECT(window),
				     "Gide::file_search_replace_state",
				     state );
	}

	dialog_file_search_replace( window, state );
}










